/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.collab.graph;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GenericEntity;
import com.paterva.maltego.core.GenericLink;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.core.MaltegoPart;
import com.paterva.maltego.merging.PartMergeStrategy;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.ui.graph.transactions.GraphOperation;
import com.paterva.maltego.ui.graph.transactions.GraphTransaction;
import com.paterva.maltego.ui.graph.transactions.GraphTransactionBatch;
import java.awt.Point;
import java.util.List;

abstract class TransactionConflictDetector {
    TransactionConflictDetector() {
    }

    public abstract boolean haveConflict(GraphTransactionBatch var1, GraphTransactionBatch var2);

    public static class Default
    extends TransactionConflictDetector {
        public static final String MODIFIED_BY_DESC = "Update last modified properties after conflict";

        @Override
        public boolean haveConflict(GraphTransactionBatch t1, GraphTransactionBatch t2) {
            if (this.isUpdateModifiedByBatch(t1) || this.isUpdateModifiedByBatch(t2)) {
                return false;
            }
            for (GraphTransaction transaction : t1.getTransactions()) {
                if (!this.haveConflict(transaction, t2.getTransactions())) continue;
                return true;
            }
            return false;
        }

        private boolean haveConflict(GraphTransaction transaction, List<GraphTransaction> transactions) {
            GraphOperation op1 = transaction.getOperation();
            if (op1.canConflict()) {
                for (GraphTransaction t : transactions) {
                    GraphOperation op2 = t.getOperation();
                    if (!op2.canConflict() || !this.haveConflict(op1, transaction, op2, t)) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean haveConflict(GraphOperation op1, GraphTransaction t1, GraphOperation op2, GraphTransaction t2) {
            return this.haveOverlapCenters(op1, t1, op2, t2) || this.haveOverlapPaths(op1, t1, op2, t2) || this.haveOverlapEntities(op1, t1, op2, t2) || this.haveOverlapLinks(op1, t1, op2, t2);
        }

        private boolean haveOverlapEntities(GraphOperation op1, GraphTransaction t1, GraphOperation op2, GraphTransaction t2) {
            for (EntityID entity1ID : t1.getEntityIDs()) {
                for (EntityID entity2ID : t2.getEntityIDs()) {
                    MaltegoEntity entity2;
                    MaltegoEntity entity1 = t1.getEntity(entity1ID);
                    if (!this.haveOverlap(op1, entity1, op2, entity2 = t2.getEntity(entity2ID))) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean haveOverlapLinks(GraphOperation op1, GraphTransaction t1, GraphOperation op2, GraphTransaction t2) {
            for (LinkID link1ID : t1.getLinkIDs()) {
                for (LinkID link2ID : t2.getLinkIDs()) {
                    MaltegoLink link2;
                    MaltegoLink link1 = t1.getLink(link1ID);
                    if (!this.haveOverlap(op1, link1, op2, link2 = t2.getLink(link2ID))) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean haveOverlap(GraphOperation op1, MaltegoEntity entity1, GraphOperation op2, MaltegoEntity entity2) {
            EntityID id = (EntityID)entity1.getID();
            if (!id.equals((Object)entity2.getID())) {
                return false;
            }
            if (this.propertiesOverlap((MaltegoPart)entity1, (MaltegoPart)entity2)) {
                return true;
            }
            if (op1 == GraphOperation.AddProperties || op1 == GraphOperation.DeleteProperties || op2 == GraphOperation.AddProperties || op2 == GraphOperation.DeleteProperties) {
                return false;
            }
            if (op1 != GraphOperation.Update || op2 != GraphOperation.Update) {
                throw new IllegalStateException("Must be updates: " + op1 + ", " + op2);
            }
            PartMergeStrategy mergeStrat = PartMergeStrategy.UpdateWithoutProperties;
            GenericEntity testEntity1 = new GenericEntity(id);
            mergeStrat.merge((MaltegoPart)testEntity1, (MaltegoPart)entity1);
            mergeStrat.merge((MaltegoPart)testEntity1, (MaltegoPart)entity2);
            GenericEntity testEntity2 = new GenericEntity(id);
            mergeStrat.merge((MaltegoPart)testEntity2, (MaltegoPart)entity2);
            mergeStrat.merge((MaltegoPart)testEntity2, (MaltegoPart)entity1);
            return !testEntity1.isCopy((MaltegoPart)testEntity2);
        }

        private boolean haveOverlap(GraphOperation op1, MaltegoLink link1, GraphOperation op2, MaltegoLink link2) {
            LinkID id = (LinkID)link1.getID();
            if (!id.equals((Object)link2.getID())) {
                return false;
            }
            if (this.propertiesOverlap((MaltegoPart)link1, (MaltegoPart)link2)) {
                return true;
            }
            if (op1 == GraphOperation.AddProperties || op1 == GraphOperation.DeleteProperties || op2 == GraphOperation.AddProperties || op2 == GraphOperation.DeleteProperties) {
                return false;
            }
            if (op1 != GraphOperation.Update || op2 != GraphOperation.Update) {
                throw new IllegalStateException("Must be updates: " + op1 + ", " + op2);
            }
            PartMergeStrategy mergeStrat = PartMergeStrategy.UpdateWithoutProperties;
            GenericLink testLink1 = new GenericLink(id);
            mergeStrat.merge((MaltegoPart)testLink1, (MaltegoPart)link1);
            mergeStrat.merge((MaltegoPart)testLink1, (MaltegoPart)link2);
            GenericLink testLink2 = new GenericLink(id);
            mergeStrat.merge((MaltegoPart)testLink2, (MaltegoPart)link2);
            mergeStrat.merge((MaltegoPart)testLink2, (MaltegoPart)link1);
            return !testLink1.isCopy((MaltegoPart)testLink2);
        }

        private boolean isUpdateModifiedByBatch(GraphTransactionBatch t1) {
            return MODIFIED_BY_DESC.equals(t1.getDescription().getStringOne());
        }

        private boolean propertiesOverlap(MaltegoPart part1, MaltegoPart part2) {
            for (PropertyDescriptor pd1 : part1.getProperties()) {
                for (PropertyDescriptor pd2 : part2.getProperties()) {
                    if (!pd1.getName().equals(pd2.getName())) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean haveOverlapCenters(GraphOperation op1, GraphTransaction t1, GraphOperation op2, GraphTransaction t2) {
            if (op1 != GraphOperation.Update || op2 != GraphOperation.Update) {
                return false;
            }
            for (String view1 : t1.getViews()) {
                for (String view2 : t2.getViews()) {
                    if (!view1.equals(view2)) continue;
                    for (EntityID entity1ID : t1.getEntityIDs()) {
                        for (EntityID entity2ID : t2.getEntityIDs()) {
                            Point pos1 = t1.getCenter(view1, entity1ID);
                            Point pos2 = t2.getCenter(view2, entity2ID);
                            if (pos1 == null || pos2 == null || pos1.equals(pos2)) continue;
                            return true;
                        }
                    }
                }
            }
            return false;
        }

        private boolean haveOverlapPaths(GraphOperation op1, GraphTransaction t1, GraphOperation op2, GraphTransaction t2) {
            if (op1 != GraphOperation.Update || op2 != GraphOperation.Update) {
                return false;
            }
            for (String view1 : t1.getViews()) {
                for (String view2 : t2.getViews()) {
                    if (!view1.equals(view2)) continue;
                    for (LinkID link1ID : t1.getLinkIDs()) {
                        for (LinkID link2ID : t2.getLinkIDs()) {
                            List path1 = t1.getPath(view1, link1ID);
                            List path2 = t1.getPath(view2, link2ID);
                            if (path1 == null || path2 == null) continue;
                            return true;
                        }
                    }
                }
            }
            return false;
        }
    }

    public static class None
    extends TransactionConflictDetector {
        @Override
        public boolean haveConflict(GraphTransactionBatch t1, GraphTransactionBatch t2) {
            return false;
        }
    }
}

