/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.customicons.imex;

import com.paterva.maltego.archive.mtz.Entry;
import com.paterva.maltego.customicons.imex.IconDescriptor;
import com.paterva.maltego.customicons.imex.IconMetadata;
import com.paterva.maltego.customicons.imex.IconTempDir;
import com.paterva.maltego.customicons.imex.Util;
import com.paterva.maltego.util.FileUtilities;
import com.paterva.maltego.util.IconSize;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class IconFileEntry
extends Entry<IconDescriptor> {
    public static final String DEFAULT_FOLDER = "Icons";
    private static final String CUSTOM = "Custom";
    private final List<IconMetadata> metadatas;

    public IconFileEntry(IconDescriptor icon) {
        super((Object)icon, DEFAULT_FOLDER + IconFileEntry.getSubfolder(icon.getCategory()), icon.getFileObject().getNameExt());
        this.metadatas = null;
    }

    public IconFileEntry(String path, List<IconMetadata> metadatas) {
        super(path);
        this.metadatas = metadatas;
    }

    protected IconDescriptor read(InputStream is) throws IOException {
        IconMetadata metadata;
        String fileName = this.getFileName();
        String lowerFileName = fileName.toLowerCase();
        if (lowerFileName.equals("thumbs.db") || fileName.startsWith(".") || lowerFileName.endsWith(".xml")) {
            return null;
        }
        String folders = this.getFolder();
        String category = Util.getCategory(DEFAULT_FOLDER, folders);
        File tempIconDir = IconTempDir.getRandomSubDir();
        File tempIconFile = new File(tempIconDir, fileName);
        FileUtilities.writeTo((InputStream)is, (File)tempIconFile);
        FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)tempIconFile));
        if (this.metadatas != null && (metadata = this.findMetadata(fileName)) != null) {
            String iconName = metadata.getIconName();
            String sizeStr = fileName.replaceAll("^" + iconName + "(\\d*)\\.[^\\.]+$", "$1");
            IconSize size = IconSize.getSize((String)sizeStr);
            return new IconDescriptor(fileObject, category, iconName, size);
        }
        return new IconDescriptor(fileObject, category);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void write(IconDescriptor iconID, OutputStream os) throws IOException {
        FileObject fileObject = iconID.getFileObject();
        try (InputStream is = fileObject.getInputStream();){
            FileUtil.copy((InputStream)is, (OutputStream)os);
        }
    }

    public static String getSubfolder(String category) {
        if (CUSTOM.equals(category)) {
            return "";
        }
        return "/" + category;
    }

    private IconMetadata findMetadata(String fileName) {
        for (IconMetadata metadata : this.metadatas) {
            if (!fileName.startsWith(metadata.getIconName())) continue;
            for (IconSize size : IconSize.values()) {
                if (!fileName.matches("^" + metadata.getIconName() + size.getPostfix() + "\\.[^\\.]+$")) continue;
                return metadata;
            }
        }
        return null;
    }
}

