/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.customicons.imex;

import com.maltego.tx3.java.api.discovery.IconDataDefinition;
import com.maltego.tx3.java.api.discovery.IconDefinition;
import com.paterva.maltego.customicons.imex.CategorizedIcons;
import com.paterva.maltego.customicons.imex.IconDiscoveryItems;
import com.paterva.maltego.customicons.imex.IconDiscoveryProvider;
import com.paterva.maltego.customicons.imex.IconMetadata;
import com.paterva.maltego.customicons.imex.IconRegistryIcon;
import com.paterva.maltego.discovery.DiscoveryContext;
import com.paterva.maltego.discovery.DiscoveryProvider;
import com.paterva.maltego.json.discovery.JsonDiscoveryContext;
import com.paterva.maltego.json.discovery.JsonDiscoveryProvider;
import com.paterva.maltego.transform.protocol.v3.api.proxy.V3HttpProxy;
import com.paterva.maltego.util.IconSize;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;

public class IconJsonDiscoveryProvider
extends JsonDiscoveryProvider<IconDiscoveryItems>
implements DiscoveryProvider<IconDiscoveryItems> {
    private static final Logger LOG = Logger.getLogger(IconJsonDiscoveryProvider.class.getName());
    private final IconDiscoveryProvider delegate = new IconDiscoveryProvider();

    public IconDiscoveryItems fetch(JsonDiscoveryContext dc) {
        V3HttpProxy proxy = new V3HttpProxy(dc.getV3Url());
        List iconDefList = proxy.listIcons(true);
        CategorizedIcons readIcons = this.readIcons(iconDefList);
        return new IconDiscoveryItems(this, readIcons, (DiscoveryContext)dc);
    }

    private CategorizedIcons readIcons(List<IconDefinition> iconDefList) {
        ArrayList<IconRegistryIcon> iconRegistryList = new ArrayList<IconRegistryIcon>();
        ArrayList<IconMetadata> metadatas = new ArrayList<IconMetadata>();
        for (IconDefinition iconDef : iconDefList) {
            String category = iconDef.getCategory().isEmpty() ? "Custom" : iconDef.getCategory();
            String iconName = iconDef.getName();
            for (IconDataDefinition iconData : iconDef.getData()) {
                try {
                    ByteArrayInputStream iconInputStream = new ByteArrayInputStream(Base64.getDecoder().decode(iconData.getBlob()));
                    Throwable throwable = null;
                    try {
                        BufferedImage iconImage = ImageIO.read(iconInputStream);
                        IconRegistryIcon iconRegistryIcon = new IconRegistryIcon(category, iconName, IconSize.getSize((int)iconData.getSize()), iconImage);
                        iconRegistryList.add(iconRegistryIcon);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (iconInputStream == null) continue;
                        if (throwable != null) {
                            try {
                                ((InputStream)iconInputStream).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        ((InputStream)iconInputStream).close();
                    }
                }
                catch (IOException e) {
                    LOG.log(Level.WARNING, "Failed to read icon with name : {0}", iconDef.getName());
                }
            }
        }
        return CategorizedIcons.fromList(iconRegistryList, metadatas);
    }

    public IconDiscoveryItems getNewAndMerged(IconDiscoveryItems items) {
        return this.delegate.getNewAndMerged(items);
    }

    public void apply(IconDiscoveryItems items) {
        this.delegate.apply(items);
    }
}

