/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.customicons.nodes;

import com.paterva.maltego.imgfactory.icons.IconExistInfo;
import com.paterva.maltego.imgfactory.icons.IconLayerRegistry;
import com.paterva.maltego.imgfactoryapi.ImageFactory;
import com.paterva.maltego.imgfactoryapi.WrappedRegistryIcon;
import com.paterva.maltego.importexport.ConfigNode;
import com.paterva.maltego.seeds.api.HubSeedDescriptor;
import com.paterva.maltego.seeds.api.HubSeeds;
import com.paterva.maltego.seeds.api.registry.HubSeedRegistry;
import com.paterva.maltego.util.ImageCallback;
import java.awt.Image;
import java.io.IOException;
import java.util.stream.Collectors;
import javax.swing.Action;
import org.apache.commons.lang3.StringUtils;
import org.openide.actions.DeleteAction;
import org.openide.nodes.Children;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class IconNode
extends ConfigNode {
    private WrappedRegistryIcon icon;
    private Image image;

    public IconNode(WrappedRegistryIcon icon) {
        this(icon, new InstanceContent());
    }

    private IconNode(WrappedRegistryIcon icon, InstanceContent content) {
        super(Children.LEAF, (Lookup)new AbstractLookup((AbstractLookup.Content)content));
        this.icon = icon;
        this.addLookups(content);
        this.setDisplayName(icon.getName());
        this.setShortDescription(this.getTooltip(icon));
    }

    public WrappedRegistryIcon getIcon() {
        return this.icon;
    }

    private void addLookups(InstanceContent content) {
        content.add((Object)this);
    }

    public boolean isCheckable() {
        return false;
    }

    public boolean canDestroy() {
        IconExistInfo existInfo = new IconExistInfo();
        return !existInfo.isReadOnly(this.icon.getRegistryIcon());
    }

    public void destroy() throws IOException {
        try {
            IconLayerRegistry.getDefault().remove(this.icon.getRegistryIcon());
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        super.destroy();
    }

    public Action[] getActions(boolean context) {
        return new Action[]{SystemAction.get(DeleteAction.class)};
    }

    public Image getIcon(int type) {
        int size = this.getSize(type);
        if (this.image == null) {
            ImageFactory.getDefault().getImage((Object)this.icon.toVirualIcon().toString(), size, size, (ImageCallback)new IconImageCallback());
        }
        return this.image;
    }

    private int getSize(int type) {
        if (type == 1 || type == 3) {
            return 16;
        }
        return 32;
    }

    private String getTooltip(WrappedRegistryIcon icon) {
        HubSeeds hubSeeds = HubSeedRegistry.getDefault().getSeeds(false);
        String tooltip = icon.getHubItems().stream().map(huSeedName -> this.getHubSeedDisplayName(hubSeeds, (String)huSeedName)).collect(Collectors.joining(", "));
        if (StringUtils.isBlank((CharSequence)tooltip)) {
            tooltip = icon.toVirualIcon().toString();
        }
        return tooltip;
    }

    private String getHubSeedDisplayName(HubSeeds hubSeeds, String name) {
        HubSeedDescriptor seed = hubSeeds.getSeedForName(name);
        return seed == null ? name : seed.getDisplayName();
    }

    private class IconImageCallback
    implements ImageCallback {
        private IconImageCallback() {
        }

        public void imageReady(Image img) {
            IconNode.this.image = img;
            IconNode.this.fireIconChange();
        }

        public void imageFailed(Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }
}

