/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.treelist.lazy;

import com.bulenkov.darcula.ui.DarculaModTableUI;
import com.paterva.maltego.util.IconSize;
import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.ui.GraphicsUtils;
import com.paterva.maltego.util.ui.fonts.FontSizeRegistry;
import com.paterva.maltego.util.ui.fonts.OtherComponentsFontSize;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.UIManager;

public class LazyTreelistSettings {
    private static LazyTreelistSettings _default;
    private final int[] _tableColumnWidthDefault = new int[]{10, 29};
    private final int[] _tableColumnWidth = new int[]{-1, -1};
    private final int[] _iconSize = new int[]{-1, -1};
    private static final int _globalFontSize;
    private static final int _globalFontSizeFromPrefs;
    public static final int _globalFontSizeIncrease = 0;

    private LazyTreelistSettings() {
    }

    public static synchronized LazyTreelistSettings getDefault() {
        if (_default == null) {
            _default = new LazyTreelistSettings();
        }
        return _default;
    }

    public int[] getTableColumnWidthDefault() {
        return this._tableColumnWidthDefault;
    }

    public int[] getTableColumnWidth(Font font) {
        if (this._tableColumnWidth[0] == -1 && this._tableColumnWidth[1] == -1) {
            float smallFontSize = this.getTableFontSize(true);
            float normalFontSize = this.getTableFontSize(false);
            Graphics2D g2D = GraphicsUtils.createGraphics2D();
            String text = "_999_";
            g2D.setFont(font.deriveFont(smallFontSize));
            this._tableColumnWidth[0] = Math.max(this._tableColumnWidthDefault[0], (int)Math.ceil(StringUtilities.getStringWidth((Graphics)g2D, (String)text)) + 2);
            g2D.setFont(font.deriveFont(normalFontSize));
            this._tableColumnWidth[1] = Math.max(this._tableColumnWidthDefault[1], (int)Math.ceil(StringUtilities.getStringWidth((Graphics)g2D, (String)text)) + 6);
            g2D.dispose();
        }
        return this._tableColumnWidth;
    }

    public Font getTableFont() {
        return UIManager.getLookAndFeelDefaults().getFont("Table.font");
    }

    public float getTableFontSize(boolean isSmall) {
        return isSmall ? 4.0f : (float)this.getTableFont().getSize();
    }

    public int[] getIconSize() {
        if (this._iconSize[0] == -1 && this._iconSize[1] == -1) {
            Graphics2D g2D = GraphicsUtils.createGraphics2D();
            Font fontBase = this.getTableFont();
            int iconSizeSmall = 6;
            int margin = DarculaModTableUI.getMargin((boolean)true);
            FontMetrics fm = g2D.getFontMetrics(fontBase.deriveFont(this.getTableFontSize(true)));
            this._iconSize[0] = DarculaModTableUI.getHeight((boolean)true, (FontMetrics)fm, (int)iconSizeSmall) - margin;
            int iconSizeNormal = IconSize.TINY.getSize();
            margin = DarculaModTableUI.getMargin((boolean)false);
            fm = g2D.getFontMetrics(fontBase.deriveFont(this.getTableFontSize(false)));
            this._iconSize[1] = DarculaModTableUI.getHeight((boolean)false, (FontMetrics)fm, (int)iconSizeNormal) - margin;
            g2D.dispose();
        }
        return this._iconSize;
    }

    public int getIconWidth(boolean isSmall, int count) {
        return this.getIconWidth(isSmall, count, this.getTableFont());
    }

    public int getIconWidth(boolean isSmall, int count, Font font) {
        Graphics2D g2D = GraphicsUtils.createGraphics2D();
        g2D.setFont(font.deriveFont(this.getTableFontSize(isSmall)));
        int defaultIconSize = this.getIconSize()[isSmall ? 0 : 1];
        int countWidth = (int)Math.ceil(StringUtilities.getStringWidth((Graphics)g2D, (String)Integer.toString(count))) + 2;
        int width = Math.max(defaultIconSize, countWidth);
        g2D.dispose();
        return width;
    }

    static {
        _globalFontSize = OtherComponentsFontSize.DEFAULT;
        _globalFontSizeFromPrefs = Math.max(_globalFontSize, FontSizeRegistry.getDefault().getFontSize("otherComponentsFontSize"));
    }
}

