/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util;

import com.paterva.maltego.util.XmlSerializationException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.simpleframework.xml.Serializer;
import org.simpleframework.xml.core.Persister;
import org.simpleframework.xml.strategy.Strategy;
import org.simpleframework.xml.strategy.TreeStrategy;
import org.simpleframework.xml.strategy.Type;
import org.simpleframework.xml.strategy.Value;
import org.simpleframework.xml.stream.InputNode;
import org.simpleframework.xml.stream.NodeMap;
import org.simpleframework.xml.stream.OutputNode;

public class XmlSerializer {
    public void write(Object obj, OutputStream stream) throws XmlSerializationException {
        ClassLoader orig = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(Serializer.class.getClassLoader());
            Serializer serializer = XmlSerializer.createSerializer();
            OutputStreamWriter writer = new OutputStreamWriter(stream, StandardCharsets.UTF_8);
            serializer.write(obj, (Writer)writer);
        }
        catch (Exception ex) {
            throw new XmlSerializationException(ex.getMessage(), ex);
        }
        finally {
            Thread.currentThread().setContextClassLoader(orig);
        }
    }

    public String toString(Object obj) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        this.write(obj, os);
        return os.toString("UTF-8");
    }

    public <T> T read(Class<? extends T> clazz, InputStream stream) throws XmlSerializationException {
        ClassLoader orig = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(Serializer.class.getClassLoader());
            Serializer serializer = XmlSerializer.createSerializer();
            InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);
            Object object = serializer.read(clazz, (Reader)reader);
            return (T)object;
        }
        catch (Exception ex) {
            throw new XmlSerializationException(ex.getMessage(), ex);
        }
        finally {
            Thread.currentThread().setContextClassLoader(orig);
        }
    }

    public <T> T read(Class<? extends T> clazz, Reader reader) throws XmlSerializationException {
        ClassLoader orig = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(Serializer.class.getClassLoader());
            Serializer serializer = XmlSerializer.createSerializer();
            Object object = serializer.read(clazz, reader);
            return (T)object;
        }
        catch (Exception ex) {
            throw new XmlSerializationException(ex.getMessage(), ex);
        }
        finally {
            Thread.currentThread().setContextClassLoader(orig);
        }
    }

    public <T> T read(Class<? extends T> clazz, String text) throws XmlSerializationException {
        ClassLoader orig = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(Serializer.class.getClassLoader());
            Serializer serializer = XmlSerializer.createSerializer();
            Object object = serializer.read(clazz, text);
            return (T)object;
        }
        catch (Exception ex) {
            throw new XmlSerializationException(ex.getMessage(), ex);
        }
        finally {
            Thread.currentThread().setContextClassLoader(orig);
        }
    }

    private static Serializer createSerializer() {
        return new Persister((Strategy)new RemoveClassStrategy());
    }

    private static class RemoveClassStrategy
    implements Strategy {
        private final TreeStrategy _delegate = new TreeStrategy();

        private RemoveClassStrategy() {
        }

        public Value read(Type type, NodeMap<InputNode> nm, Map map) throws Exception {
            return this._delegate.read(type, nm, map);
        }

        public boolean write(Type type, Object o, NodeMap<OutputNode> nm, Map map) throws Exception {
            boolean b = this._delegate.write(type, o, nm, map);
            nm.remove("class");
            return b;
        }
    }
}

