/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.nodes;

import com.paterva.maltego.bookmarks.ui.BookmarkFactory;
import com.paterva.maltego.typing.editing.propertygrid.editors.ComboBoxPropertyEditor;
import com.paterva.maltego.typing.editors.OptionItemCollection;
import com.paterva.maltego.util.IconSize;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTable;
import org.openide.explorer.propertysheet.InplaceEditor;
import org.openide.util.Utilities;

public class BookmarkPropertyEditor
extends ComboBoxPropertyEditor {
    public BookmarkPropertyEditor(OptionItemCollection items) {
        super(items);
    }

    public boolean isPaintable() {
        return true;
    }

    public void paintValue(Graphics g, Rectangle box) {
        super.paintValue(g, box);
        int yMargin = 0;
        boolean workaround = true;
        if (Utilities.isMac()) {
            JTable jt = new JTable();
            Color color = g.getColor();
            g.setColor(color.equals(jt.getSelectionForeground()) ? jt.getSelectionBackground() : jt.getBackground());
            g.fillRect(0, 0, box.x + box.width, box.y + box.height);
        }
        this.getBookmarkIcon((Integer)this.getValue(), box.height).paintIcon(null, g, box.x, yMargin);
    }

    private Icon getBookmarkIcon(Integer bookmark, int size) {
        return BookmarkFactory.getDefault().getIcon(bookmark, size);
    }

    public InplaceEditor createEditor() {
        InplaceEditor editor = super.createEditor();
        JComponent c = editor.getComponent();
        if (c instanceof JComboBox) {
            JComboBox combo = (JComboBox)c;
            combo.setRenderer(new BookmarkListCellRenderer());
        }
        return editor;
    }

    private class BookmarkListCellRenderer
    extends DefaultListCellRenderer {
        private BookmarkListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            OptionItemCollection.OptionItem item;
            Object itemValue;
            Component c = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (value instanceof OptionItemCollection.OptionItem && ((itemValue = (item = (OptionItemCollection.OptionItem)value).getValue()) == null || itemValue instanceof Integer)) {
                this.setIcon(BookmarkPropertyEditor.this.getBookmarkIcon((Integer)itemValue, IconSize.TINY.getSize()));
                this.setText("");
            }
            return c;
        }
    }
}

