/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphEntity;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.GraphLink;
import com.paterva.maltego.core.GraphPart;
import com.paterva.maltego.core.Guid;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.graph.GraphFreezable;
import com.paterva.maltego.graph.GraphFreezableRegistry;
import com.paterva.maltego.graph.GraphLifeCycleManager;
import com.paterva.maltego.graph.GraphViewManager;
import com.paterva.maltego.graph.selection.GraphSelection;
import com.paterva.maltego.graph.selection.SelectionState;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.structure.GraphStructureMods;
import com.paterva.maltego.graph.store.view.GraphStoreView;
import com.paterva.maltego.graph.store.view.GraphStoreViewFactory;
import com.paterva.maltego.graph.store.view.GraphStoreViewRegistry;
import com.paterva.maltego.graph.wrapper.GraphWrapper;
import com.paterva.maltego.graph.wrapper.MaltegoGraphManager;
import com.paterva.maltego.ui.graph.CustomProperties;
import com.paterva.maltego.ui.graph.GraphView;
import com.paterva.maltego.ui.graph.GraphViewCookie;
import com.paterva.maltego.ui.graph.GraphViewRegistry;
import com.paterva.maltego.ui.graph.HoverContext;
import com.paterva.maltego.ui.graph.ViewCallback;
import com.paterva.maltego.ui.graph.ViewControlAdapter;
import com.paterva.maltego.ui.graph.impl.GraphFullScreenDecorator;
import com.paterva.maltego.ui.graph.impl.OverviewFactory;
import com.paterva.maltego.ui.graph.view2d.BendClearingMoveMode;
import com.paterva.maltego.ui.graph.view2d.CreateEdgeViewMode;
import com.paterva.maltego.ui.graph.view2d.Graph2DRealizerUpdater;
import com.paterva.maltego.ui.graph.view2d.Graph2DViewDescriptor;
import com.paterva.maltego.ui.graph.view2d.Graph2DViewDropSupport;
import com.paterva.maltego.ui.graph.view2d.Graph2DViewExporter;
import com.paterva.maltego.ui.graph.view2d.Graph2DViewPrinter;
import com.paterva.maltego.ui.graph.view2d.HitInfoCache;
import com.paterva.maltego.ui.graph.view2d.MaltegoGraph2DRenderer;
import com.paterva.maltego.ui.graph.view2d.MaltegoGraph2DRendererRegistry;
import com.paterva.maltego.ui.graph.view2d.MouseWheelZoomListener;
import com.paterva.maltego.ui.graph.view2d.PopupAwareEditMode;
import com.paterva.maltego.ui.graph.view2d.PopupModeProvider;
import com.paterva.maltego.ui.graph.view2d.SelectionBoxViewMode;
import com.paterva.maltego.ui.graph.view2d.SloppyTooltipMode;
import com.paterva.maltego.ui.graph.view2d.ViewGraphName;
import com.paterva.maltego.ui.graph.view2d.labels.EntityPropertyLabelSettings;
import com.paterva.maltego.ui.graph.view2d.layout.LayoutChangePropagator;
import com.paterva.maltego.ui.graph.view2d.layout.LayoutSettings;
import com.paterva.maltego.ui.graph.view2d.painter.MainEntityPainterAnimatorRegistry;
import com.paterva.maltego.util.ui.dialog.FullScreenManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DropTarget;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import yguard.A.A.D;
import yguard.A.A.H;
import yguard.A.A.K;
import yguard.A.A.Y;
import yguard.A.I.M;
import yguard.A.J.BA;
import yguard.A.J.LC;
import yguard.A.J.MC;
import yguard.A.J.SA;
import yguard.A.J.U;
import yguard.A.J.YA;
import yguard.A.J._;
import yguard.A.J.gA;
import yguard.A.J.mB;
import yguard.A.J.oA;
import yguard.A.J.q;
import yguard.A.J.wA;

public abstract class Graph2DViewAdapter
implements ViewControlAdapter {
    private static final Logger LOG = Logger.getLogger(Graph2DViewAdapter.class.getName());
    private U _view;
    private final GraphID _graphID;
    private ViewCallback _viewCallback;
    private boolean _firstShowing = true;
    private boolean _isFullScreenDecorated = false;
    private YA _overview;
    private GraphView _graphView;
    private final InstanceContent _content = new InstanceContent();
    private final Lookup _lookup = new AbstractLookup((AbstractLookup.Content)this._content);
    private Graph2DRealizerUpdater _realizerUpdater;
    private MaltegoGraph2DRenderer _renderer;
    private boolean _closed = false;
    private GraphSelection _selection;
    private SelectionSyncListener _selectionListener;
    private GraphStoreView _graphStoreView;
    private PropertyChangeListener _fullScreenListener;

    public Graph2DViewAdapter(GraphID graphID) {
        LOG.log(Level.FINE, "GraphID: {0}", graphID);
        this._graphID = graphID;
        GraphLifeCycleManager.getDefault().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue().equals(Graph2DViewAdapter.this._graphID)) {
                    if ("graphClosing".equals(evt.getPropertyName())) {
                        Graph2DViewAdapter.this.onGraphClosing();
                    } else if ("graphClosed".equals(evt.getPropertyName())) {
                        GraphLifeCycleManager.getDefault().removePropertyChangeListener((PropertyChangeListener)this);
                        Graph2DViewAdapter.this.onGraphClosed();
                    }
                }
            }
        });
    }

    @Override
    public void onGraphLoaded() {
        LOG.log(Level.FINE, "onGraphLoaded(): {0} start", this._graphID);
        try {
            q er;
            this._graphStoreView = GraphStoreViewFactory.getDefault().create(this._graphID);
            this._graphStoreView.open();
            SA graph = (SA)MaltegoGraphManager.createWrapper((GraphID)this._graphID, (GraphStoreView)this._graphStoreView).getGraph();
            U view = this.getView();
            view.setGraph2D(graph);
            this._selection = GraphSelection.forGraph((GraphID)this._graphID);
            this._selectionListener = new SelectionSyncListener();
            this._selection.addPropertyChangeListener((PropertyChangeListener)this._selectionListener);
            GraphStoreView graphStoreView = GraphStoreViewRegistry.getDefault().getDefaultView(this._graphID);
            graphStoreView.getGraphStructureStore().addPropertyChangeListener((PropertyChangeListener)this._selectionListener);
            graph.A((_)this._selectionListener);
            graph.A((Object)"IS_EDITING_DPKEY", (K)graph.\u00ba());
            ViewGraphName.set((D)graph, this.getDescriptor().getName());
            GraphView graphView = this.getGraphView();
            GraphViewRegistry.set((D)graph, graphView);
            BA nr = this.getDescriptor().createDefaultNodeRealizer();
            if (nr != null) {
                graph.B(nr);
            }
            if ((er = this.getDescriptor().createDefaultEdgeRealizer()) != null) {
                graph.A(er);
            }
            this._content.set(Collections.emptyList(), null);
            this._content.add((Object)graphView);
            this._content.add((Object)new Graph2DViewPrinter(this.getView()));
            this._content.add((Object)new Graph2DViewExporter(this.getView()));
            this.onGraphChanged(null, graph);
            this._realizerUpdater = new Graph2DRealizerUpdater();
            this._realizerUpdater.setGraph(graph);
            this._graphStoreView.syncWithModel();
            this._renderer.setGraphID(this._graphID);
            MainEntityPainterAnimatorRegistry.getDefault().register(this._graphID);
            EntityPropertyLabelSettings.getDefault(this._graphID);
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        LOG.log(Level.FINE, "onGraphLoaded(): {0} end", this._graphID);
    }

    protected void onGraphClosing() {
        LOG.log(Level.FINE, "onGraphClosing(): {0}", this._graphID);
        this._closed = true;
        if (this._selection != null) {
            this._selection.removePropertyChangeListener((PropertyChangeListener)this._selectionListener);
        }
        this._selectionListener = null;
    }

    protected void onGraphClosed() {
        LOG.log(Level.FINE, "onGraphClosed(): {0}", this._graphID);
        if (this._graphStoreView != null) {
            this._graphStoreView.close(false);
        }
        if (this._view != null) {
            this._view.setBackgroundRenderer(null);
            this._view.setGraph2DRenderer(null);
            ArrayList viewModes = new ArrayList();
            Iterator itr = this._view.getViewModes();
            while (itr.hasNext()) {
                viewModes.add(itr.next());
            }
            for (mB viewMode : viewModes) {
                this._view.removeViewMode(viewMode);
            }
            this._view = null;
            this._graphStoreView = null;
            this._renderer = null;
            this._realizerUpdater = null;
            this._selection = null;
        }
        GraphLifeCycleManager.getDefault().fireGraphClosed(this._graphID);
    }

    @Override
    public GraphID getGraphID() {
        return this._graphID;
    }

    protected void onGraphChanged(SA oldGraph, SA newGraph) {
    }

    @Override
    public void componentOpened() {
        LOG.log(Level.FINE, "componentOpened(): {0}", this._graphID);
    }

    @Override
    public void componentClosed() {
        LOG.log(Level.FINE, "componentClosed(): {0}", this._graphID);
        this._overview = null;
    }

    @Override
    public JComponent getViewControl() {
        return this.getView();
    }

    protected synchronized U getView() {
        if (this._view == null) {
            this._view = this.createView();
        }
        return this._view;
    }

    protected U createView() {
        LOG.log(Level.FINE, "createView(): {0}", this._graphID);
        U view = new U();
        this._renderer = new MaltegoGraph2DRenderer(view, true);
        MaltegoGraph2DRendererRegistry.getDefault().addRenderer(this._graphID, this._renderer);
        this._renderer.setDrawEdgesFirst(true);
        this._renderer.setDrawSelectionOnTop(true);
        view.setGraph2DRenderer((LC)this._renderer);
        view.getCanvasComponent().addMouseWheelListener((MouseWheelListener)((Object)new MouseWheelZoomListener()));
        view.setDropTarget(new DropTarget((Component)view, new Graph2DViewDropSupport(view)));
        view.addViewMode((mB)this.createEditMode());
        view.addViewMode(this.disableGrabFocus((mB)new gA()));
        view.addViewMode(this.disableGrabFocus(new HoverViewMode()));
        view.addViewMode(this.disableGrabFocus((mB)new SloppyTooltipMode()));
        return view;
    }

    protected mB disableGrabFocus(mB mode) {
        mode.setGrabFocusEnabled(false);
        return mode;
    }

    protected wA createEditMode() {
        PopupAwareEditMode editMode = new PopupAwareEditMode();
        editMode.setPopupMode(PopupModeProvider.createPopupMode());
        editMode.setMoveSelectionMode((mB)new BendClearingMoveMode());
        editMode.setSelectionBoxMode((mB)new SelectionBoxViewMode());
        editMode.setCreateEdgeMode((mB)new CreateEdgeViewMode());
        return editMode;
    }

    @Override
    public Lookup getLookup() {
        return this._lookup;
    }

    private synchronized GraphView getGraphView() {
        if (this._graphView == null) {
            this._graphView = new GraphViewAdapter();
        }
        return this._graphView;
    }

    @Override
    public void prepareToShow() {
    }

    @Override
    public void componentShowing() {
        LOG.log(Level.FINE, "componentShowing(): {0}", this._graphID);
        if (this._firstShowing) {
            this._firstShowing = false;
            this._view.repaint();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Graph2DViewAdapter.this.zoomToFit();
                }
            });
        }
        if (this._fullScreenListener == null) {
            FullScreenManager fullScreenManager = FullScreenManager.getDefault();
            if (this._isFullScreenDecorated != fullScreenManager.isFullScreen()) {
                this.fullScreenChanged(fullScreenManager.isFullScreen());
            }
            this._fullScreenListener = new FullScreenListener();
            fullScreenManager.addPropertyChangeListener(this._fullScreenListener);
        }
    }

    private void zoomToFit() {
        this._view.fitContent();
        this._view.getGraph2D().\u0107();
    }

    private void fullScreenChanged(boolean isFullScreen) {
        LOG.log(Level.FINE, "fullScreenChanged(): {0} {1}", new Object[]{this._graphID, isFullScreen});
        if (isFullScreen) {
            this.componentPreFullScreenEnabled();
        } else {
            this.componentPostFullScreenDisabled();
        }
    }

    @Override
    public void componentHidden() {
        LOG.log(Level.FINE, "componentHidden(): {0}", this._graphID);
        FullScreenManager.getDefault().removePropertyChangeListener(this._fullScreenListener);
        this._fullScreenListener = null;
        if (this._isFullScreenDecorated) {
            this.fullScreenChanged(false);
        }
    }

    @Override
    public void componentActivated() {
        LOG.log(Level.FINE, "componentActivated(): {0}", this._graphID);
    }

    @Override
    public void componentDeactivated() {
        LOG.log(Level.FINE, "componentDeactivated(): {0}", this._graphID);
    }

    @Override
    public boolean isFullScreenCapable() {
        return true;
    }

    protected void componentPreFullScreenEnabled() {
        GraphFullScreenDecorator.addFullScreenDecorations(this._graphID, this.getView());
        this.convertWorldForFullScreen(false);
        this._isFullScreenDecorated = true;
    }

    protected void componentPostFullScreenDisabled() {
        U view = this.getView();
        GraphFullScreenDecorator.removeFullScreenDecorations(view);
        this.convertWorldForFullScreen(true);
        this._isFullScreenDecorated = false;
    }

    private void convertWorldForFullScreen(boolean reverse) {
        int direction = reverse ? -1 : 1;
        U view = this.getView();
        Rectangle deviceBounds = WindowManager.getDefault().getMainWindow().getGraphicsConfiguration().getBounds();
        Component tcParent = this.getTCParent();
        if (tcParent != null) {
            Point locationOnScreen = tcParent.getLocation();
            SwingUtilities.convertPointToScreen(locationOnScreen, tcParent.getParent());
            double toWorldCoordX = view.toWorldCoordX(direction * (deviceBounds.x - locationOnScreen.x));
            double toWorldCoordY = view.toWorldCoordY(direction * (deviceBounds.y - locationOnScreen.y));
            view.setViewPoint((int)toWorldCoordX, (int)toWorldCoordY);
        } else {
            System.out.println("WARNING: TopComponent of graph view not found");
        }
    }

    private Component getTCParent() {
        U view = this.getView();
        for (Container parent = view.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof TopComponent)) continue;
            return parent;
        }
        return null;
    }

    @Override
    public JComponent getToolbar() {
        Action[] actions = this.getViewActions();
        if (actions == null || actions.length == 0) {
            return null;
        }
        JToolBar toolbar = new JToolBar();
        for (Action action : actions) {
            if (action == null) {
                toolbar.addSeparator();
                continue;
            }
            toolbar.add(action);
        }
        toolbar.setOpaque(false);
        toolbar.setFloatable(false);
        return toolbar;
    }

    protected Action[] getViewActions() {
        return null;
    }

    protected Graph2DViewDescriptor getDescriptor() {
        return (Graph2DViewDescriptor)this._viewCallback.getDescriptor();
    }

    @Override
    public void setViewCallback(ViewCallback callback) {
        this._viewCallback = callback;
        callback.getTopComponent().getActionMap();
    }

    @Override
    public ViewCallback getViewCallback() {
        return this._viewCallback;
    }

    @Override
    public void addInput(KeyStroke keyStroke, Object action) {
        JComponent view = this.getViewControl();
        if (view != null) {
            view.getInputMap(1).put(keyStroke, action);
        }
    }

    @Override
    public CustomProperties getCustomProperties() {
        return null;
    }

    protected void setLayout(LayoutSettings layoutSettings, boolean forceLayout) {
    }

    protected LayoutSettings getLayoutSettings() {
        return null;
    }

    protected void setFreezeLayout(boolean freeze) {
    }

    protected boolean isLayoutFrozen() {
        return true;
    }

    protected void setInteractiveLayout(boolean interactive) {
    }

    protected boolean isInteractiveLayout() {
        return false;
    }

    protected PropertyChangeSupport getLayoutChangeSupport() {
        return null;
    }

    private class SelectionSyncListener
    implements PropertyChangeListener,
    _ {
        private boolean _isSyncing = false;

        private SelectionSyncListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!this._isSyncing) {
                this._isSyncing = true;
                SA graph = Graph2DViewAdapter.this._view.getGraph2D();
                graph.\u00cc();
                try {
                    String propName = evt.getPropertyName();
                    GraphSelection selection = GraphSelection.forGraph((GraphID)Graph2DViewAdapter.this._graphID);
                    GraphWrapper wrapper = MaltegoGraphManager.getWrapper((GraphID)Graph2DViewAdapter.this._graphID);
                    if ("selectionChanged".equals(propName)) {
                        LOG.log(Level.FINE, "Graph Store selection changed, syncying to yFiles: {0}", Graph2DViewAdapter.this._graphID);
                        graph.\u00f5();
                        Set entities = selection.getSelectedViewEntities();
                        if (!entities.isEmpty()) {
                            for (EntityID entity : entities) {
                                Y node = wrapper.node(entity);
                                if (node == null) continue;
                                graph.A(node, true);
                            }
                        } else {
                            Set links = selection.getSelectedViewLinks();
                            if (!links.isEmpty()) {
                                for (LinkID link : links) {
                                    H edge = wrapper.edge(link);
                                    if (edge == null) continue;
                                    graph.B(edge, true);
                                }
                            }
                        }
                    } else if ("structureModified".equals(propName)) {
                        LOG.log(Level.FINE, "Graph Store structure changed, updating yFiles selection: {0}", Graph2DViewAdapter.this._graphID);
                        GraphStructureMods mods = (GraphStructureMods)evt.getNewValue();
                        for (Map.Entry entry : mods.getCollectionMods().entrySet()) {
                            EntityID entityID = (EntityID)entry.getKey();
                            Y node = wrapper.node(entityID);
                            if (node == null) continue;
                            graph.A(node, selection.getViewSelectionState(entityID) != SelectionState.NO);
                        }
                    }
                }
                finally {
                    this._isSyncing = false;
                    graph.\u00a3();
                    graph.\u0107();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onGraph2DSelectionEvent(oA e2) {
            if (!this._isSyncing) {
                LOG.log(Level.FINE, "yFiles selection changed, syncing selection to Graph Store: {0}", Graph2DViewAdapter.this._graphID);
                this._isSyncing = true;
                SA graph = Graph2DViewAdapter.this._view.getGraph2D();
                try {
                    boolean selected;
                    Object subject = e2.D();
                    GraphWrapper wrapper = MaltegoGraphManager.getWrapper((GraphID)Graph2DViewAdapter.this._graphID);
                    GraphSelection selection = GraphSelection.forGraph((GraphID)Graph2DViewAdapter.this._graphID);
                    if (subject instanceof Y) {
                        Y node = (Y)subject;
                        selected = graph.g(node);
                        EntityID entityID = wrapper.entityID(node);
                        selection.setViewEntitiesSelected(Collections.singleton(entityID), selected);
                    }
                    if (subject instanceof H) {
                        H edge = (H)subject;
                        selected = graph.Z(edge);
                        LinkID linkID = wrapper.linkID(edge);
                        selection.setViewLinksSelected(Collections.singleton(linkID), selected);
                    }
                }
                finally {
                    this._isSyncing = false;
                    graph.\u0107();
                }
            }
        }
    }

    private class FullScreenListener
    implements PropertyChangeListener {
        private FullScreenListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("fullScreenModeChanged".equals(evt.getPropertyName())) {
                Graph2DViewAdapter.this.fullScreenChanged(Boolean.TRUE.equals(evt.getNewValue()));
            }
        }
    }

    private final class HoverViewMode
    extends mB {
        private GraphPart<? extends Guid> _lastHovered;

        public void setActiveView(final U view) {
            super.setActiveView(view);
            final KeyAdapter listener = new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e2) {
                    MouseEvent evt = HoverViewMode.this.getLastMoveEvent();
                    if (evt != null) {
                        HoverViewMode.this.mouseMoved(evt.getX(), evt.getY());
                    }
                }
            };
            view.getCanvasComponent().addKeyListener(listener);
            GraphLifeCycleManager.getDefault().addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("graphClosing".equals(evt.getPropertyName()) && evt.getNewValue().equals(Graph2DViewAdapter.this._graphID)) {
                        view.getCanvasComponent().removeKeyListener(listener);
                        GraphLifeCycleManager.getDefault().removePropertyChangeListener((PropertyChangeListener)this);
                    }
                }
            });
        }

        protected void setHoveredObject(GraphPart<? extends Guid> o) {
            if (this._lastHovered != o) {
                this.fireHoverEvent(o);
            }
            this._lastHovered = o;
        }

        protected void fireHoverEvent(GraphPart<? extends Guid> hoverPart) {
            HoverContext.forContextID("global").setHoverViewPart(hoverPart);
            HoverContext.forContextID("graph").setHoverViewPart(hoverPart);
        }

        public void mouseMoved(double x2, double y2) {
            super.mouseMoved(x2, y2);
            MC info = this.getHitInfo(x2, y2);
            if (info != null) {
                if (info.B()) {
                    this.setHoveredObject(this.toGraphPart(info.V()));
                } else if (info.X()) {
                    this.setHoveredObject(this.toGraphPart(info.T()));
                } else {
                    this.setHoveredObject(null);
                }
            } else {
                this.setHoveredObject(null);
            }
        }

        public void mouseExited(MouseEvent arg0) {
            super.mouseExited(arg0);
            this.setHoveredObject(null);
        }

        protected MC getHitInfo(double x2, double y2) {
            return HitInfoCache.getDefault().getStandardHitInfo(this.view, x2, y2);
        }

        private GraphPart<? extends Guid> toGraphPart(Y node) {
            GraphEntity part = null;
            D graph = node.H();
            if (graph != null) {
                GraphWrapper wrapper = MaltegoGraphManager.getWrapper((D)graph);
                EntityID entityID = wrapper.entityID(node);
                part = new GraphEntity(Graph2DViewAdapter.this._graphID, entityID);
            }
            return part;
        }

        private GraphPart<? extends Guid> toGraphPart(H edge) {
            GraphLink part = null;
            D graph = edge.a();
            if (graph != null) {
                GraphWrapper wrapper = MaltegoGraphManager.getWrapper((D)graph);
                LinkID linkID = wrapper.linkID(edge);
                part = new GraphLink(Graph2DViewAdapter.this._graphID, linkID);
            }
            return part;
        }
    }

    private final class GraphViewAdapter
    implements GraphViewCookie,
    GraphView {
        public GraphViewAdapter() {
            this.init();
        }

        private void init() {
            LayoutChangePropagator.getInstance().register(this);
        }

        @Override
        public GraphView getGraphView() {
            return this;
        }

        @Override
        public SA getViewGraph() {
            return GraphViewManager.getDefault().getViewGraph(Graph2DViewAdapter.this.getGraphID());
        }

        @Override
        public void center(Y node) {
            M point = Graph2DViewAdapter.this.getView().getGraph2D().P(node);
            Graph2DViewAdapter.this.getView().setCenter(point.A, point.D);
        }

        @Override
        public void center(H edge) {
            M point1 = Graph2DViewAdapter.this.getView().getGraph2D().S(edge);
            M point2 = Graph2DViewAdapter.this.getView().getGraph2D().O(edge);
            Graph2DViewAdapter.this.getView().setCenter((point1.A + point2.A) / 2.0, (point1.D + point2.D) / 2.0);
        }

        @Override
        public double getZoom() {
            return Graph2DViewAdapter.this.getView().getZoom();
        }

        @Override
        public void setZoom(double zoom) {
            Graph2DViewAdapter.this.getView().setZoom(zoom);
            Graph2DViewAdapter.this.getView().getGraph2D().\u0107();
        }

        @Override
        public void fitContent() {
            Graph2DViewAdapter.this.zoomToFit();
        }

        @Override
        public synchronized JComponent getOverview() {
            if (Graph2DViewAdapter.this._view == null || Graph2DViewAdapter.this._closed) {
                return null;
            }
            if (Graph2DViewAdapter.this._overview == null) {
                Graph2DViewAdapter.this._overview = OverviewFactory.create(Graph2DViewAdapter.this._graphID, Graph2DViewAdapter.this.getView());
            }
            return Graph2DViewAdapter.this._overview;
        }

        @Override
        public JComponent getViewControl() {
            return Graph2DViewAdapter.this.getView();
        }

        private GraphFreezable getFreezable() {
            return GraphFreezableRegistry.getDefault().forGraph(Graph2DViewAdapter.this._graphID);
        }

        public boolean isFrozen() {
            return this.getFreezable().isFrozen();
        }

        public void setFrozen(boolean frozen) {
            this.getFreezable().setFrozen(frozen);
        }

        public boolean hasUpdates() {
            return this.getFreezable().hasUpdates();
        }

        public void updateNow() {
            this.getFreezable().updateNow();
        }

        @Override
        public void doLayout() {
            this.setLayout(this.getLayoutSettings(), true);
        }

        @Override
        public void setLayout(LayoutSettings layoutSettings, boolean forceLayout) {
            Graph2DViewAdapter.this.setLayout(layoutSettings, forceLayout);
        }

        @Override
        public LayoutSettings getLayoutSettings() {
            return Graph2DViewAdapter.this.getLayoutSettings();
        }

        @Override
        public void setFreezeLayout(boolean freeze) {
            Graph2DViewAdapter.this.setFreezeLayout(freeze);
        }

        @Override
        public boolean isLayoutFrozen() {
            return Graph2DViewAdapter.this.isLayoutFrozen();
        }

        @Override
        public void setInteractiveLayout(boolean interactive) {
            Graph2DViewAdapter.this.setInteractiveLayout(interactive);
        }

        @Override
        public boolean isInteractiveLayout() {
            return Graph2DViewAdapter.this.isInteractiveLayout();
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener listener) {
            PropertyChangeSupport changeSupport = Graph2DViewAdapter.this.getLayoutChangeSupport();
            if (changeSupport != null) {
                changeSupport.addPropertyChangeListener(listener);
            }
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener listener) {
            PropertyChangeSupport changeSupport = Graph2DViewAdapter.this.getLayoutChangeSupport();
            if (changeSupport != null) {
                changeSupport.removePropertyChangeListener(listener);
            }
        }

        @Override
        public CustomProperties getCustomProperties() {
            return Graph2DViewAdapter.this.getCustomProperties();
        }
    }
}

