/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.query;

import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.shape.Point;
import com.spatial4j.core.shape.Rectangle;
import com.spatial4j.core.shape.Shape;
import org.apache.lucene.spatial.query.SpatialArgsParser;
import org.apache.lucene.spatial.query.SpatialOperation;

public class SpatialArgs {
    public static final double DEFAULT_DISTERRPCT = 0.025;
    private SpatialOperation operation;
    private Shape shape;
    private Double distErrPct;
    private Double distErr;

    public SpatialArgs(SpatialOperation operation, Shape shape) {
        if (operation == null || shape == null) {
            throw new NullPointerException("operation and shape are required");
        }
        this.operation = operation;
        this.shape = shape;
    }

    public static double calcDistanceFromErrPct(Shape shape, double distErrPct, SpatialContext ctx) {
        if (distErrPct < 0.0 || distErrPct > 0.5) {
            throw new IllegalArgumentException("distErrPct " + distErrPct + " must be between [0 to 0.5]");
        }
        if (distErrPct == 0.0 || shape instanceof Point) {
            return 0.0;
        }
        Rectangle bbox = shape.getBoundingBox();
        Point ctr = bbox.getCenter();
        double y = ctr.getY() >= 0.0 ? bbox.getMaxY() : bbox.getMinY();
        double diagonalDist = ctx.getDistCalc().distance(ctr, bbox.getMaxX(), y);
        return diagonalDist * distErrPct;
    }

    public double resolveDistErr(SpatialContext ctx, double defaultDistErrPct) {
        if (this.distErr != null) {
            return this.distErr;
        }
        double distErrPct = this.distErrPct != null ? this.distErrPct : defaultDistErrPct;
        return SpatialArgs.calcDistanceFromErrPct(this.shape, distErrPct, ctx);
    }

    public void validate() throws IllegalArgumentException {
        if (this.distErr != null && this.distErrPct != null) {
            throw new IllegalArgumentException("Only distErr or distErrPct can be specified.");
        }
    }

    public String toString() {
        return SpatialArgsParser.writeSpatialArgs(this);
    }

    public SpatialOperation getOperation() {
        return this.operation;
    }

    public void setOperation(SpatialOperation operation) {
        this.operation = operation;
    }

    public Shape getShape() {
        return this.shape;
    }

    public void setShape(Shape shape) {
        this.shape = shape;
    }

    public Double getDistErrPct() {
        return this.distErrPct;
    }

    public void setDistErrPct(Double distErrPct) {
        if (distErrPct != null) {
            this.distErrPct = distErrPct;
        }
    }

    public Double getDistErr() {
        return this.distErr;
    }

    public void setDistErr(Double distErr) {
        this.distErr = distErr;
    }
}

