/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.view.list;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.selection.GraphSelection;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.layout.view.LayoutViewAdapter;
import com.paterva.maltego.ui.graph.AbstractViewControlAdapter;
import com.paterva.maltego.ui.graph.GraphSelectionContext;
import com.paterva.maltego.ui.graph.GraphView;
import com.paterva.maltego.ui.graph.TopGraphViewRegistry;
import com.paterva.maltego.ui.graph.ViewControlAdapter;
import com.paterva.maltego.ui.graph.actions.SelectionMode;
import com.paterva.maltego.ui.graph.find.ShowFindBarActionSingleton;
import com.paterva.maltego.ui.graph.find.ShowFindBarListViewAction;
import com.paterva.maltego.ui.graph.find.ViewControlAdapterFocusFind;
import com.paterva.maltego.ui.graph.util.GraphViewStorageUtility;
import com.paterva.maltego.view.list.EntityListDetailViewTopComponent;
import com.paterva.maltego.view.list.OverviewReset;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public final class EntityListView
extends AbstractViewControlAdapter
implements ViewControlAdapterFocusFind {
    private final GraphID graphID;
    private final GraphView graphView;
    private final EntityListDetailViewTopComponent panel;
    private final ShowFindBarListViewAction viewAction;
    private final TopGraphViewRegistry viewRegistry;

    public EntityListView(GraphID graphID) throws GraphStoreException {
        this.graphID = graphID;
        this.panel = new EntityListDetailViewTopComponent(graphID);
        this.graphView = TopGraphViewRegistry.getDefault().getTopGraphView();
        this.viewAction = new ShowFindBarListViewAction((ViewControlAdapter)this);
        this.viewRegistry = TopGraphViewRegistry.getDefault();
    }

    public GraphID getGraphID() {
        return this.graphID;
    }

    public JComponent getViewControl() {
        return this.panel;
    }

    public void componentShowing() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GraphViewStorageUtility.putIsListView((GraphID)EntityListView.this.graphID, (boolean)true);
                EntityListView.this.panel.addExternalNotify();
                OverviewReset.getDefault().dock(true);
                EntityListView.this.panel.updateContentSafe(true);
                GraphSelectionContext.instance().onTopGraphChanged(EntityListView.this.graphView);
                ShowFindBarActionSingleton.getInstance().register(EntityListView.this.graphID, (AbstractAction)EntityListView.this.viewAction);
                EntityListView.this.viewRegistry.onTopGraphViewChanged(null, EntityListView.this.graphView);
            }
        });
    }

    public void componentHidden() {
        GraphViewStorageUtility.putIsListView((GraphID)this.graphID, (boolean)false);
        this.panel.removeExternalNotify();
        OverviewReset.getDefault().dock(false);
        GraphSelectionContext.instance().onTopGraphChanged(this.graphView);
        GraphSelection selection = GraphSelection.forGraph((GraphID)this.graphID);
        if (SelectionMode.isEntities()) {
            selection.setSelectedModelEntities(this.panel.getSelectedEntities());
        } else {
            selection.setSelectedModelLinks(this.panel.getSelectedLinks());
        }
        ShowFindBarActionSingleton.getInstance().deregister(this.graphID, (AbstractAction)this.viewAction);
    }

    public void addInput(KeyStroke keyStroke, Object action) {
        this.panel.getInputMap(1).put(keyStroke, action);
    }

    public JComponent getToolbar() {
        JComponent toolbar = super.getToolbar();
        toolbar.add(new LayoutViewAdapter(this.graphID).getToolbar());
        return toolbar;
    }

    public void focusAndFlashFind() {
        this.panel.focusAndFlashFind();
    }
}

