/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.excel.io;

import com.paterva.maltego.graph.table.TableIO;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class ExcelTableReader
implements TableIO {
    private Workbook workbook;

    public ExcelTableReader(File file) throws IOException, Exception {
        FileInputStream is = new FileInputStream(file);
        this.workbook = WorkbookFactory.create((InputStream)is);
    }

    public void addRow(List<String> row) {
        throw new UnsupportedOperationException("This is a READER only");
    }

    public void mergeHeader(String otherHeader) {
        throw new UnsupportedOperationException("This is a READER only");
    }

    public Iterator<List<String>> rowIterator() {
        return new RowIterator(this.workbook.getSheetAt(0).iterator());
    }

    public int getRowCount() {
        return this.workbook.getSheetAt(0).getLastRowNum();
    }

    private class RowIterator
    implements Iterator<List<String>> {
        private Iterator<Row> iterator;

        public RowIterator(Iterator<Row> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public List<String> next() {
            Row row = this.iterator.next();
            Iterator cellIterator = row.cellIterator();
            Iterable iterable = () -> cellIterator;
            Stream<Cell> stream = StreamSupport.stream(iterable.spliterator(), false);
            return stream.map(Cell::getStringCellValue).collect(Collectors.toList());
        }
    }
}

