/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core2.network.proxy;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.netbeans.core2.network.proxy.DnsUtils;
import org.netbeans.core2.network.proxy.LocalAddressUtil;

public class PacHelperMethods {
    private static final Logger LOG = Logger.getLogger(PacHelperMethods.class.getName());
    private static final String MY_IP = PacHelperMethods.getLocalIP();
    private static final int DNS_TIMEOUT = 2000;
    private static final Pattern IP_PATTERN = Pattern.compile("^(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})$");
    private static final List<String> WEEKDAY_NAMES = Collections.unmodifiableList(Arrays.asList("SUN", "MON", "TUE", "WED", "THU", "FRI", "SAT"));
    private static final List<String> MONTH_NAMES = Collections.unmodifiableList(Arrays.asList("JAN", "FEB", "MAR", "APR", "MAY", "JUN", "JUL", "AUG", "SEP", "OCT", "NOV", "DEC"));
    private static final TimeZone UTC_TIME = TimeZone.getTimeZone("UTC");
    private static final int NOW_YEAR = -1;
    private static final String NOW_MONTH = "---";
    private static final int NOW_DAY = -1;
    private static final int NOW_HOUR = -1;
    private static final int NOW_MINUTE = -1;
    private static final int NOW_SECOND = -1;

    public static boolean isPlainHostName(String host) {
        return !host.contains(".");
    }

    public static boolean dnsDomainIs(String host, String domain) {
        int dotPos = host.indexOf(".");
        if (dotPos != -1 && dotPos < host.length() - 1) {
            if (host.substring(dotPos).equals(domain)) {
                return true;
            }
            if (host.substring(dotPos + 1).equals(domain)) {
                return true;
            }
        }
        return false;
    }

    public static boolean localHostOrDomainIs(String host, String hostdom) {
        if (host.equals(hostdom)) {
            return true;
        }
        return host.equals(PacHelperMethods.getDomains(hostdom)[0]);
    }

    public static boolean isResolvable(String host) {
        try {
            InetAddress.getByName(host);
        }
        catch (UnknownHostException ex) {
            return false;
        }
        return true;
    }

    public static String dnsResolve(String host) {
        InetAddress addr = DnsUtils.dnsResolveWithTimeout(host, 2000);
        if (addr != null) {
            return addr.getHostAddress();
        }
        return null;
    }

    public static String myIpAddress() {
        return MY_IP;
    }

    public static boolean isInNet(String host, String pattern, String mask) {
        String hostIP;
        if (!PacHelperMethods.isValidIP4Address(pattern)) {
            LOG.log(Level.FINE, "Argument ''pattern'' value \"{0}\" is invalid. Must be a numerical IP address", pattern);
            return false;
        }
        try {
            hostIP = InetAddress.getByName(host).getHostAddress();
        }
        catch (UnknownHostException ex) {
            return false;
        }
        String[] hostIPElements = hostIP.split("\\.");
        String[] patternElements = pattern.split("\\.");
        String[] maskElements = mask.split("\\.");
        for (int i = 0; i < hostIPElements.length; ++i) {
            if (i >= maskElements.length || !maskElements[i].equals("255") || hostIPElements[i].equals(patternElements[i])) continue;
            return false;
        }
        return true;
    }

    public static int dnsDomainLevels(String host) {
        if (host == null) {
            return 0;
        }
        return PacHelperMethods.getNoOfOccurrences(host, '.');
    }

    public static boolean shExpMatch(String str, String shexp) {
        String patternStr = PacHelperMethods.createRegexStrFromGlob(shexp);
        try {
            Pattern pattern = Pattern.compile(patternStr);
            if (pattern.matcher(str).matches()) {
                return true;
            }
        }
        catch (PatternSyntaxException ex) {
            LOG.log(Level.FINE, "Regex pattern \"" + patternStr + " is invalid", ex);
            return false;
        }
        return false;
    }

    public static boolean weekdayRange(String wd1, String wd2, String gmt) {
        boolean useUTC = false;
        int params = PacHelperMethods.getNoOfParams(wd1, wd2, gmt);
        switch (params) {
            case 2: {
                useUTC = PacHelperMethods.isGMT(wd2);
                break;
            }
            case 3: {
                useUTC = PacHelperMethods.isGMT(gmt);
            }
        }
        if (useUTC) {
            --params;
        }
        if (params == 1 && PacHelperMethods.isWeekdayName(wd1)) {
            return PacHelperMethods.isInDayRange(wd1, wd1, useUTC);
        }
        if (params == 2 && PacHelperMethods.isWeekdayName(wd1) && PacHelperMethods.isWeekdayName(wd2)) {
            return PacHelperMethods.isInDayRange(wd1, wd2, useUTC);
        }
        LOG.log(Level.FINE, "Invalid parameters used for weekdayRange() function. Parameters were :  wd1={0} wd2={1} gmt={2}", new Object[]{wd1, wd2, gmt});
        return false;
    }

    public static boolean dateRange(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7) {
        boolean useUTC = false;
        int params = PacHelperMethods.getNoOfParams(arg1, arg2, arg3, arg4, arg5, arg6, arg7);
        switch (params) {
            case 2: {
                useUTC = PacHelperMethods.isGMT(arg2);
                break;
            }
            case 3: {
                useUTC = PacHelperMethods.isGMT(arg3);
                break;
            }
            case 4: {
                useUTC = PacHelperMethods.isGMT(arg4);
                break;
            }
            case 5: {
                useUTC = PacHelperMethods.isGMT(arg5);
                break;
            }
            case 6: {
                useUTC = PacHelperMethods.isGMT(arg6);
                break;
            }
            case 7: {
                useUTC = PacHelperMethods.isGMT(arg7);
            }
        }
        if (useUTC) {
            --params;
        }
        if (params == 1) {
            if (PacHelperMethods.isYearNum(arg1)) {
                return PacHelperMethods.isInDateRange(-1, NOW_MONTH, PacHelperMethods.getYearNum(arg1), -1, NOW_MONTH, PacHelperMethods.getYearNum(arg1), useUTC);
            }
            if (PacHelperMethods.isDayNum(arg1)) {
                return PacHelperMethods.isInDateRange(PacHelperMethods.getDayNum(arg1), NOW_MONTH, -1, PacHelperMethods.getDayNum(arg1), NOW_MONTH, -1, useUTC);
            }
            if (PacHelperMethods.isMonthName(arg1)) {
                return PacHelperMethods.isInDateRange(-1, (String)arg1, -1, -1, (String)arg1, -1, useUTC);
            }
        }
        if (params == 2) {
            if (PacHelperMethods.isYearNum(arg1) && PacHelperMethods.isYearNum(arg2)) {
                return PacHelperMethods.isInDateRange(-1, null, PacHelperMethods.getYearNum(arg1), -1, null, PacHelperMethods.getYearNum(arg2), useUTC);
            }
            if (PacHelperMethods.isDayNum(arg1) && PacHelperMethods.isDayNum(arg2)) {
                return PacHelperMethods.isInDateRange(PacHelperMethods.getDayNum(arg1), NOW_MONTH, -1, PacHelperMethods.getDayNum(arg2), NOW_MONTH, -1, useUTC);
            }
            if (PacHelperMethods.isMonthName(arg1) && PacHelperMethods.isMonthName(arg2)) {
                return PacHelperMethods.isInDateRange(-1, (String)arg1, -1, -1, (String)arg2, -1, useUTC);
            }
        }
        if (params == 4) {
            if (PacHelperMethods.isDayNum(arg1) && PacHelperMethods.isDayNum(arg3) && PacHelperMethods.isMonthName(arg2) && PacHelperMethods.isMonthName(arg4)) {
                return PacHelperMethods.isInDateRange(PacHelperMethods.getDayNum(arg1), (String)arg2, -1, PacHelperMethods.getDayNum(arg3), (String)arg4, -1, useUTC);
            }
            if (PacHelperMethods.isMonthName(arg1) && PacHelperMethods.isMonthName(arg3) && PacHelperMethods.isYearNum(arg2) && PacHelperMethods.isYearNum(arg4)) {
                return PacHelperMethods.isInDateRange(-1, (String)arg1, PacHelperMethods.getYearNum(arg2), -1, (String)arg3, PacHelperMethods.getYearNum(arg4), useUTC);
            }
        }
        if (params == 6 && PacHelperMethods.isDayNum(arg1) && PacHelperMethods.isDayNum(arg4) && PacHelperMethods.isMonthName(arg2) && PacHelperMethods.isMonthName(arg5) && PacHelperMethods.isYearNum(arg3) && PacHelperMethods.isYearNum(arg6)) {
            return PacHelperMethods.isInDateRange(PacHelperMethods.getDayNum(arg1), (String)arg2, PacHelperMethods.getYearNum(arg3), PacHelperMethods.getDayNum(arg4), (String)arg5, PacHelperMethods.getYearNum(arg6), useUTC);
        }
        LOG.log(Level.FINE, "Invalid parameters used for dateRange() function. Parameters were :  arg1={0} arg2={1} arg3={2} arg4={3} arg5={4} arg6={5} arg7={6}", new Object[]{arg1, arg2, arg3, arg4, arg5, arg6, arg7});
        return false;
    }

    public static boolean timeRange(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7) {
        boolean useUTC = false;
        int params = PacHelperMethods.getNoOfParams(arg1, arg2, arg3, arg4, arg5, arg6, arg7);
        switch (params) {
            case 2: {
                useUTC = PacHelperMethods.isGMT(arg2);
                break;
            }
            case 3: {
                useUTC = PacHelperMethods.isGMT(arg3);
                break;
            }
            case 4: {
                useUTC = PacHelperMethods.isGMT(arg4);
                break;
            }
            case 5: {
                useUTC = PacHelperMethods.isGMT(arg5);
                break;
            }
            case 6: {
                useUTC = PacHelperMethods.isGMT(arg6);
                break;
            }
            case 7: {
                useUTC = PacHelperMethods.isGMT(arg7);
            }
        }
        if (useUTC) {
            --params;
        }
        if (params == 1 && PacHelperMethods.isHourNum(arg1)) {
            return PacHelperMethods.isInTimeRange(PacHelperMethods.getHourNum(arg1), -1, -1, PacHelperMethods.getHourNum(arg1), -1, -1, useUTC);
        }
        if (params == 2 && PacHelperMethods.isHourNum(arg1) && PacHelperMethods.isHourNum(arg2)) {
            return PacHelperMethods.isInTimeRange(PacHelperMethods.getHourNum(arg1), -1, -1, PacHelperMethods.getHourNum(arg2), -1, -1, useUTC);
        }
        if (params == 4 && PacHelperMethods.isHourNum(arg1) && PacHelperMethods.isHourNum(arg3) && PacHelperMethods.isMinuteNum(arg2) && PacHelperMethods.isMinuteNum(arg4)) {
            return PacHelperMethods.isInTimeRange(PacHelperMethods.getHourNum(arg1), PacHelperMethods.getMinuteNum(arg2), -1, PacHelperMethods.getHourNum(arg3), PacHelperMethods.getMinuteNum(arg4), -1, useUTC);
        }
        if (params == 6 && PacHelperMethods.isHourNum(arg1) && PacHelperMethods.isHourNum(arg4) && PacHelperMethods.isMinuteNum(arg2) && PacHelperMethods.isMinuteNum(arg5) && PacHelperMethods.isSecondNum(arg3) && PacHelperMethods.isSecondNum(arg6)) {
            return PacHelperMethods.isInTimeRange(PacHelperMethods.getHourNum(arg1), PacHelperMethods.getMinuteNum(arg2), PacHelperMethods.getSecondNum(arg3), PacHelperMethods.getHourNum(arg4), PacHelperMethods.getMinuteNum(arg5), PacHelperMethods.getSecondNum(arg6), useUTC);
        }
        LOG.log(Level.FINE, "Invalid parameters used for timeRange() function. Parameters were :  arg1={0} arg2={1} arg3={2} arg4={3} arg5={4} arg6={5} arg7={6}", new Object[]{arg1, arg2, arg3, arg4, arg5, arg6, arg7});
        return false;
    }

    public static void logMe(String functionName, String txt) {
        LOG.log(Level.INFO, "Javascript function {0}() : {1}", new Object[]{functionName, txt});
    }

    private static boolean isValidIP4Address(String ipAddress) {
        if (IP_PATTERN.matcher(ipAddress).matches()) {
            String[] groups = ipAddress.split("\\.");
            for (int i = 0; i <= 3; ++i) {
                int value;
                String segment = groups[i];
                if (segment == null || segment.length() <= 0) {
                    return false;
                }
                try {
                    value = Integer.parseInt(segment);
                }
                catch (NumberFormatException e) {
                    return false;
                }
                if (value <= 255) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static String[] getDomains(String host) {
        String[] doms = host.split("\\.");
        ArrayList<String> domsList = new ArrayList<String>(doms.length);
        for (String dom : doms) {
            if (dom == null || dom.isEmpty()) continue;
            domsList.add(dom);
        }
        return domsList.toArray(new String[domsList.size()]);
    }

    private static String getLocalIP() {
        InetAddress netIfHostAddr = LocalAddressUtil.getLocalNetworkInterfaceAddr();
        if (netIfHostAddr != null) {
            return netIfHostAddr.getHostAddress();
        }
        InetAddress localHostAddr = LocalAddressUtil.getLocalHostAddr();
        if (localHostAddr != null) {
            return localHostAddr.getHostAddress();
        }
        return "127.0.0.1";
    }

    private static String createRegexStrFromGlob(String glob) {
        StringBuilder out = new StringBuilder();
        out.append("^");
        block6: for (int i = 0; i < glob.length(); ++i) {
            char c = glob.charAt(i);
            switch (c) {
                case '*': {
                    out.append(".*");
                    continue block6;
                }
                case '?': {
                    out.append(".");
                    continue block6;
                }
                case '.': {
                    out.append("\\.");
                    continue block6;
                }
                case '\\': {
                    out.append("\\\\");
                    continue block6;
                }
                default: {
                    out.append(c);
                }
            }
        }
        out.append("$");
        return out.toString();
    }

    private static int getCurrentWeekdayPos(boolean useUTC) {
        Calendar now = useUTC ? Calendar.getInstance(UTC_TIME) : Calendar.getInstance();
        return now.get(7) - 1;
    }

    private static boolean isInDayRange(String weekday1Str, String weekday2Str, boolean useUTC) {
        int currentWeekdayPos = PacHelperMethods.getCurrentWeekdayPos(useUTC);
        int wd1Pos = WEEKDAY_NAMES.indexOf(weekday1Str);
        int wd2Pos = WEEKDAY_NAMES.indexOf(weekday2Str);
        if (wd1Pos == -1 && wd2Pos == -1) {
            return false;
        }
        int pointer = wd1Pos;
        while (pointer != wd2Pos) {
            if (pointer == currentWeekdayPos) {
                return true;
            }
            if (++pointer != 7) continue;
            pointer = 0;
        }
        return wd2Pos == currentWeekdayPos;
    }

    private static boolean isGMT(Object str) {
        if (str == null) {
            return false;
        }
        if (str instanceof String) {
            return str.equals("GMT");
        }
        return false;
    }

    private static boolean isYearNum(Object obj) {
        int year = PacHelperMethods.getYearNum(obj);
        return year != Integer.MIN_VALUE;
    }

    private static int getYearNum(Object obj) {
        long year = PacHelperMethods.getNum(obj);
        if (year > 31L && year <= 9999L) {
            return (int)year;
        }
        return Integer.MIN_VALUE;
    }

    private static int getDayNum(Object obj) {
        int day = PacHelperMethods.getNum(obj);
        if (day >= 1 && day <= 31) {
            return day;
        }
        return Integer.MIN_VALUE;
    }

    private static boolean isDayNum(Object obj) {
        int day = PacHelperMethods.getDayNum(obj);
        return day != Integer.MIN_VALUE;
    }

    private static boolean isHourNum(Object obj) {
        int year = PacHelperMethods.getHourNum(obj);
        return year != Integer.MIN_VALUE;
    }

    private static int getHourNum(Object obj) {
        long hour = PacHelperMethods.getNum(obj);
        if (hour >= 0L && hour < 24L) {
            return (int)hour;
        }
        return Integer.MIN_VALUE;
    }

    private static boolean isMinuteNum(Object obj) {
        int minute = PacHelperMethods.getMinuteNum(obj);
        return minute != Integer.MIN_VALUE;
    }

    private static int getMinuteNum(Object obj) {
        long minute = PacHelperMethods.getNum(obj);
        if (minute >= 0L && minute < 60L) {
            return (int)minute;
        }
        return Integer.MIN_VALUE;
    }

    private static boolean isSecondNum(Object obj) {
        return PacHelperMethods.isMinuteNum(obj);
    }

    private static int getSecondNum(Object obj) {
        return PacHelperMethods.getMinuteNum(obj);
    }

    private static int getNum(Object obj) {
        long num = Integer.MIN_VALUE;
        try {
            if (obj instanceof String) {
                num = Integer.valueOf((String)obj).intValue();
            } else if (obj instanceof Integer) {
                num = ((Integer)obj).intValue();
            } else if (obj instanceof Long) {
                num = (Long)obj;
            } else if (obj instanceof Double) {
                num = ((Double)obj).longValue();
            } else if (obj instanceof Float) {
                num = ((Float)obj).longValue();
            }
        }
        catch (NumberFormatException ex) {
            return Integer.MIN_VALUE;
        }
        if (num < Integer.MIN_VALUE || num > Integer.MAX_VALUE) {
            return Integer.MIN_VALUE;
        }
        return (int)num;
    }

    private static boolean isMonthName(Object obj) {
        if (obj instanceof String) {
            return MONTH_NAMES.contains((String)obj);
        }
        return false;
    }

    private static boolean isWeekdayName(String wd) {
        return WEEKDAY_NAMES.contains(wd);
    }

    private static Calendar getNow(boolean useUTC) {
        if (useUTC) {
            return Calendar.getInstance(UTC_TIME);
        }
        return Calendar.getInstance();
    }

    private static long getDateAsLong(Calendar cal) {
        return cal.get(1) * 10000 + (cal.get(2) + 1) * 100 + cal.get(5);
    }

    private static long getNowTimeAsLong(Calendar cal) {
        return cal.get(11) * 10000 + (cal.get(12) * 100 + cal.get(13));
    }

    private static long getDateValAsLong(int day, String mon, int year, Calendar cal) {
        int dayX = day == -1 ? cal.get(5) : day;
        String monX = NOW_MONTH.equals(mon) ? MONTH_NAMES.get(cal.get(2)) : mon;
        int yearX = year == -1 ? cal.get(1) : year;
        return yearX * 10000 + (MONTH_NAMES.indexOf(monX) + 1) * 100 + dayX;
    }

    private static long getTimeValAsLong(int hour, int min, int sec, Calendar cal) {
        int hourX = hour == -1 ? cal.get(11) : hour;
        int minX = min == -1 ? cal.get(12) : min;
        int secX = sec == -1 ? cal.get(13) : sec;
        return hourX * 10000 + minX * 100 + secX;
    }

    private static boolean isInDateRange(int day1, String mon1, int year1, int day2, String mon2, int year2, boolean useUTC) {
        Calendar cal = PacHelperMethods.getNow(useUTC);
        long val1 = PacHelperMethods.getDateValAsLong(day1, mon1, year1, cal);
        long val2 = PacHelperMethods.getDateValAsLong(day2, mon2, year2, cal);
        long now = PacHelperMethods.getDateAsLong(cal);
        return val1 <= now && now <= val2;
    }

    private static boolean isInTimeRange(int hour1, int min1, int sec1, int hour2, int min2, int sec2, boolean useUTC) {
        Calendar cal = PacHelperMethods.getNow(useUTC);
        long val1 = PacHelperMethods.getTimeValAsLong(hour1, min1, sec1, cal);
        long val2 = PacHelperMethods.getTimeValAsLong(hour2, min2, sec2, cal);
        long now = PacHelperMethods.getNowTimeAsLong(cal);
        return val1 <= now && now <= val2;
    }

    private static int getNoOfParams(Object ... objs) {
        int params = 0;
        for (Object obj : objs) {
            if (obj == null) continue;
            if (obj instanceof Number) {
                ++params;
            }
            if (!(obj instanceof String) || ((String)obj).equals("undefined")) continue;
            ++params;
        }
        return params;
    }

    private static int getNoOfOccurrences(String str, char ch) {
        int counter = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) != ch) continue;
            ++counter;
        }
        return counter;
    }
}

