/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.polyglot.HostInteropErrors;
import com.oracle.truffle.polyglot.PolyglotLanguageContext;
import com.oracle.truffle.polyglot.ToHostNode;
import java.lang.reflect.Type;

abstract class PolyglotExecuteNode
extends Node {
    private static final Object[] EMPTY = new Object[0];
    private final PolyglotLanguageContext.ToGuestValuesNode toGuests = PolyglotLanguageContext.ToGuestValuesNode.create();

    PolyglotExecuteNode() {
    }

    public final Object execute(PolyglotLanguageContext languageContext, Object function, Object functionArgsObject, Class<?> resultClass, Type resultType) {
        Object[] argsArray = functionArgsObject instanceof Object[] ? (Object[])functionArgsObject : (functionArgsObject == null ? EMPTY : new Object[]{functionArgsObject});
        Object[] functionArgs = this.toGuests.apply(languageContext, argsArray);
        return this.executeImpl(languageContext, function, functionArgs, resultClass, resultType);
    }

    protected abstract Object executeImpl(PolyglotLanguageContext var1, Object var2, Object[] var3, Class<?> var4, Type var5);

    @Specialization(limit="5")
    Object doCached(PolyglotLanguageContext languageContext, Object function, Object[] functionArgs, Class<?> resultClass, Type resultType, @CachedLibrary(value="function") InteropLibrary interop, @Cached ToHostNode toHost, @Cached ConditionProfile executableCondition, @Cached ConditionProfile instantiableCondition, @Cached BranchProfile unsupportedError, @Cached BranchProfile arityError, @Cached BranchProfile unsupportedArgumentError) {
        Object result;
        block8: {
            boolean executable = executableCondition.profile(interop.isExecutable(function));
            try {
                if (executable) {
                    result = interop.execute(function, functionArgs);
                    break block8;
                }
                if (instantiableCondition.profile(interop.isInstantiable(function))) {
                    result = interop.instantiate(function, functionArgs);
                    break block8;
                }
                throw HostInteropErrors.executeUnsupported(languageContext, function);
            }
            catch (UnsupportedTypeException e) {
                unsupportedArgumentError.enter();
                if (executable) {
                    throw HostInteropErrors.invalidExecuteArgumentType(languageContext, function, functionArgs);
                }
                throw HostInteropErrors.invalidInstantiateArgumentType(languageContext, function, functionArgs);
            }
            catch (ArityException e) {
                arityError.enter();
                if (executable) {
                    throw HostInteropErrors.invalidExecuteArity(languageContext, function, functionArgs, e.getExpectedArity(), e.getActualArity());
                }
                throw HostInteropErrors.invalidInstantiateArity(languageContext, function, functionArgs, e.getExpectedArity(), e.getActualArity());
            }
            catch (UnsupportedMessageException e) {
                unsupportedError.enter();
                throw HostInteropErrors.executeUnsupported(languageContext, function);
            }
        }
        return toHost.execute(result, resultClass, resultType, languageContext, true);
    }
}

