/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.domimpl;

import java.io.File;
import java.util.logging.Level;
import org.lobobrowser.html.FormInput;
import org.lobobrowser.html.domimpl.HTMLBaseInputElement;
import org.lobobrowser.html.domimpl.InputContext;
import org.w3c.dom.html2.HTMLInputElement;

public class HTMLInputElementImpl
extends HTMLBaseInputElement
implements HTMLInputElement {
    private boolean defaultChecked;

    public HTMLInputElementImpl(String name) {
        super(name);
    }

    @Override
    public boolean getDefaultChecked() {
        return this.defaultChecked;
    }

    @Override
    public void setDefaultChecked(boolean defaultChecked) {
        this.defaultChecked = defaultChecked;
    }

    @Override
    public boolean getChecked() {
        InputContext ic = this.inputContext;
        if (ic == null) {
            return this.getAttributeAsBoolean("checked");
        }
        return ic.getChecked();
    }

    @Override
    public void setChecked(boolean checked) {
        InputContext ic = this.inputContext;
        if (ic != null) {
            ic.setChecked(checked);
        }
    }

    @Override
    public int getMaxLength() {
        InputContext ic = this.inputContext;
        return ic == null ? 0 : ic.getMaxLength();
    }

    @Override
    public void setMaxLength(int maxLength) {
        InputContext ic = this.inputContext;
        if (ic != null) {
            ic.setMaxLength(maxLength);
        }
    }

    @Override
    public int getSize() {
        InputContext ic = this.inputContext;
        return ic == null ? 0 : ic.getControlSize();
    }

    @Override
    public void setSize(int size) {
        InputContext ic = this.inputContext;
        if (ic != null) {
            ic.setControlSize(size);
        }
    }

    @Override
    public String getSrc() {
        return this.getAttribute("src");
    }

    @Override
    public void setSrc(String src) {
        this.setAttribute("src", src);
    }

    @Override
    public String getType() {
        String type = this.getAttribute("type");
        return type == null ? null : type.toLowerCase();
    }

    @Override
    public void setType(String type) {
        this.setAttribute("type", type);
    }

    @Override
    public String getUseMap() {
        return this.getAttribute("usemap");
    }

    @Override
    public void setUseMap(String useMap) {
        this.setAttribute("usemap", useMap);
    }

    @Override
    public void click() {
        InputContext ic = this.inputContext;
        if (ic != null) {
            ic.click();
        }
    }

    public boolean isSubmittableWithEnterKey() {
        String type = this.getType();
        return type == null || "".equals(type) || "text".equals(type) || "password".equals(type);
    }

    public boolean isSubmittableWithPress() {
        String type = this.getType();
        return "submit".equals(type) || "image".equals(type);
    }

    public boolean isSubmitInput() {
        String type = this.getType();
        return "submit".equals(type);
    }

    public boolean isImageInput() {
        String type = this.getType();
        return "image".equals(type);
    }

    public boolean isResetInput() {
        String type = this.getType();
        return "reset".equals(type);
    }

    @Override
    void resetInput() {
        InputContext ic = this.inputContext;
        if (ic != null) {
            ic.resetInput();
        }
    }

    @Override
    protected FormInput[] getFormInputs() {
        String type = this.getType();
        String name = this.getName();
        if (name == null) {
            return null;
        }
        if (type == null) {
            return new FormInput[]{new FormInput(name, this.getValue())};
        }
        if ("text".equals(type) || "password".equals(type) || "hidden".equals(type) || "".equals(type)) {
            return new FormInput[]{new FormInput(name, this.getValue())};
        }
        if ("submit".equals(type)) {
            return null;
        }
        if ("radio".equals(type) || "checkbox".equals(type)) {
            if (this.getChecked()) {
                String value = this.getValue();
                if (value == null || value.length() == 0) {
                    value = "on";
                }
                return new FormInput[]{new FormInput(name, value)};
            }
            return null;
        }
        if ("image".equals(type)) {
            return null;
        }
        if ("file".equals(type)) {
            File file = this.getFileValue();
            if (file == null) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.info("getFormInputs(): File input named " + name + " has null file.");
                }
                return null;
            }
            return new FormInput[]{new FormInput(name, file)};
        }
        return null;
    }
}

