/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.util;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;

public class Strings {
    private static final MessageDigest MESSAGE_DIGEST;
    public static final String[] EMPTY_ARRAY;
    private static final String HEX_CHARS = "0123456789ABCDEF";

    private Strings() {
    }

    public static int compareVersions(String version1, String version2, boolean startsWithDigits) {
        if (version1 == null) {
            return version2 == null ? 0 : -1;
        }
        if (version2 == null) {
            return 1;
        }
        if (startsWithDigits) {
            int diff;
            String v1prefix = Strings.leadingDigits(version1);
            String v2prefix = Strings.leadingDigits(version2);
            if (v1prefix.length() == 0) {
                if (v2prefix.length() == 0) {
                    return 0;
                }
                return -1;
            }
            if (v2prefix.length() == 0) {
                return 1;
            }
            try {
                diff = Integer.parseInt(v1prefix) - Integer.parseInt(v2prefix);
            }
            catch (NumberFormatException nfe) {
                diff = 0;
            }
            if (diff == 0) {
                return Strings.compareVersions(version1.substring(v1prefix.length()), version2.substring(v2prefix.length()), false);
            }
            return diff;
        }
        String v1prefix = Strings.leadingNonDigits(version1);
        String v2prefix = Strings.leadingNonDigits(version2);
        if (v1prefix.length() == 0) {
            if (v2prefix.length() == 0) {
                return 0;
            }
            return -1;
        }
        if (v2prefix.length() == 0) {
            return 1;
        }
        int diff = v1prefix.compareTo(v2prefix);
        if (diff == 0) {
            return Strings.compareVersions(version1.substring(v1prefix.length()), version2.substring(v2prefix.length()), true);
        }
        return diff;
    }

    public static String leadingDigits(String text) {
        char ch;
        int length = text.length();
        StringBuffer buffer = null;
        for (int i = 0; i < length && Character.isDigit(ch = text.charAt(i)); ++i) {
            if (buffer == null) {
                buffer = new StringBuffer(3);
            }
            buffer.append(ch);
        }
        return buffer == null ? "" : buffer.toString();
    }

    public static String leadingNonDigits(String text) {
        char ch;
        int length = text.length();
        StringBuffer buffer = null;
        for (int i = 0; i < length && !Character.isDigit(ch = text.charAt(i)); ++i) {
            if (buffer == null) {
                buffer = new StringBuffer(3);
            }
            buffer.append(ch);
        }
        return buffer == null ? "" : buffer.toString();
    }

    public static boolean isBlank(String text) {
        return text == null || "".equals(text);
    }

    public static int countLines(String text) {
        int lbIdx;
        int startIdx = 0;
        int lineCount = 1;
        while ((lbIdx = text.indexOf(10, startIdx)) != -1) {
            ++lineCount;
            startIdx = lbIdx + 1;
        }
        return lineCount;
    }

    public static boolean isJavaIdentifier(String id) {
        if (id == null) {
            return false;
        }
        int len = id.length();
        if (len == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(id.charAt(0))) {
            return false;
        }
        for (int i = 1; i < len; ++i) {
            if (Character.isJavaIdentifierPart(id.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String getJavaStringLiteral(String text) {
        StringBuffer buf = new StringBuffer();
        buf.append('\"');
        int len = text.length();
        block7: for (int i = 0; i < len; ++i) {
            char ch = text.charAt(i);
            switch (ch) {
                case '\\': {
                    buf.append("\\\\");
                    continue block7;
                }
                case '\n': {
                    buf.append("\\n");
                    continue block7;
                }
                case '\r': {
                    buf.append("\\r");
                    continue block7;
                }
                case '\t': {
                    buf.append("\\t");
                    continue block7;
                }
                case '\"': {
                    buf.append("\\\"");
                    continue block7;
                }
                default: {
                    buf.append(ch);
                }
            }
        }
        buf.append('\"');
        return buf.toString();
    }

    public static String getJavaIdentifier(String candidateID) {
        int len = candidateID.length();
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < len; ++i) {
            boolean good;
            char ch = candidateID.charAt(i);
            boolean bl = good = i == 0 ? Character.isJavaIdentifierStart(ch) : Character.isJavaIdentifierPart(ch);
            if (good) {
                buf.append(ch);
                continue;
            }
            buf.append('_');
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMD5(String source) {
        byte[] result;
        byte[] bytes;
        try {
            bytes = source.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ue) {
            throw new IllegalStateException(ue);
        }
        MessageDigest messageDigest = MESSAGE_DIGEST;
        synchronized (messageDigest) {
            MESSAGE_DIGEST.update(bytes);
            result = MESSAGE_DIGEST.digest();
        }
        char[] resChars = new char[32];
        for (byte b : result) {
            int lo4 = b & 0xF;
            int hi4 = (b & 0xF0) >> 4;
            resChars[i * 2] = HEX_CHARS.charAt(hi4);
            resChars[i * 2 + 1] = HEX_CHARS.charAt(lo4);
        }
        return new String(resChars);
    }

    public static String getHash32(String source) throws UnsupportedEncodingException {
        String md5 = Strings.getMD5(source);
        return md5.substring(0, 8);
    }

    public static String getHash64(String source) throws UnsupportedEncodingException {
        String md5 = Strings.getMD5(source);
        return md5.substring(0, 16);
    }

    public static int countChars(String text, char ch) {
        int len = text.length();
        int count = 0;
        for (int i = 0; i < len; ++i) {
            if (ch != text.charAt(i)) continue;
            ++count;
        }
        return count;
    }

    public static String unquote(String text) {
        if (text.startsWith("\"") && text.endsWith("\"")) {
            return text.substring(1, text.length() - 1);
        }
        return text;
    }

    public static String[] split(String phrase) {
        int length = phrase.length();
        ArrayList<String> wordList = new ArrayList<String>();
        StringBuffer word = null;
        block3: for (int i = 0; i < length; ++i) {
            char ch = phrase.charAt(i);
            switch (ch) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    if (word == null) continue block3;
                    wordList.add(word.toString());
                    word = null;
                    continue block3;
                }
                default: {
                    if (word == null) {
                        word = new StringBuffer();
                    }
                    word.append(ch);
                }
            }
        }
        if (word != null) {
            wordList.add(word.toString());
        }
        return wordList.toArray(EMPTY_ARRAY);
    }

    public static String truncate(String text, int maxLength) {
        if (text == null) {
            return null;
        }
        if (text.length() <= maxLength) {
            return text;
        }
        return text.substring(0, Math.max(maxLength - 3, 0)) + "...";
    }

    public static String strictHtmlEncode(String rawText, boolean quotes) {
        StringBuffer output = new StringBuffer();
        int length = rawText.length();
        block6: for (int i = 0; i < length; ++i) {
            char ch = rawText.charAt(i);
            switch (ch) {
                case '&': {
                    output.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    if (quotes) {
                        output.append("&quot;");
                        continue block6;
                    }
                    output.append(ch);
                    continue block6;
                }
                case '<': {
                    output.append("&lt;");
                    continue block6;
                }
                case '>': {
                    output.append("&gt;");
                    continue block6;
                }
                default: {
                    output.append(ch);
                }
            }
        }
        return output.toString();
    }

    public static String trimForAlphaNumDash(String rawText) {
        int length = rawText.length();
        for (int i = 0; i < length; ++i) {
            char ch = rawText.charAt(i);
            if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9' || ch == '-') continue;
            return rawText.substring(0, i);
        }
        return rawText;
    }

    public static String getCRLFString(String original) {
        if (original == null) {
            return null;
        }
        int length = original.length();
        StringBuffer buffer = new StringBuffer();
        boolean lastSlashR = false;
        block4: for (int i = 0; i < length; ++i) {
            char ch = original.charAt(i);
            switch (ch) {
                case '\r': {
                    lastSlashR = true;
                    continue block4;
                }
                case '\n': {
                    lastSlashR = false;
                    buffer.append("\r\n");
                    continue block4;
                }
                default: {
                    if (lastSlashR) {
                        lastSlashR = false;
                        buffer.append("\r\n");
                    }
                    buffer.append(ch);
                }
            }
        }
        return buffer.toString();
    }

    static {
        MessageDigest md;
        EMPTY_ARRAY = new String[0];
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException err) {
            throw new IllegalStateException();
        }
        MESSAGE_DIGEST = md;
    }
}

