/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.chat.users;

import com.paterva.maltego.chatapi.user.UserPresence;
import java.lang.ref.SoftReference;
import java.util.EnumMap;
import java.util.Map;
import javax.swing.Icon;
import org.openide.util.ImageUtilities;

public class UserPresenceIconFactory {
    private static final String RESOURCE_PATH = "com/paterva/maltego/chat/resources/";
    private static Map<UserPresence, SoftReference<Icon>> _icons;

    private UserPresenceIconFactory() {
    }

    public static synchronized Icon getIcon(UserPresence presence) {
        Icon icon;
        SoftReference<Icon> ref = UserPresenceIconFactory.getIcons().get(presence);
        Icon icon2 = icon = ref != null ? ref.get() : null;
        if (icon == null) {
            String name = RESOURCE_PATH + presence.name().toLowerCase() + ".png";
            icon = ImageUtilities.loadImageIcon((String)name, (boolean)true);
            ref = new SoftReference<Icon>(icon);
            _icons.put(presence, ref);
        }
        return icon;
    }

    private static synchronized Map<UserPresence, SoftReference<Icon>> getIcons() {
        if (_icons == null) {
            _icons = new EnumMap<UserPresence, SoftReference<Icon>>(UserPresence.class);
        }
        return _icons;
    }
}

