/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig.internal.apk.v3;

import com.android.apksig.ApkVerifier;
import com.android.apksig.SigningCertificateLineage;
import com.android.apksig.apk.ApkFormatException;
import com.android.apksig.apk.ApkUtils;
import com.android.apksig.internal.apk.ApkSigningBlockUtils;
import com.android.apksig.internal.apk.ContentDigestAlgorithm;
import com.android.apksig.internal.apk.SignatureAlgorithm;
import com.android.apksig.internal.apk.SignatureInfo;
import com.android.apksig.internal.util.ByteBufferUtils;
import com.android.apksig.internal.util.GuaranteedEncodedFormX509Certificate;
import com.android.apksig.internal.util.X509CertificateUtils;
import com.android.apksig.util.DataSource;
import com.android.apksig.util.RunnablesExecutor;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;

public abstract class V3SchemeVerifier {
    private V3SchemeVerifier() {
    }

    public static ApkSigningBlockUtils.Result verify(RunnablesExecutor executor, DataSource apk, ApkUtils.ZipSections zipSections, int minSdkVersion, int maxSdkVersion) throws IOException, NoSuchAlgorithmException, ApkSigningBlockUtils.SignatureNotFoundException {
        ApkSigningBlockUtils.Result result = new ApkSigningBlockUtils.Result(3);
        SignatureInfo signatureInfo = ApkSigningBlockUtils.findSignature(apk, zipSections, -262969152, result);
        DataSource beforeApkSigningBlock = apk.slice(0L, signatureInfo.apkSigningBlockOffset);
        DataSource centralDir = apk.slice(signatureInfo.centralDirOffset, signatureInfo.eocdOffset - signatureInfo.centralDirOffset);
        ByteBuffer eocd = signatureInfo.eocd;
        if (minSdkVersion < 28) {
            minSdkVersion = 28;
        }
        V3SchemeVerifier.verify(executor, beforeApkSigningBlock, signatureInfo.signatureBlock, centralDir, eocd, minSdkVersion, maxSdkVersion, result);
        return result;
    }

    private static void verify(RunnablesExecutor executor, DataSource beforeApkSigningBlock, ByteBuffer apkSignatureSchemeV3Block, DataSource centralDir, ByteBuffer eocd, int minSdkVersion, int maxSdkVersion, ApkSigningBlockUtils.Result result) throws IOException, NoSuchAlgorithmException {
        HashSet<ContentDigestAlgorithm> contentDigestsToVerify = new HashSet<ContentDigestAlgorithm>(1);
        V3SchemeVerifier.parseSigners(apkSignatureSchemeV3Block, contentDigestsToVerify, result);
        if (result.containsErrors()) {
            return;
        }
        ApkSigningBlockUtils.verifyIntegrity(executor, beforeApkSigningBlock, centralDir, eocd, contentDigestsToVerify, result);
        TreeMap<Integer, ApkSigningBlockUtils.Result.SignerInfo> sortedSigners = new TreeMap<Integer, ApkSigningBlockUtils.Result.SignerInfo>();
        for (ApkSigningBlockUtils.Result.SignerInfo signer : result.signers) {
            sortedSigners.put(signer.minSdkVersion, signer);
        }
        int firstMin = 0;
        int lastMax = 0;
        int lastLineageSize = 0;
        ArrayList<SigningCertificateLineage> lineages = new ArrayList<SigningCertificateLineage>(result.signers.size());
        for (ApkSigningBlockUtils.Result.SignerInfo signer : sortedSigners.values()) {
            int currentMin = signer.minSdkVersion;
            int currentMax = signer.maxSdkVersion;
            if (firstMin == 0) {
                firstMin = currentMin;
            } else if (currentMin != lastMax + 1) {
                result.addError(ApkVerifier.Issue.V3_INCONSISTENT_SDK_VERSIONS, new Object[0]);
                break;
            }
            lastMax = currentMax;
            if (signer.signingCertificateLineage == null) continue;
            int currLineageSize = signer.signingCertificateLineage.size();
            if (currLineageSize < lastLineageSize) {
                result.addError(ApkVerifier.Issue.V3_INCONSISTENT_LINEAGES, new Object[0]);
                break;
            }
            lastLineageSize = currLineageSize;
            lineages.add(signer.signingCertificateLineage);
        }
        if (firstMin > minSdkVersion || lastMax < maxSdkVersion) {
            result.addError(ApkVerifier.Issue.V3_MISSING_SDK_VERSIONS, firstMin, lastMax);
        }
        try {
            result.signingCertificateLineage = SigningCertificateLineage.consolidateLineages(lineages);
        }
        catch (IllegalArgumentException e) {
            result.addError(ApkVerifier.Issue.V3_INCONSISTENT_LINEAGES, new Object[0]);
        }
        if (!result.containsErrors()) {
            result.verified = true;
        }
    }

    public static void parseSigners(ByteBuffer apkSignatureSchemeV3Block, Set<ContentDigestAlgorithm> contentDigestsToVerify, ApkSigningBlockUtils.Result result) throws NoSuchAlgorithmException {
        CertificateFactory certFactory;
        ByteBuffer signers;
        try {
            signers = ApkSigningBlockUtils.getLengthPrefixedSlice(apkSignatureSchemeV3Block);
        }
        catch (ApkFormatException e) {
            result.addError(ApkVerifier.Issue.V3_SIG_MALFORMED_SIGNERS, new Object[0]);
            return;
        }
        if (!signers.hasRemaining()) {
            result.addError(ApkVerifier.Issue.V3_SIG_NO_SIGNERS, new Object[0]);
            return;
        }
        try {
            certFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            throw new RuntimeException("Failed to obtain X.509 CertificateFactory", e);
        }
        int signerCount = 0;
        while (signers.hasRemaining()) {
            int signerIndex = signerCount++;
            ApkSigningBlockUtils.Result.SignerInfo signerInfo = new ApkSigningBlockUtils.Result.SignerInfo();
            signerInfo.index = signerIndex;
            result.signers.add(signerInfo);
            try {
                ByteBuffer signer = ApkSigningBlockUtils.getLengthPrefixedSlice(signers);
                V3SchemeVerifier.parseSigner(signer, certFactory, signerInfo, contentDigestsToVerify);
            }
            catch (ApkFormatException | BufferUnderflowException e) {
                signerInfo.addError(ApkVerifier.Issue.V3_SIG_MALFORMED_SIGNER, new Object[0]);
                return;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void parseSigner(ByteBuffer signerBlock, CertificateFactory certFactory, ApkSigningBlockUtils.Result.SignerInfo result, Set<ContentDigestAlgorithm> contentDigestsToVerify) throws ApkFormatException, NoSuchAlgorithmException {
        byte[] certificatePublicKeyBytes;
        int signedMaxSdkVersion;
        SignatureAlgorithm signatureAlgorithm;
        ByteBuffer signedData = ApkSigningBlockUtils.getLengthPrefixedSlice(signerBlock);
        byte[] signedDataBytes = new byte[signedData.remaining()];
        signedData.get(signedDataBytes);
        signedData.flip();
        result.signedData = signedDataBytes;
        int parsedMinSdkVersion = signerBlock.getInt();
        int parsedMaxSdkVersion = signerBlock.getInt();
        result.minSdkVersion = parsedMinSdkVersion;
        result.maxSdkVersion = parsedMaxSdkVersion;
        if (parsedMinSdkVersion < 0 || parsedMinSdkVersion > parsedMaxSdkVersion) {
            result.addError(ApkVerifier.Issue.V3_SIG_INVALID_SDK_VERSIONS, parsedMinSdkVersion, parsedMaxSdkVersion);
        }
        ByteBuffer signatures = ApkSigningBlockUtils.getLengthPrefixedSlice(signerBlock);
        byte[] publicKeyBytes = ApkSigningBlockUtils.readLengthPrefixedByteArray(signerBlock);
        int signatureCount = 0;
        ArrayList<ApkSigningBlockUtils.SupportedSignature> supportedSignatures = new ArrayList<ApkSigningBlockUtils.SupportedSignature>(1);
        while (signatures.hasRemaining()) {
            ++signatureCount;
            try {
                ByteBuffer signature = ApkSigningBlockUtils.getLengthPrefixedSlice(signatures);
                int sigAlgorithmId = signature.getInt();
                byte[] sigBytes = ApkSigningBlockUtils.readLengthPrefixedByteArray(signature);
                result.signatures.add(new ApkSigningBlockUtils.Result.SignerInfo.Signature(sigAlgorithmId, sigBytes));
                signatureAlgorithm = SignatureAlgorithm.findById(sigAlgorithmId);
                if (signatureAlgorithm == null) {
                    result.addWarning(ApkVerifier.Issue.V3_SIG_UNKNOWN_SIG_ALGORITHM, sigAlgorithmId);
                    continue;
                }
                supportedSignatures.add(new ApkSigningBlockUtils.SupportedSignature(signatureAlgorithm, sigBytes));
            }
            catch (ApkFormatException | BufferUnderflowException e) {
                result.addError(ApkVerifier.Issue.V3_SIG_MALFORMED_SIGNATURE, signatureCount);
                return;
            }
        }
        if (result.signatures.isEmpty()) {
            result.addError(ApkVerifier.Issue.V3_SIG_NO_SIGNATURES, new Object[0]);
            return;
        }
        List<ApkSigningBlockUtils.SupportedSignature> signaturesToVerify = null;
        try {
            signaturesToVerify = ApkSigningBlockUtils.getSignaturesToVerify(supportedSignatures, result.minSdkVersion, result.maxSdkVersion);
        }
        catch (ApkSigningBlockUtils.NoSupportedSignaturesException e) {
            result.addError(ApkVerifier.Issue.V3_SIG_NO_SUPPORTED_SIGNATURES, new Object[0]);
            return;
        }
        for (ApkSigningBlockUtils.SupportedSignature signature : signaturesToVerify) {
            PublicKey publicKey;
            signatureAlgorithm = signature.algorithm;
            String jcaSignatureAlgorithm = signatureAlgorithm.getJcaSignatureAlgorithmAndParams().getFirst();
            AlgorithmParameterSpec jcaSignatureAlgorithmParams = signatureAlgorithm.getJcaSignatureAlgorithmAndParams().getSecond();
            String keyAlgorithm = signatureAlgorithm.getJcaKeyAlgorithm();
            try {
                publicKey = KeyFactory.getInstance(keyAlgorithm).generatePublic(new X509EncodedKeySpec(publicKeyBytes));
            }
            catch (Exception e) {
                result.addError(ApkVerifier.Issue.V3_SIG_MALFORMED_PUBLIC_KEY, e);
                return;
            }
            try {
                Signature sig = Signature.getInstance(jcaSignatureAlgorithm);
                sig.initVerify(publicKey);
                if (jcaSignatureAlgorithmParams != null) {
                    sig.setParameter(jcaSignatureAlgorithmParams);
                }
                signedData.position(0);
                sig.update(signedData);
                byte[] sigBytes = signature.signature;
                if (!sig.verify(sigBytes)) {
                    result.addError(ApkVerifier.Issue.V3_SIG_DID_NOT_VERIFY, new Object[]{signatureAlgorithm});
                    return;
                }
                result.verifiedSignatures.put(signatureAlgorithm, sigBytes);
                contentDigestsToVerify.add(signatureAlgorithm.getContentDigestAlgorithm());
            }
            catch (InvalidAlgorithmParameterException | InvalidKeyException | SignatureException e) {
                result.addError(ApkVerifier.Issue.V3_SIG_VERIFY_EXCEPTION, new Object[]{signatureAlgorithm, e});
                return;
            }
        }
        signedData.position(0);
        ByteBuffer digests = ApkSigningBlockUtils.getLengthPrefixedSlice(signedData);
        ByteBuffer certificates = ApkSigningBlockUtils.getLengthPrefixedSlice(signedData);
        int signedMinSdkVersion = signedData.getInt();
        if (signedMinSdkVersion != parsedMinSdkVersion) {
            result.addError(ApkVerifier.Issue.V3_MIN_SDK_VERSION_MISMATCH_BETWEEN_SIGNER_AND_SIGNED_DATA_RECORD, parsedMinSdkVersion, signedMinSdkVersion);
        }
        if ((signedMaxSdkVersion = signedData.getInt()) != parsedMaxSdkVersion) {
            result.addError(ApkVerifier.Issue.V3_MAX_SDK_VERSION_MISMATCH_BETWEEN_SIGNER_AND_SIGNED_DATA_RECORD, parsedMaxSdkVersion, signedMaxSdkVersion);
        }
        ByteBuffer additionalAttributes = ApkSigningBlockUtils.getLengthPrefixedSlice(signedData);
        int certificateIndex = -1;
        while (certificates.hasRemaining()) {
            X509Certificate certificate;
            ++certificateIndex;
            byte[] encodedCert = ApkSigningBlockUtils.readLengthPrefixedByteArray(certificates);
            try {
                certificate = X509CertificateUtils.generateCertificate(encodedCert, certFactory);
            }
            catch (CertificateException e) {
                result.addError(ApkVerifier.Issue.V3_SIG_MALFORMED_CERTIFICATE, certificateIndex, certificateIndex + 1, e);
                return;
            }
            certificate = new GuaranteedEncodedFormX509Certificate(certificate, encodedCert);
            result.certs.add(certificate);
        }
        if (result.certs.isEmpty()) {
            result.addError(ApkVerifier.Issue.V3_SIG_NO_CERTIFICATES, new Object[0]);
            return;
        }
        X509Certificate mainCertificate = (X509Certificate)result.certs.get(0);
        try {
            certificatePublicKeyBytes = ApkSigningBlockUtils.encodePublicKey(mainCertificate.getPublicKey());
        }
        catch (InvalidKeyException e) {
            System.out.println("Caught an exception encoding the public key: " + e);
            e.printStackTrace();
            certificatePublicKeyBytes = mainCertificate.getPublicKey().getEncoded();
        }
        if (!Arrays.equals(publicKeyBytes, certificatePublicKeyBytes)) {
            result.addError(ApkVerifier.Issue.V3_SIG_PUBLIC_KEY_MISMATCH_BETWEEN_CERTIFICATE_AND_SIGNATURES_RECORD, ApkSigningBlockUtils.toHex(certificatePublicKeyBytes), ApkSigningBlockUtils.toHex(publicKeyBytes));
            return;
        }
        int digestCount = 0;
        while (digests.hasRemaining()) {
            ++digestCount;
            try {
                ByteBuffer digest = ApkSigningBlockUtils.getLengthPrefixedSlice(digests);
                int sigAlgorithmId = digest.getInt();
                byte[] byArray = ApkSigningBlockUtils.readLengthPrefixedByteArray(digest);
                result.contentDigests.add(new ApkSigningBlockUtils.Result.SignerInfo.ContentDigest(sigAlgorithmId, byArray));
            }
            catch (ApkFormatException | BufferUnderflowException e) {
                result.addError(ApkVerifier.Issue.V3_SIG_MALFORMED_DIGEST, digestCount);
                return;
            }
        }
        ArrayList<Integer> sigAlgsFromSignaturesRecord = new ArrayList<Integer>(result.signatures.size());
        for (ApkSigningBlockUtils.Result.SignerInfo.Signature signature : result.signatures) {
            sigAlgsFromSignaturesRecord.add(signature.getAlgorithmId());
        }
        ArrayList<Integer> sigAlgsFromDigestsRecord = new ArrayList<Integer>(result.contentDigests.size());
        for (ApkSigningBlockUtils.Result.SignerInfo.ContentDigest digest : result.contentDigests) {
            sigAlgsFromDigestsRecord.add(digest.getSignatureAlgorithmId());
        }
        if (!sigAlgsFromSignaturesRecord.equals(sigAlgsFromDigestsRecord)) {
            result.addError(ApkVerifier.Issue.V3_SIG_SIG_ALG_MISMATCH_BETWEEN_SIGNATURES_AND_DIGESTS_RECORDS, sigAlgsFromSignaturesRecord, sigAlgsFromDigestsRecord);
            return;
        }
        boolean bl = false;
        while (additionalAttributes.hasRemaining()) {
            void var24_42;
            ++var24_42;
            try {
                ByteBuffer attribute = ApkSigningBlockUtils.getLengthPrefixedSlice(additionalAttributes);
                int id = attribute.getInt();
                byte[] value = ByteBufferUtils.toByteArray(attribute);
                result.additionalAttributes.add(new ApkSigningBlockUtils.Result.SignerInfo.AdditionalAttribute(id, value));
                if (id == 1000370060) {
                    try {
                        result.signingCertificateLineage = SigningCertificateLineage.readFromV3AttributeValue(value);
                        SigningCertificateLineage subLineage = result.signingCertificateLineage.getSubLineage((X509Certificate)result.certs.get(0));
                        if (result.signingCertificateLineage.size() == subLineage.size()) continue;
                        result.addError(ApkVerifier.Issue.V3_SIG_POR_CERT_MISMATCH, new Object[0]);
                    }
                    catch (SecurityException e) {
                        result.addError(ApkVerifier.Issue.V3_SIG_POR_DID_NOT_VERIFY, new Object[0]);
                    }
                    catch (IllegalArgumentException e) {
                        result.addError(ApkVerifier.Issue.V3_SIG_POR_CERT_MISMATCH, new Object[0]);
                    }
                    catch (Exception e) {
                        result.addError(ApkVerifier.Issue.V3_SIG_MALFORMED_LINEAGE, new Object[0]);
                    }
                    continue;
                }
                result.addWarning(ApkVerifier.Issue.V3_SIG_UNKNOWN_ADDITIONAL_ATTRIBUTE, id);
            }
            catch (ApkFormatException | BufferUnderflowException e) {
                result.addError(ApkVerifier.Issue.V3_SIG_MALFORMED_ADDITIONAL_ATTRIBUTE, (int)var24_42);
                return;
            }
        }
    }
}

