/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.builder.instruction;

import com.android.tools.smali.dexlib2.Format;
import com.android.tools.smali.dexlib2.Opcode;
import com.android.tools.smali.dexlib2.builder.BuilderInstruction;
import com.android.tools.smali.dexlib2.iface.instruction.formats.Instruction21lh;
import com.android.tools.smali.dexlib2.util.Preconditions;
import javax.annotation.Nonnull;

public class BuilderInstruction21lh
extends BuilderInstruction
implements Instruction21lh {
    public static final Format FORMAT = Format.Format21lh;
    protected final int registerA;
    protected final long literal;

    public BuilderInstruction21lh(@Nonnull Opcode opcode, int registerA, long literal) {
        super(opcode);
        this.registerA = Preconditions.checkByteRegister(registerA);
        this.literal = Preconditions.checkLongHatLiteral(literal);
    }

    @Override
    public int getRegisterA() {
        return this.registerA;
    }

    @Override
    public long getWideLiteral() {
        return this.literal;
    }

    @Override
    public short getHatLiteral() {
        return (short)(this.literal >>> 48);
    }

    @Override
    public Format getFormat() {
        return FORMAT;
    }
}

