/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.immutable.instruction;

import com.android.tools.smali.dexlib2.Format;
import com.android.tools.smali.dexlib2.Opcode;
import com.android.tools.smali.dexlib2.iface.instruction.formats.ArrayPayload;
import com.android.tools.smali.dexlib2.immutable.instruction.ImmutableInstruction;
import com.android.tools.smali.dexlib2.util.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ImmutableArrayPayload
extends ImmutableInstruction
implements ArrayPayload {
    public static final Opcode OPCODE = Opcode.ARRAY_PAYLOAD;
    protected final int elementWidth;
    @Nonnull
    protected final List<Number> arrayElements;

    public ImmutableArrayPayload(int elementWidth, @Nullable List<Number> arrayElements) {
        super(OPCODE);
        this.elementWidth = Preconditions.checkArrayPayloadElementWidth(elementWidth);
        this.arrayElements = Preconditions.checkArrayPayloadElements(elementWidth, arrayElements == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<Number>(arrayElements)));
    }

    @Nonnull
    public static ImmutableArrayPayload of(ArrayPayload instruction) {
        if (instruction instanceof ImmutableArrayPayload) {
            return (ImmutableArrayPayload)instruction;
        }
        return new ImmutableArrayPayload(instruction.getElementWidth(), instruction.getArrayElements());
    }

    @Override
    public int getElementWidth() {
        return this.elementWidth;
    }

    @Override
    @Nonnull
    public List<Number> getArrayElements() {
        return this.arrayElements;
    }

    @Override
    public int getCodeUnits() {
        return 4 + (this.elementWidth * this.arrayElements.size() + 1) / 2;
    }

    @Override
    public Format getFormat() {
        return ImmutableArrayPayload.OPCODE.format;
    }
}

