/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.util;

import java.util.Iterator;
import java.util.function.Function;

public class TransformedIterable<F, T>
implements Iterable<T> {
    final Iterable<? extends F> backingIterable;
    final Function<F, T> transformFunction;

    public TransformedIterable(Iterable<? extends F> backingIterable, Function<F, T> transformFunction) {
        this.backingIterable = backingIterable;
        this.transformFunction = transformFunction;
    }

    @Override
    public final Iterator<T> iterator() {
        return new TransformedIterator<F, T>(this.backingIterable.iterator(), this.transformFunction);
    }

    public static class TransformedIterator<G, U>
    implements Iterator<U> {
        final Iterator<? extends G> backingIterator;
        final Function<G, U> transformFunction;

        public TransformedIterator(Iterable<? extends G> backingIterable, Function<G, U> transformFunction) {
            this.backingIterator = backingIterable.iterator();
            this.transformFunction = transformFunction;
        }

        public TransformedIterator(Iterator<? extends G> backingIterator, Function<G, U> transformFunction) {
            this.backingIterator = backingIterator;
            this.transformFunction = transformFunction;
        }

        @Override
        public final boolean hasNext() {
            return this.backingIterator.hasNext();
        }

        @Override
        public final U next() {
            return this.transformFunction.apply(this.backingIterator.next());
        }

        @Override
        public final void remove() {
            this.backingIterator.remove();
        }
    }
}

