/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import com.android.ddmlib.AdbHelper;
import com.android.ddmlib.CommandFailedException;
import com.android.ddmlib.DdmPreferences;
import com.android.ddmlib.EmulatorConsole;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.Log;
import com.android.prefs.AndroidLocationsSingleton;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class EmulatorConsoleImpl
extends EmulatorConsole {
    private static final String DEFAULT_ENCODING = "ISO-8859-1";
    private static final int WAIT_TIME = 5;
    private static final int STD_TIMEOUT = 5000;
    private static final String HOST = "127.0.0.1";
    private static final String COMMAND_PING = "help\r\n";
    private static final String COMMAND_AVD_NAME = "avd name\r\n";
    private static final String COMMAND_AVD_PATH = "avd path\r\n";
    private static final String COMMAND_KILL = "kill\r\n";
    private static final String COMMAND_AUTH = "auth %1$s\r\n";
    private static final String COMMAND_SCREENRECORD_START = "screenrecord start %1$s\r\n";
    private static final String COMMAND_SCREENRECORD_STOP = "screenrecord stop\r\n";
    private static final Pattern RE_KO = Pattern.compile("KO:\\s+(.*)");
    private static final String RE_AUTH_REQUIRED = "Android Console: Authentication required";
    private static final String EMULATOR_CONSOLE_AUTH_TOKEN = ".emulator_console_auth_token";
    public static final String RESULT_OK = null;
    private static final Pattern sEmulatorRegexp = Pattern.compile("emulator-(\\d+)");
    private static final HashMap<Integer, EmulatorConsoleImpl> sEmulators = new HashMap();
    private static final String LOG_TAG = "EmulatorConsole";
    private final int mPort;
    private SocketChannel mSocketChannel;
    private final byte[] mBuffer = new byte[8192];

    static EmulatorConsoleImpl createConsole(IDevice d11) {
        Integer port = EmulatorConsoleImpl.getEmulatorPortFromSerialNumber(d11.getSerialNumber());
        if (port == null) {
            Log.w(LOG_TAG, "Failed to find emulator port from serial: " + d11.getSerialNumber());
            return null;
        }
        EmulatorConsoleImpl console = EmulatorConsoleImpl.retrieveConsole(port);
        if (!console.checkConnection()) {
            console.close();
            return null;
        }
        return console;
    }

    static Integer getEmulatorPortFromSerialNumber(String serialNumber) {
        Matcher m11 = sEmulatorRegexp.matcher(serialNumber);
        if (m11.matches()) {
            try {
                int port = Integer.parseInt(m11.group(1));
                if (port > 0) {
                    return port;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static EmulatorConsoleImpl retrieveConsole(int port) {
        HashMap<Integer, EmulatorConsoleImpl> hashMap = sEmulators;
        synchronized (hashMap) {
            EmulatorConsoleImpl console = sEmulators.get(port);
            if (console == null) {
                Log.v(LOG_TAG, "Creating emulator console for " + port);
                console = new EmulatorConsoleImpl(port);
                sEmulators.put(port, console);
            }
            return console;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        HashMap<Integer, EmulatorConsoleImpl> hashMap = sEmulators;
        synchronized (hashMap) {
            Log.v(LOG_TAG, "Removing emulator console for " + this.mPort);
            sEmulators.remove(this.mPort);
        }
        try {
            if (this.mSocketChannel != null) {
                this.mSocketChannel.close();
            }
            this.mSocketChannel = null;
        }
        catch (IOException e11) {
            Log.w(LOG_TAG, "Failed to close EmulatorConsole channel");
        }
    }

    private EmulatorConsoleImpl(int port) {
        this.mPort = port;
    }

    private synchronized boolean checkConnection() {
        if (this.mSocketChannel == null) {
            try {
                InetAddress hostAddr = InetAddress.getByName(HOST);
                InetSocketAddress socketAddr = new InetSocketAddress(hostAddr, this.mPort);
                this.mSocketChannel = SocketChannel.open(socketAddr);
                this.mSocketChannel.configureBlocking(false);
                String[] welcome = this.readLines();
                if (welcome == null) {
                    return false;
                }
                if (welcome[0].endsWith(RE_AUTH_REQUIRED) && RESULT_OK != this.sendAuthentication()) {
                    Log.w(LOG_TAG, "Emulator console auth failed (is the emulator running as a different user?)");
                    return false;
                }
            }
            catch (IOException e11) {
                Log.w(LOG_TAG, "Failed to start Emulator console for " + this.mPort);
                return false;
            }
            catch (Throwable e12) {
                Log.w(LOG_TAG, "Failed to get emulator console auth token");
                return false;
            }
        }
        return this.ping();
    }

    private synchronized boolean ping() {
        if (this.sendCommand(COMMAND_PING)) {
            return this.readLines() != null;
        }
        return false;
    }

    @Override
    public synchronized void kill() {
        this.sendCommand(COMMAND_KILL);
    }

    @Override
    public synchronized String getAvdName() {
        try {
            return this.getOutput(COMMAND_AVD_NAME);
        }
        catch (CommandFailedException exception) {
            return exception.getMessage();
        }
        catch (Exception exception) {
            if (exception instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            return null;
        }
    }

    @Override
    public synchronized String getAvdPath() throws CommandFailedException {
        return this.getOutput(COMMAND_AVD_PATH);
    }

    private String getOutput(String command) throws CommandFailedException {
        if (!this.sendCommand(command)) {
            throw new CommandFailedException();
        }
        return EmulatorConsoleImpl.processOutput(Objects.requireNonNull(this.readLines()));
    }

    @VisibleForTesting
    static String processOutput(String[] lines) throws CommandFailedException {
        if (lines.length == 0) {
            throw new IllegalArgumentException();
        }
        Matcher matcher = RE_KO.matcher(lines[lines.length - 1]);
        if (matcher.matches()) {
            throw new CommandFailedException(matcher.group(1));
        }
        if (lines.length >= 2 && lines[lines.length - 1].equals("OK")) {
            return lines[lines.length - 2];
        }
        String separator = System.lineSeparator();
        throw new IllegalArgumentException("The last line doesn't equal \"OK\" nor start with \"KO:  \". lines = " + separator + String.join((CharSequence)separator, lines));
    }

    public synchronized String sendAuthentication() throws IOException {
        Path useHomeLocation = AndroidLocationsSingleton.INSTANCE.getUserHomeLocation();
        File emulatorConsoleAuthTokenFile = useHomeLocation.resolve(EMULATOR_CONSOLE_AUTH_TOKEN).toFile();
        String authToken = Files.asCharSource(emulatorConsoleAuthTokenFile, Charsets.UTF_8).read().trim();
        String command = String.format(COMMAND_AUTH, authToken);
        return this.processCommand(command);
    }

    @Override
    public synchronized String startEmulatorScreenRecording(String args2) {
        String command = String.format(COMMAND_SCREENRECORD_START, args2);
        return this.processCommand(command);
    }

    @Override
    public synchronized String stopScreenRecording() {
        return this.processCommand(COMMAND_SCREENRECORD_STOP);
    }

    private boolean sendCommand(String command) {
        boolean result = false;
        try {
            byte[] bCommand;
            try {
                bCommand = command.getBytes(DEFAULT_ENCODING);
            }
            catch (UnsupportedEncodingException e11) {
                Log.w(LOG_TAG, "wrong encoding when sending " + command + " to " + this.mPort);
                return result;
            }
            AdbHelper.write(this.mSocketChannel, bCommand, bCommand.length, DdmPreferences.getTimeOut());
            result = true;
        }
        catch (Exception e12) {
            Log.d(LOG_TAG, "Exception sending command " + command + " to " + this.mPort);
            return false;
        }
        return result;
    }

    private String processCommand(String command) {
        if (this.sendCommand(command)) {
            String[] result = this.readLines();
            if (result != null && result.length > 0) {
                Matcher m11 = RE_KO.matcher(result[result.length - 1]);
                if (m11.matches()) {
                    return m11.group(1);
                }
                return RESULT_OK;
            }
            return "Unable to communicate with the emulator";
        }
        return "Unable to send command to the emulator";
    }

    private String[] readLines() {
        try {
            ByteBuffer buf = ByteBuffer.wrap(this.mBuffer, 0, this.mBuffer.length);
            int numWaits = 0;
            boolean stop = false;
            while (buf.position() != buf.limit() && !stop) {
                int pos;
                int count = this.mSocketChannel.read(buf);
                if (count < 0) {
                    return null;
                }
                if (count == 0) {
                    if (numWaits * 5 > 5000) {
                        return null;
                    }
                    try {
                        Thread.sleep(5L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    ++numWaits;
                } else {
                    numWaits = 0;
                }
                if (buf.position() < 4 || !this.endsWithOK(pos = buf.position()) && !this.lastLineIsKO(pos)) continue;
                stop = true;
            }
            String msg = new String(this.mBuffer, 0, buf.position(), DEFAULT_ENCODING);
            return msg.split("\r\n");
        }
        catch (IOException e11) {
            Log.d(LOG_TAG, "Exception reading lines for " + this.mPort);
            return null;
        }
    }

    private boolean endsWithOK(int currentPosition) {
        return this.mBuffer[currentPosition - 1] == 10 && this.mBuffer[currentPosition - 2] == 13 && this.mBuffer[currentPosition - 3] == 75 && this.mBuffer[currentPosition - 4] == 79;
    }

    private boolean lastLineIsKO(int currentPosition) {
        int i11;
        if (this.mBuffer[currentPosition - 1] != 10 || this.mBuffer[currentPosition - 2] != 13) {
            return false;
        }
        for (i11 = currentPosition - 3; i11 >= 0 && (this.mBuffer[i11] != 10 || i11 <= 0 || this.mBuffer[i11 - 1] != 13); --i11) {
        }
        return this.mBuffer[i11 + 1] == 75 && this.mBuffer[i11 + 2] == 79;
    }
}

