/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Ascii;
import com.google.common.base.CharMatcher;
import com.google.common.base.Converter;
import com.google.common.base.ElementTypesAreNonnullByDefault;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public enum CaseFormat {
    LOWER_HYPHEN(CharMatcher.is('-'), "-"){

        @Override
        String normalizeWord(String word) {
            return Ascii.toLowerCase(word);
        }

        @Override
        String convert(CaseFormat format, String s11) {
            if (format == LOWER_UNDERSCORE) {
                return s11.replace('-', '_');
            }
            if (format == UPPER_UNDERSCORE) {
                return Ascii.toUpperCase(s11.replace('-', '_'));
            }
            return super.convert(format, s11);
        }
    }
    ,
    LOWER_UNDERSCORE(CharMatcher.is('_'), "_"){

        @Override
        String normalizeWord(String word) {
            return Ascii.toLowerCase(word);
        }

        @Override
        String convert(CaseFormat format, String s11) {
            if (format == LOWER_HYPHEN) {
                return s11.replace('_', '-');
            }
            if (format == UPPER_UNDERSCORE) {
                return Ascii.toUpperCase(s11);
            }
            return super.convert(format, s11);
        }
    }
    ,
    LOWER_CAMEL(CharMatcher.inRange('A', 'Z'), ""){

        @Override
        String normalizeWord(String word) {
            return CaseFormat.firstCharOnlyToUpper(word);
        }

        @Override
        String normalizeFirstWord(String word) {
            return Ascii.toLowerCase(word);
        }
    }
    ,
    UPPER_CAMEL(CharMatcher.inRange('A', 'Z'), ""){

        @Override
        String normalizeWord(String word) {
            return CaseFormat.firstCharOnlyToUpper(word);
        }
    }
    ,
    UPPER_UNDERSCORE(CharMatcher.is('_'), "_"){

        @Override
        String normalizeWord(String word) {
            return Ascii.toUpperCase(word);
        }

        @Override
        String convert(CaseFormat format, String s11) {
            if (format == LOWER_HYPHEN) {
                return Ascii.toLowerCase(s11.replace('_', '-'));
            }
            if (format == LOWER_UNDERSCORE) {
                return Ascii.toLowerCase(s11);
            }
            return super.convert(format, s11);
        }
    };

    private final CharMatcher wordBoundary;
    private final String wordSeparator;

    private CaseFormat(CharMatcher wordBoundary, String wordSeparator) {
        this.wordBoundary = wordBoundary;
        this.wordSeparator = wordSeparator;
    }

    public final String to(CaseFormat format, String str) {
        Preconditions.checkNotNull(format);
        Preconditions.checkNotNull(str);
        return format == this ? str : this.convert(format, str);
    }

    String convert(CaseFormat format, String s11) {
        StringBuilder out = null;
        int i11 = 0;
        int j11 = -1;
        while (true) {
            ++j11;
            if ((j11 = this.wordBoundary.indexIn(s11, j11)) == -1) break;
            if (i11 == 0) {
                out = new StringBuilder(s11.length() + 4 * format.wordSeparator.length());
                out.append(format.normalizeFirstWord(s11.substring(i11, j11)));
            } else {
                ((StringBuilder)Objects.requireNonNull(out)).append(format.normalizeWord(s11.substring(i11, j11)));
            }
            out.append(format.wordSeparator);
            i11 = j11 + this.wordSeparator.length();
        }
        return i11 == 0 ? format.normalizeFirstWord(s11) : ((StringBuilder)Objects.requireNonNull(out)).append(format.normalizeWord(s11.substring(i11))).toString();
    }

    public Converter<String, String> converterTo(CaseFormat targetFormat) {
        return new StringConverter(this, targetFormat);
    }

    abstract String normalizeWord(String var1);

    String normalizeFirstWord(String word) {
        return this.normalizeWord(word);
    }

    private static String firstCharOnlyToUpper(String word) {
        return word.isEmpty() ? word : Ascii.toUpperCase(word.charAt(0)) + Ascii.toLowerCase(word.substring(1));
    }

    private static final class StringConverter
    extends Converter<String, String>
    implements Serializable {
        private final CaseFormat sourceFormat;
        private final CaseFormat targetFormat;
        private static final long serialVersionUID = 0L;

        StringConverter(CaseFormat sourceFormat, CaseFormat targetFormat) {
            this.sourceFormat = Preconditions.checkNotNull(sourceFormat);
            this.targetFormat = Preconditions.checkNotNull(targetFormat);
        }

        @Override
        protected String doForward(String s11) {
            return this.sourceFormat.to(this.targetFormat, s11);
        }

        @Override
        protected String doBackward(String s11) {
            return this.targetFormat.to(this.sourceFormat, s11);
        }

        @Override
        public boolean equals(@CheckForNull Object object) {
            if (object instanceof StringConverter) {
                StringConverter that = (StringConverter)object;
                return this.sourceFormat.equals((Object)that.sourceFormat) && this.targetFormat.equals((Object)that.targetFormat);
            }
            return false;
        }

        public int hashCode() {
            return this.sourceFormat.hashCode() ^ this.targetFormat.hashCode();
        }

        public String toString() {
            return (Object)((Object)this.sourceFormat) + ".converterTo(" + (Object)((Object)this.targetFormat) + ")";
        }
    }
}

