/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.escape;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.escape.ArrayBasedEscaperMap;
import com.google.common.escape.CharEscaper;
import com.google.common.escape.ElementTypesAreNonnullByDefault;
import java.util.Map;
import javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public abstract class ArrayBasedCharEscaper
extends CharEscaper {
    private final char[][] replacements;
    private final int replacementsLength;
    private final char safeMin;
    private final char safeMax;

    protected ArrayBasedCharEscaper(Map<Character, String> replacementMap, char safeMin, char safeMax) {
        this(ArrayBasedEscaperMap.create(replacementMap), safeMin, safeMax);
    }

    protected ArrayBasedCharEscaper(ArrayBasedEscaperMap escaperMap, char safeMin, char safeMax) {
        Preconditions.checkNotNull(escaperMap);
        this.replacements = escaperMap.getReplacementArray();
        this.replacementsLength = this.replacements.length;
        if (safeMax < safeMin) {
            safeMax = '\u0000';
            safeMin = (char)65535;
        }
        this.safeMin = safeMin;
        this.safeMax = safeMax;
    }

    @Override
    public final String escape(String s11) {
        Preconditions.checkNotNull(s11);
        for (int i11 = 0; i11 < s11.length(); ++i11) {
            char c11 = s11.charAt(i11);
            if ((c11 >= this.replacementsLength || this.replacements[c11] == null) && c11 <= this.safeMax && c11 >= this.safeMin) continue;
            return this.escapeSlow(s11, i11);
        }
        return s11;
    }

    @Override
    @CheckForNull
    protected final char[] escape(char c11) {
        char[] chars;
        if (c11 < this.replacementsLength && (chars = this.replacements[c11]) != null) {
            return chars;
        }
        if (c11 >= this.safeMin && c11 <= this.safeMax) {
            return null;
        }
        return this.escapeUnsafe(c11);
    }

    @CheckForNull
    protected abstract char[] escapeUnsafe(char var1);
}

