# -*- coding: utf_8 -*-
# Check against most common malware permissions.
import logging

from mobsf.MobSF.utils import (
    append_scan_status,
)


TOP_MALWARE_PERMISSIONS = [
    'android.permission.ACCEPT_HANDOVER',
    'android.permission.ACCESS_COARSE_LOCATION',
    'android.permission.ACCESS_FINE_LOCATION',
    'android.permission.ACCESS_NETWORK_STATE',
    'android.permission.CAMERA',
    'android.permission.GET_ACCOUNTS',
    'android.permission.GET_TASKS',
    'android.permission.INTERNET',
    'android.permission.SET_WALLPAPER',
    'android.permission.WRITE_SETTINGS',
    'android.permission.READ_SMS',
    'android.permission.SEND_SMS',
    'android.permission.RECEIVE_SMS',
    'android.permission.READ_CALL_LOG',
    'android.permission.READ_CONTACTS',
    'android.permission.RECORD_AUDIO',
    'android.permission.ACCESS_WIFI_STATE',
    'android.permission.READ_PHONE_STATE',
    'android.permission.RECEIVE_BOOT_COMPLETED',
    'android.permission.SYSTEM_ALERT_WINDOW',
    'android.permission.WAKE_LOCK',
    'android.permission.WRITE_EXTERNAL_STORAGE',
    'android.permission.READ_EXTERNAL_STORAGE',
    'android.permission.VIBRATE',
    'android.permission.REQUEST_INSTALL_PACKAGES',
]
OTHER_PERMISSIONS = [
    'android.permission.ACCESS_BACKGROUND_LOCATION',
    'android.permission.ACCESS_CHECKIN_PROPERTIES',
    'android.permission.ACCESS_LOCATION_EXTRA_COMMANDS',
    'android.permission.ACCESS_MOCK_LOCATION',
    'android.permission.ACCESS_NOTIFICATION_POLICY',
    'android.permission.ACCESS_SUPERUSER',
    'android.permission.ACCESS_SURFACE_FLINGER',
    'android.permission.ACCOUNT_MANAGER',
    'android.permission.ACTIVITY_RECOGNITION',
    'android.permission.AUTHENTICATE_ACCOUNTS',
    'android.permission.BATTERY_STATS',
    'android.permission.BIND_APPWIDGET',
    'android.permission.BIND_DEVICE_ADMIN',
    'android.permission.BIND_INPUT_METHOD',
    'android.permission.BIND_REMOTEVIEWS',
    'android.permission.BIND_WALLPAPER',
    'android.permission.BLUETOOTH',
    'android.permission.BLUETOOTH_ADMIN',
    'android.permission.BRICK',
    'android.permission.BROADCAST_PACKAGE_REMOVED',
    'android.permission.BROADCAST_SMS',
    'android.permission.BROADCAST_STICKY',
    'android.permission.BROADCAST_WAP_PUSH',
    'android.permission.CALL_PHONE',
    'android.permission.CHANGE_NETWORK_STATE',
    'android.permission.CHANGE_WIFI_STATE',
    'android.permission.DIAGNOSTIC',
    'android.permission.FLASHLIGHT',
    'android.permission.FORCE_STOP_PACKAGES',
    'android.permission.FOREGROUND_SERVICE',
    'android.permission.GET_ACCOUNTS_PRIVELEGED',
    'android.permission.MODIFY_AUDIO_SETTINGS',
    'android.permission.MOUNT_FORMAT_FILESYSTEMS',
    'android.permission.PROCESS_OUTGOING_CALLS',
    'android.permission.READ_CALENDAR',
    'android.permission.PACKAGE_USAGE_STATS',
    'android.permission.REQUEST_IGNORE_BATTERY_OPTIMIZATIONS',
    'android.permission.WRITE_CONTACTS',
    'android.permission.WRITE_SMS',
    'com.android.launcher.permission.INSTALL_SHORTCUT',
    'com.google.android.c2dm.permission.RECEIVE',
    'com.google.android.finsky.permission.BIND_GET_INSTALL_REFERRER_SERVICE',
    'com.google.android.gms.permission.ACTIVITY_RECOGNITION',
    'com.google.android.gms.permission.AD_ID',
]


logger = logging.getLogger(__name__)


def check_malware_permission(checksum, perms):
    """Check against most common malware permissions."""
    msg = 'Checking for Malware Permissions'
    logger.info(msg)
    append_scan_status(checksum, msg)
    malware_perms = []
    other_perms = []
    for permission in perms:
        if permission in TOP_MALWARE_PERMISSIONS:
            malware_perms.append(permission)
        if permission in OTHER_PERMISSIONS:
            other_perms.append(permission)
    data = {
        'top_malware_permissions': malware_perms,
        'other_abused_permissions': other_perms,
        'total_malware_permissions': len(TOP_MALWARE_PERMISSIONS),
        'total_other_permissions': len(OTHER_PERMISSIONS),
    }
    return data
