import { IconSvgProps } from "@/types";

export const IAMAccessAnalyzerIcon: React.FC<IconSvgProps> = ({
  size = 32,
  width,
  height,
  className = "rounded-md",
  ...props
}) => (
  <svg
    aria-hidden="false"
    aria-label="IAM Access Analyzer logo"
    fill="none"
    focusable="false"
    height={size || height}
    role="presentation"
    viewBox="0 0 40 40"
    width={size || width}
    className={className}
    {...props}
    xmlns="http://www.w3.org/2000/svg"
  >
    <g fill="none" fillRule="evenodd">
      <path fill="#DD344C" d="M0 0h40v40H0z" />
      <path
        fill="#FFF"
        d="m33.131 31.955-6.998-6.998a.501.501 0 0 1-.092-.58c.945-1.85.63-4.273-.732-5.635a4.629 4.629 0 0 0-3.855-1.33c-1.432.173-2.696 1.001-3.466 2.27a4.583 4.583 0 0 0 .103 4.868c1.354 2.06 3.977 2.781 6.094 1.681a.5.5 0 0 1 .584.091l1.194 1.194a.504.504 0 0 1 .146.39l-.089 1.258 1.38-.003h.001a.5.5 0 0 1 .353.147l.598.597a.502.502 0 0 1 .146.347l.017 1.406 1.231-.106a.502.502 0 0 1 .397.144l1.097 1.097 1.761.45.13-1.288Zm1.019-.135-.213 2.101a.5.5 0 0 1-.621.434l-2.456-.627a.499.499 0 0 1-.23-.13l-1.029-1.03-1.537.133a.499.499 0 0 1-.543-.493l-.021-1.74-.306-.306-1.709.004h-.001a.502.502 0 0 1-.499-.535l.11-1.569-.783-.783c-2.515 1.1-5.491.202-7.057-2.179a5.587 5.587 0 0 1-.122-5.937c.931-1.533 2.462-2.534 4.201-2.744a5.63 5.63 0 0 1 4.682 1.616c1.8 1.8 1.898 4.535 1.072 6.463l6.918 6.918a.5.5 0 0 1 .144.404ZM22.737 21.208a1.087 1.087 0 0 0-.774-.32c-.292 0-.567.113-.774.32a1.098 1.098 0 0 0 0 1.55 1.12 1.12 0 0 0 1.548 0 1.098 1.098 0 0 0 0-1.55Zm.707-.707a2.099 2.099 0 0 1 0 2.964 2.09 2.09 0 0 1-1.481.613 2.09 2.09 0 0 1-1.481-.613 2.099 2.099 0 0 1 0-2.964 2.097 2.097 0 0 1 2.962 0ZM9.662 13.312c0 .263.016.52.047.778a.504.504 0 0 1-.423.56C8.035 14.981 6 15.968 6 18.882c0 .107.006.213.011.315.135 2.461 2.487 3.794 4.633 3.8H15v1h-4.357c-3.063-.008-5.483-2.048-5.63-4.746A6.369 6.369 0 0 1 5 18.882c0-3.389 2.318-4.647 3.677-5.094a7.265 7.265 0 0 1-.015-.476c0-2.777 1.876-5.653 4.364-6.69 2.91-1.226 5.992-.618 8.245 1.625.591.581 1.348 1.451 1.88 2.511.566-.515 1.207-.768 1.941-.768 1.455 0 3.086 1.217 3.376 3.88 3.008.715 4.532 2.43 4.532 5.1 0 2.927-1.281 4.57-3.916 5.02l-.168-.987C30.352 22.758 32 22.08 32 18.97c0-3.018-2.34-3.843-4.099-4.2a.5.5 0 0 1-.4-.462c-.113-1.953-1.103-3.317-2.409-3.317-.664 0-1.186.302-1.691.981a.501.501 0 0 1-.872-.13c-.437-1.22-1.308-2.24-1.961-2.883-1.958-1.95-4.634-2.476-7.157-1.414-2.102.877-3.749 3.41-3.749 5.768Z"
      />
    </g>
  </svg>
);

export const AWSAccountIcon: React.FC<IconSvgProps> = ({
  size = 32,
  width,
  height,
  className = "rounded-md",
  ...props
}) => (
  <svg
    aria-hidden="false"
    aria-label="AWS Account logo"
    fill="none"
    focusable="false"
    height={size || height}
    role="presentation"
    viewBox="0 0 40 40"
    width={size || width}
    className={className}
    {...props}
    xmlns="http://www.w3.org/2000/svg"
  >
    <g fill="none" fillRule="evenodd">
      <path fill="#E7157B" d="M0 0h40v40H0z" />
      <path
        fill="#FFF"
        d="M24.5 22c1.93 0 3.5 1.57 3.5 3.5S26.43 29 24.5 29 21 27.43 21 25.5s1.57-3.5 3.5-3.5Zm0 8c2.481 0 4.5-2.019 4.5-4.5S26.981 21 24.5 21a4.505 4.505 0 0 0-4.5 4.5c0 2.481 2.019 4.5 4.5 4.5Zm1.523-19.12L29.084 17h-6.121l3.06-6.12ZM22.154 18h7.739a.502.502 0 0 0 .447-.724l-3.869-7.738c-.17-.338-.725-.338-.895 0l-3.869 7.738a.503.503 0 0 0 .447.724ZM11 23h7v-7h-7v7Zm-.5 1h8a.5.5 0 0 0 .5-.5v-8a.5.5 0 0 0-.5-.5h-8a.5.5 0 0 0-.5.5v8a.5.5 0 0 0 .5.5ZM8 32h24V8H8v24ZM32.5 7h-25a.5.5 0 0 0-.5.5v25a.5.5 0 0 0 .5.5h25a.5.5 0 0 0 .5-.5v-25a.5.5 0 0 0-.5-.5Z"
      />
    </g>
  </svg>
);

export const AWSCertificateManagerIcon: React.FC<IconSvgProps> = ({
  size = 32,
  width,
  height,
  className = "rounded-md",
  ...props
}) => (
  <svg
    aria-hidden="false"
    aria-label="AWS Certificate Manager logo"
    fill="none"
    focusable="false"
    height={size || height}
    role="presentation"
    viewBox="0 0 40 40"
    width={size || width}
    className={className}
    {...props}
    xmlns="http://www.w3.org/2000/svg"
  >
    <g
      id="Icon-Architecture/32/Arch_AWS-Certificate-Manager_32"
      stroke="none"
      strokeWidth="1"
      fill="none"
      fillRule="evenodd"
    >
      <g
        id="Icon-Architecture-BG/32/Security-Identity-Compliance"
        fill="#DD344C"
      >
        <rect id="Rectangle" x="0" y="0" width="40" height="40" />
      </g>
      <path
        d="M17.8323574,19.6308709 C17.9645126,19.7501051 18.0221441,19.9309436 17.9843855,20.1058203 L17.4706696,22.4676501 L19.7401611,21.076585 C19.8991448,20.9782168 20.0998616,20.9782168 20.2608325,21.076585 L22.513432,22.4646692 L22.0146208,20.0978714 C21.9788495,19.9259755 22.0354874,19.7481179 22.1646616,19.6288837 L24.1787856,17.7877097 L21.5138223,17.2730156 C21.3608006,17.2432071 21.2306327,17.1438453 21.162071,17.0027516 L19.9955286,14.6160813 L18.8021576,17.0097069 C18.7326023,17.1478198 18.6034281,17.2461879 18.4523936,17.2750029 L15.7953795,17.7926778 L17.8323574,19.6308709 Z M16.2524575,23.3946956 L16.9529792,20.1753736 L14.3913553,17.8632247 C14.2512509,17.7370352 14.1956067,17.5432797 14.2462827,17.3614476 C14.2959651,17.1806092 14.4450122,17.0434899 14.6288371,17.006726 L18.0211505,16.3469637 L19.5553426,13.2717163 C19.6398027,13.1028012 19.8405195,12.965682 20.0024841,12.9964841 C20.1912772,12.9974777 20.3641719,13.1057821 20.4466447,13.2756908 L21.9460591,16.3439829 L25.3373789,16.9997707 C25.5212037,17.0345473 25.6702509,17.170673 25.7209269,17.3525051 C25.771603,17.5323499 25.7169523,17.7261054 25.5788353,17.8532885 L23.0450335,20.1704055 L23.7246886,23.3927084 C23.7654282,23.5864639 23.68693,23.7871747 23.5249654,23.9014407 C23.3600199,24.0167004 23.1473793,24.0216685 22.9774655,23.9183323 L19.9995032,22.08312 L16.9976933,23.9233003 C16.9172078,23.9729812 16.8277796,23.9968281 16.7373576,23.9968281 C16.6369992,23.9968281 16.5356471,23.9660259 16.4501934,23.9054152 C16.2872352,23.7901555 16.2097307,23.5884511 16.2524575,23.3946956 L16.2524575,23.3946956 Z M32.9785301,10.0951198 L32.9755492,7.99361792 L6.99364775,7.99361792 L6.99364775,10.0951198 L32.9785301,10.0951198 Z M34,32.5021974 C34,32.6343486 33.9483303,32.7605381 33.8549274,32.8539382 C33.7615245,32.9473383 33.6353313,33 33.5031761,33 L29.9369743,33 L29.9369743,32.0063821 L33.0063522,32.0063821 L32.9795238,11.0887377 L6.99364775,11.0887377 L6.99364775,32.0063821 L25.9623833,32.0063821 L25.9623833,33 L6.49682388,33 C6.36466872,33 6.23847546,32.9473383 6.14507257,32.8549318 C6.05266333,32.7615317 6,32.6353422 6,32.503191 L6,7.49680896 C6,7.22257041 6.22158345,7 6.49682388,7 L33.4713794,7 C33.7466198,7 33.9682033,7.22257041 33.9682033,7.49680896 L34,32.5021974 Z M11.0576671,29.9754271 L15.0322581,29.9754271 L15.0322581,28.9818091 L11.0576671,28.9818091 L11.0576671,29.9754271 Z M17.0195536,29.9982803 L23.9750878,29.9982803 L23.9750878,29.0046624 L17.0195536,29.0046624 L17.0195536,29.9982803 Z M11.0576671,26.9985478 L15.0322581,26.9985478 L15.0322581,26.0049299 L11.0576671,26.0049299 L11.0576671,26.9985478 Z M17.0195536,26.9985478 L27.9496788,26.9985478 L27.9496788,26.0049299 L17.0195536,26.0049299 L17.0195536,26.9985478 Z"
        id="AWS-Certificate-Manager_Icon_32_Squid"
        fill="#FFFFFF"
      />
    </g>
  </svg>
);

export const AWSAthenaIcon: React.FC<IconSvgProps> = ({
  size = 32,
  width,
  height,
  className = "rounded-md",
  ...props
}) => (
  <svg
    aria-hidden="false"
    aria-label="Amazon Athena logo"
    fill="none"
    focusable="false"
    height={size || height}
    role="presentation"
    viewBox="0 0 40 40"
    width={size || width}
    className={className}
    {...props}
    xmlns="http://www.w3.org/2000/svg"
  >
    <g fill="none" fillRule="evenodd">
      <path fill="#8C4FFF" d="M0 0h40v40H0z" />
      <path
        fill="#FFF"
        d="M18.726 14.285c1.8 0 2.982.285 3.42.5-.438.214-1.62.498-3.42.498-1.8 0-2.982-.284-3.42-.499.438-.214 1.62-.499 3.42-.499Zm.014 3.198c-.088-.027-.164-.079-.164-.181 0-.14.114-.253.256-.253.042 0 .072.026.107.043l-.199.391Zm2.939 4.156a1.203 1.203 0 0 1-.303.156 4.024 4.024 0 0 1-.566.166 9.261 9.261 0 0 1-1.978.202c-1.542 0-2.616-.322-2.846-.522l-.688-5.794c1.187.401 2.937.433 3.428.433.496 0 2.275-.033 3.464-.445l-.202 2.298a34.447 34.447 0 0 1-2.44-1.048.754.754 0 0 0-1.475.216.753.753 0 0 0 1.041.69c1.178.56 2.09.944 2.781 1.186l-.216 2.462Zm-7.525-6.797.822 6.891c0 1.411 3.698 1.427 3.856 1.427.78 0 1.564-.08 2.206-.226.269-.061.507-.133.71-.212.624-.241.94-.574.938-.946l.204-2.305c.299.068.534.098.715.098.478 0 .604-.189.69-.319l.077-.476c-.122-.492-1-1.187-1.297-1.404l.224-2.543-.005-.001c.001-.014.007-.027.007-.042 0-1.424-3.811-1.496-4.575-1.496-.764 0-4.575.072-4.575 1.496 0 .02.008.037.01.057h-.007Zm4.591-5.448c4.765 0 8.643 3.803 8.643 8.478s-3.878 8.478-8.643 8.478c-4.765 0-8.642-3.803-8.642-8.478s3.877-8.478 8.642-8.478ZM6.017 21.267v.998h4.177a9.69 9.69 0 0 0 8.551 5.082c5.326 0 9.66-4.25 9.66-9.475 0-5.224-4.334-9.475-9.66-9.475-4.41 0-8.132 2.917-9.283 6.886H6.017v.997h3.217a9.236 9.236 0 0 0-.148 1.592c0 .136.015.268.02.403H5v.997h4.203c.105.693.285 1.36.535 1.995H6.017Zm27.486 11.265c-.614.603-1.68.608-2.295.005l-5.253-5.152a12.068 12.068 0 0 0 2.34-2.246l5.214 5.142a1.566 1.566 0 0 1-.006 2.25Zm.726-2.955-5.334-5.26a11.64 11.64 0 0 0 1.953-6.445C30.848 11.326 25.418 6 18.745 6 13.95 6 9.6 8.782 7.665 13.087l.93.402c1.773-3.943 5.757-6.492 10.15-6.492 6.112 0 11.086 4.879 11.086 10.875s-4.974 10.876-11.086 10.876c-3.732 0-7.192-1.827-9.254-4.885l-.848.551c2.251 3.338 6.027 5.331 10.102 5.331 2.333 0 4.506-.662 6.356-1.788l5.388 5.286c.498.488 1.159.757 1.86.757a2.66 2.66 0 0 0 1.872-.761 2.55 2.55 0 0 0 .008-3.662Z"
      />
    </g>
  </svg>
);

export const AWSLambdaIcon: React.FC<IconSvgProps> = ({
  size = 32,
  width,
  height,
  className = "rounded-md",
  ...props
}) => (
  <svg
    aria-hidden="false"
    aria-label="AWS Lambda logo"
    fill="none"
    focusable="false"
    height={size || height}
    role="presentation"
    viewBox="0 0 40 40"
    width={size || width}
    className={className}
    {...props}
    xmlns="http://www.w3.org/2000/svg"
  >
    <g fill="none" fillRule="evenodd">
      <path fill="#ED7100" d="M0 0h40v40H0z" />
      <path
        fill="#FFF"
        d="M14.386 33H8.27l6.763-14.426 3.064 6.44L14.387 33Zm1.085-15.798a.49.49 0 0 0-.442-.282h-.002a.493.493 0 0 0-.441.285l-7.538 16.08a.507.507 0 0 0 .028.482c.09.145.247.233.415.233h7.206c.19 0 .363-.111.445-.286l3.944-8.489a.508.508 0 0 0-.002-.432l-3.613-7.591ZM32.018 33h-5.882l-9.47-20.711a.491.491 0 0 0-.444-.289H12.37l.005-5h7.549l9.424 20.71c.08.177.256.29.446.29h2.224v5Zm.49-6h-2.4L20.684 6.29a.492.492 0 0 0-.446-.29h-8.353a.496.496 0 0 0-.491.5l-.006 6c0 .132.052.259.144.354a.488.488 0 0 0 .347.146h4.032l9.468 20.711c.08.176.254.289.445.289h6.686a.495.495 0 0 0 .491-.5v-6c0-.276-.219-.5-.491-.5Z"
      />
    </g>
  </svg>
);

export const AWSCloudFormationIcon: React.FC<IconSvgProps> = ({
  size = 32,
  width,
  height,
  className = "rounded-md",
  ...props
}) => (
  <svg
    aria-hidden="false"
    aria-label="AWS CloudFormation logo"
    fill="none"
    focusable="false"
    height={size || height}
    role="presentation"
    viewBox="0 0 40 40"
    width={size || width}
    className={className}
    {...props}
    xmlns="http://www.w3.org/2000/svg"
  >
    <g fill="none" fillRule="evenodd">
      <path fill="#E7157B" d="M0 0h40v40H0z" />
      <path
        fill="#FFF"
        d="M27 19.982h3V18.98h-3v1.002Zm-13 6.009h3v-1.002h-3v1.002Zm-5 0h3v-1.002H9v1.002Zm0-3.005h6v-1.001H9v1.001Zm0-6.009h5v-1.001H9v1.001Zm0 3.005h16V18.98H9v1.002Zm9.968 11.016H7V13.973h11.968v3.021h1v-3.522a.5.5 0 0 0-.5-.5H6.5a.5.5 0 0 0-.5.5V31.5a.5.5 0 0 0 .5.501h12.968a.5.5 0 0 0 .5-.5v-9.498h-1v8.996ZM34 18.48c0 4.455-3.96 4.506-4 4.506h-8v-1.001h8c.305-.003 3-.122 3-3.505 0-2.848-2.569-3.425-3.083-3.513a.5.5 0 0 1-.415-.535l.003-.03c-.029-1.607-1.015-2.11-1.442-2.25-.799-.268-1.687-.012-2.158.618a.5.5 0 0 1-.871-.131c-.311-.87-.762-1.434-1.388-2.062-1.569-1.559-3.691-1.987-5.683-1.15-1.044.44-1.956 1.438-2.502 2.737l-.922-.388c.646-1.539 1.753-2.731 3.036-3.272 2.379-1.002 4.911-.491 6.777 1.364.534.536.978 1.057 1.323 1.734.749-.552 1.752-.717 2.704-.402 1.216.405 1.985 1.461 2.109 2.865C32.19 14.495 34 15.857 34 18.48Z"
      />
    </g>
  </svg>
);

export const AWSCloudTrailIcon: React.FC<IconSvgProps> = ({
  size = 32,
  width,
  height,
  className = "rounded-md",
  ...props
}) => (
  <svg
    aria-hidden="false"
    aria-label="AWS CloudTrail logo"
    fill="none"
    focusable="false"
    height={size || height}
    role="presentation"
    viewBox="0 0 40 40"
    width={size || width}
    className={className}
    {...props}
    xmlns="http://www.w3.org/2000/svg"
  >
    <g fill="none" fillRule="evenodd">
      <path fill="#E7157B" d="M0 0h40v40H0z" />
      <path
        fill="#FFF"
        d="M14.027 24.131h4.013v-.97h-4.013v.97Zm15.959-5.31c-.11-1.476-.846-2.56-2.017-2.938-.927-.302-1.958-.084-2.746.536a10.025 10.025 0 0 0-1.813-2.395c-2.006-1.915-4.56-2.507-7.01-1.622-2.257.815-4.881 3.57-4.881 5.9v.029c-1.474.368-2.505 2.275-2.505 3.316h1.003c0-.752.969-2.408 2.003-2.408a.493.493 0 0 0 .502-.485v-.452c0-1.866 2.326-4.303 4.23-4.99 2.827-1.022 4.944.44 5.953 1.403.651.62 1.52 1.738 1.886 2.725.064.168.216.289.399.316a.517.517 0 0 0 .474-.188c.548-.704 1.424-1.01 2.187-.765.856.277 1.346 1.157 1.346 2.414 0 .238.178.44.42.478 1.238.2 3.58 1.28 3.58 3.95 0 3.321-3.357 3.383-3.498 3.384H18.04V28H29.5c1.557-.003 4.5-.916 4.5-4.354 0-3.047-2.432-4.427-4.014-4.824Zm-13.952 7.245h7.023v-.971h-7.023v.97ZM13.024 28h3.01v-.97h-3.01V28Zm-1.004-1.934h2.007v-.971H12.02v.97ZM7.003 24.13h5.017v-.97H7.003v.97ZM6 26.066h5.017v-.971H6v.97ZM8.007 28h3.01v-.97h-3.01V28Z"
      />
    </g>
  </svg>
);

export const AWSCloudWatchIcon: React.FC<IconSvgProps> = ({
  size = 32,
  width,
  height,
  className = "rounded-md",
  ...props
}) => (
  <svg
    aria-hidden="false"
    aria-label="AWS CloudWatch logo"
    fill="none"
    focusable="false"
    height={size || height}
    role="presentation"
    viewBox="0 0 40 40"
    width={size || width}
    className={className}
    {...props}
    xmlns="http://www.w3.org/2000/svg"
  >
    <g fill="none" fillRule="evenodd">
      <path fill="#E7157B" d="M0 0h40v40H0z" />
      <path
        fill="#FFF"
        d="M27.63 24.124c0-1.903-1.58-3.452-3.522-3.452-1.943 0-3.523 1.549-3.523 3.452 0 1.904 1.58 3.452 3.523 3.452 1.942 0 3.522-1.548 3.522-3.452Zm1.006 0c0 2.447-2.032 4.439-4.528 4.439-2.497 0-4.53-1.992-4.53-4.439s2.033-4.438 4.53-4.438c2.496 0 4.528 1.991 4.528 4.438Zm4.276 6.579-3.387-2.99c-.289.418-.63.793-1.008 1.133l3.367 2.976a.781.781 0 0 0 1.085-.056.745.745 0 0 0-.057-1.063Zm-8.804-1.154c3.051 0 5.535-2.433 5.535-5.425 0-2.991-2.484-5.424-5.535-5.424-3.052 0-5.536 2.433-5.536 5.424 0 2.992 2.484 5.425 5.536 5.425Zm9.478.422a1.72 1.72 0 0 1 .13 2.455 1.79 1.79 0 0 1-1.32.574c-.423 0-.847-.147-1.185-.445l-3.494-3.089a6.592 6.592 0 0 1-3.61 1.07c-3.606 0-6.541-2.877-6.541-6.412s2.935-6.41 6.542-6.41c3.607 0 6.541 2.875 6.541 6.41 0 .968-.226 1.883-.62 2.707l3.557 3.14Zm-22.994-5.354h4.96v.987h-4.966c-.557-.006-1.156-.206-1.786-.596-1.044-.634-2.8-2.127-2.8-4.973 0-3.442 2.41-4.706 3.812-5.15a7.265 7.265 0 0 1-.016-.492c0-2.804 1.942-5.714 4.515-6.765 3.013-1.237 6.203-.623 8.531 1.638a8.456 8.456 0 0 1 1.786 2.563 3.404 3.404 0 0 1 2.177-.787c1.56 0 3.319 1.165 3.626 3.713C31.887 15.08 35 16.23 35 20.075c0 1.653-.567 2.99-1.687 3.972l-.672-.733c.898-.788 1.353-1.878 1.353-3.238 0-3.382-2.888-4.223-4.13-4.427a.5.5 0 0 1-.33-.207.486.486 0 0 1-.08-.378c-.147-2.074-1.438-3.036-2.65-3.036-.756 0-1.466.361-1.947.99a.513.513 0 0 1-.477.194.5.5 0 0 1-.398-.32c-.433-1.172-1.054-2.156-1.847-2.925-2.032-1.973-4.812-2.508-7.437-1.43-2.184.894-3.895 3.465-3.895 5.856 0 .268.016.536.048.794a.486.486 0 0 1-.122.387.51.51 0 0 1-.29.16c-1.297.327-3.433 1.32-3.433 4.301 0 2.25 1.266 3.492 2.327 4.138.473.292.896.44 1.26.444Z"
      />
    </g>
  </svg>
);

export const AWSConfigIcon: React.FC<IconSvgProps> = ({
  size = 32,
  width,
  height,
  className = "rounded-md",
  ...props
}) => (
  <svg
    aria-hidden="false"
    aria-label="AWS Config logo"
    fill="none"
    focusable="false"
    height={size || height}
    role="presentation"
    viewBox="0 0 40 40"
    width={size || width}
    className={className}
    {...props}
    xmlns="http://www.w3.org/2000/svg"
  >
    <g fill="none" fillRule="evenodd">
      <path fill="#E7157B" d="M0 0h40v40H0z" />
      <path
        fill="#FFF"
        d="m29.765 24.019.945.333-.592 1.68a.502.502 0 0 1-.526.332l-1.915-.205.105-.996.908.096a2.472 2.472 0 0 0-2.005-1.042 2.48 2.48 0 0 0-2.421 1.978l-.983-.2a3.487 3.487 0 0 1 3.404-2.78c1.157 0 2.2.587 2.838 1.492l.242-.688Zm-.657 3.165.982.2a3.488 3.488 0 0 1-3.405 2.78 3.474 3.474 0 0 1-2.718-1.331l-.12.544-.979-.217.395-1.777a.503.503 0 0 1 .562-.387l1.808.27-.147.99-.79-.117a2.474 2.474 0 0 0 1.99 1.024 2.48 2.48 0 0 0 2.422-1.979Zm3.89.36-.594-.035a.487.487 0 0 0-.517.39 5.286 5.286 0 0 1-.682 1.65.502.502 0 0 0 .089.64l.444.396-1.153 1.153-.394-.442a.502.502 0 0 0-.641-.09 5.25 5.25 0 0 1-1.65.684.5.5 0 0 0-.39.518l.033.59h-1.63l.034-.59a.5.5 0 0 0-.389-.519 5.198 5.198 0 0 1-1.65-.684.503.503 0 0 0-.64.09l-.396.443-1.153-1.152.443-.395a.5.5 0 0 0 .09-.642 5.272 5.272 0 0 1-.683-1.65.49.49 0 0 0-.516-.39l-.594.034v-1.63l.596.033a.483.483 0 0 0 .516-.39 5.27 5.27 0 0 1 .685-1.646.501.501 0 0 0-.09-.642l-.447-.398 1.153-1.152.398.445a.5.5 0 0 0 .64.09 5.26 5.26 0 0 1 1.648-.682.5.5 0 0 0 .389-.517l-.034-.597h1.63l-.033.597a.501.501 0 0 0 .39.518c.585.132 1.138.361 1.645.682a.5.5 0 0 0 .64-.09l.4-.447 1.153 1.153-.446.397a.502.502 0 0 0-.09.642c.322.508.552 1.063.684 1.647.054.238.254.415.517.39l.595-.033v1.63Zm.845-2.526a.53.53 0 0 0-.373-.137l-.715.042a6.254 6.254 0 0 0-.49-1.181l.535-.477a.499.499 0 0 0 .02-.729l-1.902-1.903a.602.602 0 0 0-.368-.146.496.496 0 0 0-.36.167l-.48.538a6.197 6.197 0 0 0-1.176-.49l.04-.718a.5.5 0 0 0-.5-.53h-2.691a.493.493 0 0 0-.364.158.498.498 0 0 0-.136.373l.04.717a6.215 6.215 0 0 0-1.178.489l-.478-.537a.498.498 0 0 0-.36-.167.553.553 0 0 0-.369.146l-1.902 1.903a.501.501 0 0 0 .02.729l.536.479c-.203.376-.367.77-.49 1.179l-.715-.042a.537.537 0 0 0-.373.137.503.503 0 0 0-.156.364v2.691c0 .139.057.27.156.365a.49.49 0 0 0 .373.135l.713-.04c.122.411.285.806.489 1.183l-.533.475a.502.502 0 0 0-.02.727l1.902 1.904a.502.502 0 0 0 .728-.021l.476-.533c.376.205.772.37 1.182.491l-.041.712a.5.5 0 0 0 .5.529h2.69a.501.501 0 0 0 .5-.53l-.04-.71c.41-.123.805-.286 1.183-.49l.475.531a.5.5 0 0 0 .36.168.56.56 0 0 0 .367-.147l1.903-1.904a.5.5 0 0 0-.021-.727l-.533-.477c.203-.377.366-.772.489-1.18l.714.04a.503.503 0 0 0 .53-.5v-2.692a.5.5 0 0 0-.157-.364ZM8.002 27.973h9.049v1.002h-9.55a.501.501 0 0 1-.501-.5V6.5C7 6.224 7.224 6 7.5 6h23.108c.276 0 .5.224.5.501v11.484h-1.001V7.002H8.002v20.971Zm16.547-12.995h-.494V12.97H27.101v2.008h-2.552Zm.501-3.01h.986V9.988h-.986v1.982Zm1.988 6.017V15.98h.564c.276 0 .5-.224.5-.5v-3.011a.501.501 0 0 0-.5-.501h-.564V9.485a.5.5 0 0 0-.501-.5h-1.988a.5.5 0 0 0-.5.5v2.483h-.495a.5.5 0 0 0-.5.5v3.011a.5.5 0 0 0 .5.501h.494v2.005h1.002V15.98h.986v2.005h1.002Zm-9.518.955h-.57v-1.91h3.106v1.91H17.52Zm.5-2.913h1.034v-6.04H18.02v6.04Zm2.037 5.903v-1.988h.5c.277 0 .502-.225.502-.501v-2.912a.501.501 0 0 0-.501-.502h-.501V9.485a.5.5 0 0 0-.501-.5H17.52a.5.5 0 0 0-.501.5v6.542h-.57c-.276 0-.5.225-.5.502v2.912c0 .276.224.5.5.5h.57v5.955h1.002v-5.954h1.034v1.988h1.002Zm-9.071-8.878h.986V9.987h-.986v3.065Zm0 11.979h.986v-8.083h-.986v8.083Zm-.994-10.977H12.966v1.891H9.992v-1.89Zm.493 11.979h1.988a.5.5 0 0 0 .501-.501v-8.585h.493a.5.5 0 0 0 .501-.5v-2.894a.5.5 0 0 0-.5-.5h-.494V9.484a.5.5 0 0 0-.5-.5h-1.99a.5.5 0 0 0-.5.5v3.567H9.49a.5.5 0 0 0-.501.501v2.893a.5.5 0 0 0 .5.501h.494v8.585a.5.5 0 0 0 .5.5Z"
      />
    </g>
  </svg>
);

export const AWSDatabaseMigrationServiceIcon: React.FC<IconSvgProps> = ({
  size = 32,
  width,
  height,
  className = "rounded-md",
  ...props
}) => (
  <svg
    aria-hidden="false"
    aria-label="AWS Database Migration Service logo"
    fill="none"
    focusable="false"
    height={size || height}
    role="presentation"
    viewBox="0 0 40 40"
    width={size || width}
    className={className}
    {...props}
    xmlns="http://www.w3.org/2000/svg"
  >
    <g fill="none" fillRule="evenodd">
      <path fill="#C925D1" d="M0 0h40v40H0z" />
      <path
        fill="#FFF"
        d="M22.024 33h1v-2.997h-1V33Zm-5.019 0h1v-2.997h-1V33ZM26 32.001h1v-2.996h-1V32Zm-13 0h1v-2.996h-1V32Zm7.018-14.96c-3.717 0-6.018-.958-6.018-1.847v-3.548c1.173.885 3.304 1.418 6.018 1.418 2.604 0 4.782-.583 5.982-1.49v3.62c0 .908-2.238 1.847-5.982 1.847Zm0 5.019c-3.547 0-6.018-1.084-6.018-2.057V16.8c1.34.892 3.805 1.24 6.018 1.24 2.725 0 4.825-.462 5.982-1.25v3.213c0 .973-2.456 2.057-5.982 2.057Zm0 5.006c-3.491 0-6.018-1.503-6.018-2.516v-2.9c1.294.928 3.664 1.408 6.018 1.408 2.635 0 4.793-.547 5.982-1.416v2.908c0 1-2.386 2.516-5.982 2.516Zm0-19.067c3.695 0 5.982.989 5.982 1.905 0 .903-2.276 2.161-5.982 2.161-3.43 0-6.018-.929-6.018-2.161 0-.778 2.143-1.905 6.018-1.905Zm0-.999C16.638 7 13 7.909 13 9.904V24.55c0 1.873 3.279 3.515 7.018 3.515 3.719 0 6.982-1.642 6.982-3.515V9.904C27 7.898 23.493 7 20.018 7Z"
      />
    </g>
  </svg>
);

export const AmazonEC2Icon: React.FC<IconSvgProps> = ({
  size = 32,
  width,
  height,
  className = "rounded-md",
  ...props
}) => (
  <svg
    aria-hidden="false"
    aria-label="Amazon EC2 logo"
    fill="none"
    focusable="false"
    height={size || height}
    role="presentation"
    viewBox="0 0 40 40"
    width={size || width}
    className={className}
    {...props}
    xmlns="http://www.w3.org/2000/svg"
  >
    <g fill="none" fillRule="evenodd">
      <path fill="#ED7100" d="M0 0h40v40H0z" />
      <path
        fill="#FFF"
        d="M26.052 27 26 13.948 13 14v13.052L26.052 27ZM27 14h2v1h-2v2h2v1h-2v2h2v1h-2v2h2v1h-2v2h2v1h-2v.052a.95.95 0 0 1-.948.948H26v2h-1v-2h-2v2h-1v-2h-2v2h-1v-2h-2v2h-1v-2h-2v2h-1v-2h-.052a.95.95 0 0 1-.948-.948V27h-2v-1h2v-2h-2v-1h2v-2h-2v-1h2v-2h-2v-1h2v-2h-2v-1h2v-.052a.95.95 0 0 1 .948-.948H13v-2h1v2h2v-2h1v2h2v-2h1v2h2v-2h1v2h2v-2h1v2h.052a.95.95 0 0 1 .948.948V14Zm-6 19H7V19h2v-1H7.062C6.477 18 6 18.477 6 19.062v13.876C6 33.523 6.477 34 7.062 34h13.877c.585 0 1.061-.477 1.061-1.062V31h-1v2ZM34 7.062v13.876c0 .585-.476 1.062-1.061 1.062H30v-1h3V7H19v3h-1V7.062C18 6.477 18.477 6 19.062 6h13.877C33.524 6 34 6.477 34 7.062Z"
      />
    </g>
  </svg>
);

export const AmazonEMRIcon: React.FC<IconSvgProps> = ({
  size = 32,
  width,
  height,
  className = "rounded-md",
  ...props
}) => (
  <svg
    aria-hidden="false"
    aria-label="Amazon EMR logo"
    fill="none"
    focusable="false"
    height={size || height}
    role="presentation"
    viewBox="0 0 40 40"
    width={size || width}
    className={className}
    {...props}
    xmlns="http://www.w3.org/2000/svg"
  >
    <g fill="none" fillRule="evenodd">
      <path fill="#8C4FFF" d="M0 0h40v40H0z" />
      <path
        fill="#FFF"
        d="M32.011 25.364a2.01 2.01 0 0 0-.584-1.423 1.984 1.984 0 0 0-2.82 0 2.025 2.025 0 0 0 0 2.844c.753.76 2.067.761 2.82 0 .376-.38.584-.884.584-1.421Zm-4.777-1.07c.14-.372.353-.722.646-1.026l-1.058-2.03-1.316 2.507 1.728.55Zm-3.159.043-6.866-2.189a5.531 5.531 0 0 1-1.405 1.654l3.386 4.737a2.949 2.949 0 0 1 2.832-.29l2.053-3.912Zm-1.226 6.668a1.993 1.993 0 0 0-1.981-1.996c-.508 0-1.015.194-1.401.584-.374.378-.58.879-.58 1.412 0 .534.206 1.035.58 1.413.772.778 2.03.778 2.801 0 .375-.378.58-.88.58-1.413Zm-10.401-7.027c2.458 0 4.457-2.015 4.457-4.495 0-2.478-2-4.495-4.457-4.495-2.458 0-4.457 2.017-4.457 4.495 0 2.48 2 4.495 4.457 4.495Zm6.439-14.983c0 .534.206 1.035.58 1.413.772.779 2.03.779 2.801 0 .375-.378.58-.88.58-1.413a1.993 1.993 0 0 0-1.98-1.997 1.993 1.993 0 0 0-1.981 1.997Zm3.016 2.801a2.981 2.981 0 0 1-1.035.195 2.947 2.947 0 0 1-1.563-.455l-2.974 4.1a5.511 5.511 0 0 1 1.321 2.222l6.374-1.985-2.123-4.077Zm-4.007 7.687c0 .612-.103 1.197-.286 1.746l6.936 2.21 1.717-3.272-1.768-3.395-6.64 2.068c.024.212.041.426.041.643Zm7.562-3.01 1.368 2.625 1.292-2.463c-.07-.06-.145-.108-.212-.175a2.985 2.985 0 0 1-.453-.609l-1.995.622Zm3.149-.72c.753.76 2.067.762 2.82 0 .376-.379.584-.883.584-1.42a2.01 2.01 0 0 0-.584-1.423 1.984 1.984 0 0 0-2.82 0 2.025 2.025 0 0 0 0 2.844Zm3.52 7.482a3.03 3.03 0 0 1 0 4.256 2.957 2.957 0 0 1-2.11.88 2.96 2.96 0 0 1-2.11-.88 3.01 3.01 0 0 1-.865-2.21l-2.007-.638-2.18 4.15c.037.034.079.058.114.094.56.565.87 1.318.87 2.118 0 .8-.31 1.554-.87 2.119-.58.584-1.34.876-2.101.876a2.947 2.947 0 0 1-2.101-.876 2.987 2.987 0 0 1-.871-2.119c0-.643.208-1.25.577-1.76l-3.5-4.898c-.756.4-1.614.63-2.525.63C9.445 24.977 7 22.513 7 19.483c0-3.028 2.445-5.493 5.448-5.493 1.163 0 2.24.372 3.125 1l2.992-4.124a2.98 2.98 0 0 1-.669-1.87c0-.801.309-1.553.87-2.12a2.956 2.956 0 0 1 4.203 0c.56.567.87 1.319.87 2.12a2.99 2.99 0 0 1-.87 2.118c-.066.067-.142.117-.213.176l2.232 4.284 2.103-.656a3.028 3.028 0 0 1 .815-2.714 2.97 2.97 0 0 1 4.221 0 3.03 3.03 0 0 1 0 4.256 2.957 2.957 0 0 1-2.11.88c-.355 0-.709-.07-1.046-.196l-1.588 3.025 1.309 2.513a2.96 2.96 0 0 1 3.435.553Zm-19.184-4.251h1.981v.999h-1.98v1.998h-.991v-1.998H9.972v-1h1.98v-1.997h.991v1.998Z"
      />
    </g>
  </svg>
);

export const AWSGlueIcon: React.FC<IconSvgProps> = ({
  size = 32,
  width,
  height,
  className = "rounded-md",
  ...props
}) => (
  <svg
    aria-hidden="false"
    aria-label="AWS Glue logo"
    fill="none"
    focusable="false"
    height={size || height}
    role="presentation"
    viewBox="0 0 40 40"
    width={size || width}
    className={className}
    {...props}
    xmlns="http://www.w3.org/2000/svg"
  >
    <g fill="none" fillRule="evenodd">
      <rect width="40" height="40" fill="#8C4FFF" />
      <path
        fill="#FFF"
        d="M27.163 15.543c-1.839.412-4.673.495-6.663.495-1.977 0-4.785-.082-6.625-.486l5.539 8.197a.504.504 0 0 1 .086.281v1.068c.701.202 1.349.205 2 .007V24.03c0-.1.03-.2.087-.282l5.576-8.205Zm1.69-.771.03.02-6.383 9.392v1.276a.5.5 0 0 1-.314.464 4.382 4.382 0 0 1-1.653.329 4.909 4.909 0 0 1-1.706-.324.501.501 0 0 1-.327-.47v-1.275l-6.395-9.465A.572.572 0 0 1 12 14.41c0-1.425 4.692-1.689 7.488-1.72l.012 1.002c-3.343.036-5.421.41-6.212.7.943.309 3.533.644 7.212.644 3.45 0 5.943-.295 7.017-.587-.5-.133-1.416-.315-3.078-.519l.121-.994c4.122.503 4.44.928 4.44 1.474 0 .131-.06.25-.147.362ZM16.5 11.008h1v-1.001h-1v1.001Zm-1 .501V9.506a.5.5 0 0 1 .5-.501h2a.5.5 0 0 1 .5.5v2.004a.5.5 0 0 1-.5.501h-2a.5.5 0 0 1-.5-.5Zm5-3.506h1V7.002h-1v1.001Zm-1 .501V6.501A.5.5 0 0 1 20 6h2a.5.5 0 0 1 .5.5v2.004a.5.5 0 0 1-.5.501h-2a.5.5 0 0 1-.5-.5Zm2 4.508h1V12.01h-1v1.002Zm-.5-2.004h2a.5.5 0 0 1 .5.501v2.004a.5.5 0 0 1-.5.5h-2a.5.5 0 0 1-.5-.5v-2.004a.5.5 0 0 1 .5-.5Zm3.424 18.325a.5.5 0 0 1-.079.536l-3.469 3.96a.5.5 0 0 1-.752 0l-3.469-3.96a.5.5 0 0 1 .376-.83h1.453v-1.002h1v1.503a.5.5 0 0 1-.5.5h-.849L20.5 32.74l2.365-2.699H22a.5.5 0 0 1-.5-.5v-1.503h1v1.002h1.469c.196 0 .374.114.455.294Z"
      />
    </g>
  </svg>
);

export const AmazonGuardDutyIcon: React.FC<IconSvgProps> = ({
  size = 32,
  width,
  height,
  className = "rounded-md",
  ...props
}) => (
  <svg
    aria-hidden="false"
    aria-label="Amazon GuardDuty logo"
    fill="none"
    focusable="false"
    height={size || height}
    role="presentation"
    viewBox="0 0 40 40"
    width={size || width}
    className={className}
    {...props}
    xmlns="http://www.w3.org/2000/svg"
  >
    <g fill="none" fillRule="evenodd">
      <rect width="40" height="40" fill="#DD344C" />
      <path
        fill="#FFF"
        d="M25 21.814c-.001.19-.074 4.475-4 4.818V14.594l4 1.734v5.486Zm-9-.015v-5.471l4-1.734v12.038c-3.927-.344-3.999-4.643-4-4.833Zm9.699-6.258-5-2.167a.5.5 0 0 0-.398 0l-5 2.167A.499.499 0 0 0 15 16v5.799c0 .059.062 5.867 5.5 5.867 5.437 0 5.5-5.792 5.5-5.851V16c0-.2-.118-.38-.301-.459ZM34 22.752l-1.794-.102a.479.479 0 0 0-.516.389 11.379 11.379 0 0 1-1.482 3.577.498.498 0 0 0 .09.64l1.342 1.197-3.188 3.185-1.191-1.336a.501.501 0 0 0-.64-.09 11.361 11.361 0 0 1-3.582 1.483.502.502 0 0 0-.389.517L22.753 34h-4.506l.103-1.789a.503.503 0 0 0-.389-.517 11.348 11.348 0 0 1-3.578-1.484.505.505 0 0 0-.641.089l-1.194 1.339-3.188-3.186 1.339-1.194a.497.497 0 0 0 .09-.639A11.351 11.351 0 0 1 9.31 23.04c-.054-.238-.245-.394-.517-.39L7 22.752v-4.506l1.797.103a.482.482 0 0 0 .515-.389 11.411 11.411 0 0 1 1.485-3.572.498.498 0 0 0-.09-.64L9.36 12.547l3.188-3.187 1.199 1.345c.162.181.434.22.64.09a11.405 11.405 0 0 1 3.574-1.479.5.5 0 0 0 .389-.516L18.247 7h4.506l-.103 1.802a.502.502 0 0 0 .389.516c1.268.287 2.47.784 3.571 1.48a.5.5 0 0 0 .64-.09l1.202-1.348 3.188 3.187-1.344 1.198a.499.499 0 0 0-.09.64 11.42 11.42 0 0 1 1.482 3.575.489.489 0 0 0 .516.389L34 18.246v4.506Zm.844-5.398a.516.516 0 0 0-.372-.136l-1.909.109a12.42 12.42 0 0 0-1.291-3.113L32.7 12.94a.497.497 0 0 0 .021-.726l-3.936-3.935a.497.497 0 0 0-.726.021l-1.278 1.431a12.348 12.348 0 0 0-3.109-1.288l.109-1.915A.501.501 0 0 0 23.282 6h-5.564a.5.5 0 0 0-.499.528l.109 1.913a12.376 12.376 0 0 0-3.111 1.288L12.941 8.3a.497.497 0 0 0-.358-.167.59.59 0 0 0-.368.146l-3.936 3.935a.5.5 0 0 0 .021.726l1.43 1.276a12.394 12.394 0 0 0-1.292 3.111l-1.91-.109a.544.544 0 0 0-.372.136.5.5 0 0 0-.156.363v5.565a.502.502 0 0 0 .528.499l1.906-.109a12.33 12.33 0 0 0 1.289 3.117L8.3 28.059a.497.497 0 0 0-.021.726l3.936 3.935a.497.497 0 0 0 .726-.021l1.27-1.423a12.35 12.35 0 0 0 3.116 1.293l-.108 1.902a.501.501 0 0 0 .499.529h5.564a.5.5 0 0 0 .499-.529l-.108-1.901a12.374 12.374 0 0 0 3.119-1.292l1.267 1.421a.497.497 0 0 0 .358.167.473.473 0 0 0 .368-.146l3.936-3.935a.5.5 0 0 0-.021-.726l-1.426-1.272a12.275 12.275 0 0 0 1.29-3.115l1.908.109a.502.502 0 0 0 .528-.499v-5.565a.5.5 0 0 0-.156-.363Z"
      />
    </g>
  </svg>
);

export const AWSIAMIcon: React.FC<IconSvgProps> = ({
  size = 32,
  width,
  height,
  className = "rounded-md",
  ...props
}) => (
  <svg
    aria-hidden="false"
    aria-label="AWS IAM logo"
    fill="none"
    focusable="false"
    height={size || height}
    role="presentation"
    viewBox="0 0 40 40"
    width={size || width}
    className={className}
    {...props}
    xmlns="http://www.w3.org/2000/svg"
  >
    <g fill="none" fillRule="evenodd">
      <rect fill="#DD344C" width="40" height="40" />
      <path
        fill="#FFF"
        d="m33.131 31.955-6.998-6.998a.501.501 0 0 1-.092-.58c.945-1.85.63-4.273-.732-5.635a4.629 4.629 0 0 0-3.855-1.33c-1.432.173-2.696 1.001-3.466 2.27a4.583 4.583 0 0 0 .103 4.868c1.354 2.06 3.977 2.781 6.094 1.681a.5.5 0 0 1 .584.091l1.194 1.194a.504.504 0 0 1 .146.39l-.089 1.258 1.38-.003h.001a.5.5 0 0 1 .353.147l.598.597a.502.502 0 0 1 .146.347l.017 1.406 1.231-.106a.502.502 0 0 1 .397.144l1.097 1.097 1.761.45.13-1.288Zm1.019-.135-.213 2.101a.5.5 0 0 1-.621.434l-2.456-.627a.499.499 0 0 1-.23-.13l-1.029-1.03-1.537.133a.499.499 0 0 1-.543-.493l-.021-1.74-.306-.306-1.709.004h-.001a.502.502 0 0 1-.499-.535l.11-1.569-.783-.783c-2.515 1.1-5.491.202-7.057-2.179a5.587 5.587 0 0 1-.122-5.937c.931-1.533 2.462-2.534 4.201-2.744a5.63 5.63 0 0 1 4.682 1.616c1.8 1.8 1.898 4.535 1.072 6.463l6.918 6.918a.5.5 0 0 1 .144.404ZM22.737 21.208a1.087 1.087 0 0 0-.774-.32c-.292 0-.567.113-.774.32a1.098 1.098 0 0 0 0 1.55 1.12 1.12 0 0 0 1.548 0 1.098 1.098 0 0 0 0-1.55Zm.707-.707a2.099 2.099 0 0 1 0 2.964 2.09 2.09 0 0 1-1.481.613 2.09 2.09 0 0 1-1.481-.613 2.099 2.099 0 0 1 0-2.964 2.097 2.097 0 0 1 2.962 0ZM9.662 13.312c0 .263.016.52.047.778a.504.504 0 0 1-.423.56C8.035 14.981 6 15.968 6 18.882c0 .107.006.213.011.315.135 2.461 2.487 3.794 4.633 3.8H15v1h-4.357c-3.063-.008-5.483-2.048-5.63-4.746A6.369 6.369 0 0 1 5 18.882c0-3.389 2.318-4.647 3.677-5.094a7.265 7.265 0 0 1-.015-.476c0-2.777 1.876-5.653 4.364-6.69 2.91-1.226 5.992-.618 8.245 1.625.591.581 1.348 1.451 1.88 2.511.566-.515 1.207-.768 1.941-.768 1.455 0 3.086 1.217 3.376 3.88 3.008.715 4.532 2.43 4.532 5.1 0 2.927-1.281 4.57-3.916 5.02l-.168-.987C30.352 22.758 32 22.08 32 18.97c0-3.018-2.34-3.843-4.099-4.2a.5.5 0 0 1-.4-.462c-.113-1.953-1.103-3.317-2.409-3.317-.664 0-1.186.302-1.691.981a.501.501 0 0 1-.872-.13c-.437-1.22-1.308-2.24-1.961-2.883-1.958-1.95-4.634-2.476-7.157-1.414-2.102.877-3.749 3.41-3.749 5.768Z"
      />
    </g>
  </svg>
);

export const AmazonInspectorIcon: React.FC<IconSvgProps> = ({
  size = 32,
  width,
  height,
  className = "rounded-md",
  ...props
}) => (
  <svg
    aria-hidden="false"
    aria-label="Amazon Inspector logo"
    fill="none"
    focusable="false"
    height={size || height}
    role="presentation"
    viewBox="0 0 40 40"
    width={size || width}
    className={className}
    {...props}
    xmlns="http://www.w3.org/2000/svg"
  >
    <g fill="none" fillRule="evenodd">
      <rect width="40" height="40" fill="#DD344C" />
      <path
        fill="#FFF"
        d="M17.75 15.605c-.66 0-1.196-.547-1.196-1.218 0-.672.536-1.219 1.196-1.219.66 0 1.196.547 1.196 1.22 0 .67-.537 1.217-1.196 1.217m-.888 3.797c1.1 0 1.996.912 1.996 2.034 0 1.121-.895 2.035-1.996 2.035-1.1 0-1.996-.914-1.996-2.035 0-1.122.895-2.034 1.996-2.034m.044 5.956c-3.918 0-7.106-3.25-7.106-7.243 0-3.993 3.188-7.241 7.106-7.241 3.917 0 7.106 3.248 7.106 7.241 0 1.037-.22 2.021-.607 2.914l-3.728-.553a3.016 3.016 0 0 0-1.434-1.718v-2.21a2.215 2.215 0 0 0 1.689-2.16c0-1.227-.98-2.225-2.182-2.225-1.203 0-2.182.998-2.182 2.224 0 1.052.724 1.932 1.689 2.16v1.89c-.131-.017-.26-.04-.395-.04-.783 0-1.492.315-2.025.82l-1.233-1.268c.343-.494.549-1.092.549-1.741 0-1.035-.51-1.986-1.364-2.545l-.533.846a2.02 2.02 0 0 1 .911 1.699c0 1.113-.89 2.02-1.983 2.02v1.005c.644 0 1.238-.215 1.725-.572l1.327 1.366c-.22.424-.356.898-.356 1.409 0 1.676 1.338 3.04 2.982 3.04 1.617 0 2.932-1.323 2.974-2.961l3.073.455c-1.26 2.031-3.477 3.388-6.003 3.388m0-15.489c-4.462 0-8.092 3.7-8.092 8.246 0 4.548 3.63 8.248 8.092 8.248 4.461 0 8.092-3.7 8.092-8.248 0-4.547-3.63-8.246-8.092-8.246M32.593 32.44a1.64 1.64 0 0 1-2.338.126l-6.405-5.888c.852-.72 1.59-1.57 2.194-2.517l6.426 5.898c.676.623.73 1.692.123 2.381M6.986 18.115c0-5.574 4.45-10.11 9.92-10.11 5.469 0 9.919 4.536 9.919 10.11 0 5.575-4.45 10.11-9.92 10.11s-9.919-4.535-9.919-10.11m26.145 11.198-6.576-6.036a11.213 11.213 0 0 0 1.256-5.162C27.81 11.986 22.918 7 16.906 7 10.892 7 6 11.986 6 18.115c0 6.13 4.892 11.116 10.906 11.116 2.276 0 4.391-.718 6.141-1.939l6.548 6.02a2.62 2.62 0 0 0 3.73-.199 2.737 2.737 0 0 0-.194-3.8"
      />
    </g>
  </svg>
);

export const AmazonMacieIcon: React.FC<IconSvgProps> = ({
  size = 32,
  width,
  height,
  className = "rounded-md",
  ...props
}) => (
  <svg
    aria-hidden="false"
    aria-label="Amazon Macie logo"
    fill="none"
    focusable="false"
    height={size || height}
    role="presentation"
    viewBox="0 0 40 40"
    width={size || width}
    className={className}
    {...props}
    xmlns="http://www.w3.org/2000/svg"
  >
    <g fill="none" fillRule="evenodd">
      <rect width="40" height="40" fill="#DD344C" />
      <path
        fill="#FFF"
        d="M28.002 20.905c-.99-.79-1.822-1.451-2.522-1.996.825-1.51 1.788-3.223 2.222-3.599 1.257.812 5.098 7.709 5.33 9.376-.922-.497-3.262-2.369-5.03-3.781m-7.55 4.089c-.288-.139-.885-1.005-1.574-2.13l.44-.726c.892-1.474 2.368-3.91 2.904-4.25.311.104 1.057.624 1.959 1.304-1.124 2.065-3.116 5.702-3.73 5.802m-3.947-.353c-.336-.407-.929-1.507-1.304-2.202-.96-1.782-1.318-2.4-1.832-2.418H13.346c-.407 0-.884.408-2.647 2.068-.675.636-1.66 1.563-2.36 2.12 1.012-2.256 3.974-7.633 4.978-8.98.458.67 1.374 2.315 2.134 3.683.912 1.64 1.646 2.937 2.249 3.949-.468.756-.926 1.466-1.196 1.78m16.791-2.111c-.916-2.129-4.267-8.28-5.607-8.28-.698 0-1.353 1.008-3.016 4.042-1.313-.985-2.04-1.423-2.454-1.438h-.025c-.734 0-1.544 1.144-3.724 4.746l-.175.288c-.692-1.177-1.413-2.474-1.974-3.48-2.188-3.936-2.494-4.389-2.971-4.407L13.34 14c-1.148 0-5.871 9.652-6.164 10.413-.143.372-.32.835.015 1.13.623.551 1.536-.21 4.185-2.704.65-.612 1.504-1.415 1.906-1.71.262.353.72 1.206 1.041 1.802 1.104 2.048 1.576 2.823 2.173 2.84.429-.028.798-.373 1.79-1.951C19.294 25.412 19.87 26 20.364 26h.007c1.111-.013 2.328-1.994 4.617-6.189.8.621 1.651 1.301 2.398 1.899 5.065 4.048 5.837 4.519 6.381 3.916.302-.337.455-.945-.472-3.096"
      />
    </g>
  </svg>
);

export const AWSNetworkFirewallIcon: React.FC<IconSvgProps> = ({
  size = 32,
  width,
  height,
  className = "rounded-md",
  ...props
}) => (
  <svg
    aria-hidden="false"
    aria-label="AWS Network Firewall logo"
    fill="none"
    focusable="false"
    height={size || height}
    role="presentation"
    viewBox="0 0 40 40"
    width={size || width}
    className={className}
    {...props}
    xmlns="http://www.w3.org/2000/svg"
  >
    <g fill="none" fillRule="evenodd">
      <rect width="40" height="40" fill="#DD344C" />
      <path
        fill="#FFF"
        d="M33.007 29.006h-7v-3h7v3Zm-6 4h-6v-3h6v3Zm-10.257-1.74a6.062 6.062 0 0 1-5.137-2.823c-.896-1.41-.912-3.23-.01-4.802 1.049-1.593.672-3.807.336-5.027.964.493 1.838 1.755 2.147 2.311a.486.486 0 0 0 .478.256.497.497 0 0 0 .429-.327c.967-2.655.31-4.611-.4-5.776 2.07.699 5.66 2.6 5.66 7.379 0 .136.056.266.154.361a.484.484 0 0 0 .368.138c.59-.025 1.651-.473 2.16-1.886.044.133.072.279.072.436v3.5h-5.5a.5.5 0 0 0-.5.5v4a.5.5 0 0 0 .5.5h2.5v.384c-.855.561-1.999.876-3.257.876Zm-7.691-8.609c-.976-.646-2.139-1.874-2.139-4.059 0-2.988 2.079-3.968 3.318-4.287a.498.498 0 0 0 .375-.514l-.049-.821c0-2.33 1.735-6.026 6.391-6.026 1.896 0 3.399.545 4.466 1.619.763.766 1.356 1.745 1.767 2.909a.5.5 0 0 0 .874.131c.62-.842 1.69-1.194 2.659-.875 1.098.36 1.726 1.437 1.723 2.936a.5.5 0 0 0 .411.563c2.794.481 4.152 1.827 4.152 4.113 0 1.322-.341 2.333-1.016 3.084a.493.493 0 0 0-.484-.424h-7.559c-.206-.937-.921-1.499-.956-1.526a.496.496 0 0 0-.502-.062.496.496 0 0 0-.298.407c-.124 1.181-.589 1.708-.962 1.944-.465-6.83-7.828-8.036-7.906-8.048a.5.5 0 0 0-.388.884c.093.076 2.086 1.74 1.409 4.904-.67-.891-1.824-2.098-3.16-2.098a.5.5 0 0 0-.464.686c.013.032 1.201 3.068.093 4.909h-.564c-.434 0-.847-.121-1.191-.349Zm16.448 2.349h-1.5v-3h7v3h-5.5Zm-.5 4h-7v-3h7v3Zm8.5-4h-1.5v-2.241c1.324-.963 2-2.446 2-4.419 0-1.868-.806-4.221-4.57-5.019-.105-1.766-.987-3.077-2.404-3.543a3.354 3.354 0 0 0-3.197.618 8.365 8.365 0 0 0-1.706-2.539c-1.262-1.269-3.003-1.913-5.175-1.913-5.098 0-7.391 4.109-7.39 7.056l.027.453c-1.352.444-3.672 1.708-3.672 5.139 0 2.768 1.62 4.254 2.587 4.893a3.145 3.145 0 0 0 1.743.515h.075c-.641 1.656-.496 3.495.445 4.974a7.059 7.059 0 0 0 5.98 3.286c1.203 0 2.325-.26 3.257-.726v1.966a.5.5 0 0 0 .5.5h7a.5.5 0 0 0 .5-.5v-3.5h5.5a.5.5 0 0 0 .5-.5v-4a.5.5 0 0 0-.5-.5Z"
      />
    </g>
  </svg>
);

export const AWSOrganizationsIcon: React.FC<IconSvgProps> = ({
  size = 32,
  width,
  height,
  className = "rounded-md",
  ...props
}) => (
  <svg
    aria-hidden="false"
    aria-label="AWS Organizations logo"
    fill="none"
    focusable="false"
    height={size || height}
    role="presentation"
    viewBox="0 0 40 40"
    width={size || width}
    className={className}
    {...props}
    xmlns="http://www.w3.org/2000/svg"
  >
    <g fill="none" fillRule="evenodd">
      <rect width="40" height="40" fill="#E7157B" />
      <path
        fill="#FFF"
        d="M28.986 32.001h3.016v-3.039h-3.016v3.039Zm-10.025 0h3.077v-3.039h-3.077v3.039Zm-9.963 0h3.037v-3.039H8.998v3.039Zm23.503-4.038h-1.498v-2.497a.5.5 0 0 0-.499-.5H21.02V22.97h-.998v1.997h-9.484c-.277 0-.5.224-.5.5v2.497H8.5c-.276 0-.499.224-.499.5V32.5c0 .275.223.499.5.499h4.034a.5.5 0 0 0 .5-.5v-4.037a.5.5 0 0 0-.5-.5h-1.497v-1.998h8.985v1.998h-1.56a.5.5 0 0 0-.5.5V32.5a.5.5 0 0 0 .5.499h4.076c.276 0 .499-.224.499-.5v-4.037c0-.276-.223-.5-.5-.5H21.02v-1.998h8.985v1.998h-1.518a.5.5 0 0 0-.5.5V32.5a.5.5 0 0 0 .5.499H32.5a.5.5 0 0 0 .499-.5v-4.037a.5.5 0 0 0-.5-.5ZM20.537 9.04l4.788 1.983-4.803 2.397-4.775-2.396 4.79-1.984Zm.497 11.6-.013-6.353 5.007-2.499v5.882l-4.994 2.97Zm-5.988-8.85 4.977 2.497.013 6.351-4.99-2.968v-5.88Zm5.235 10.157a.51.51 0 0 0 .512 0l5.99-3.563a.501.501 0 0 0 .243-.43v-6.973a.5.5 0 0 0-.307-.461l-5.99-2.482a.497.497 0 0 0-.383 0l-5.99 2.482a.5.5 0 0 0-.308.461v6.974c0 .176.093.34.243.43l5.99 3.562Z"
      />
    </g>
  </svg>
);

export const AmazonRDSIcon: React.FC<IconSvgProps> = ({
  size = 32,
  width,
  height,
  className = "rounded-md",
  ...props
}) => (
  <svg
    aria-hidden="false"
    aria-label="Amazon RDS logo"
    fill="none"
    focusable="false"
    height={size || height}
    role="presentation"
    viewBox="0 0 40 40"
    width={size || width}
    className={className}
    {...props}
    xmlns="http://www.w3.org/2000/svg"
  >
    <g fill="none" fillRule="evenodd">
      <rect width="40" height="40" fill="#C925D1" />
      <path
        fill="#FFF"
        d="M11.854 28.854 7.708 33H10.5v1h-4a.5.5 0 0 1-.5-.5v-4h1v2.793l4.147-4.146.707.707ZM33 29.5h1v4c0 .277-.223.5-.5.5h-4v-1h2.793l-4.146-4.146.707-.707L33 32.293V29.5Zm1-23v4h-1V7.708l-4.146 4.146-.707-.707L32.293 7H29.5V6h4a.5.5 0 0 1 .5.5Zm-27 4H6v-4a.5.5 0 0 1 .5-.5h4v1H7.527l4.319 4.14-.691.721L7 7.88v2.62Zm25.726 8.9c0-1.558-1.806-3.1-4.83-4.123l.32-.947c3.502 1.185 5.51 3.033 5.51 5.07 0 2.037-2.008 3.886-5.51 5.071l-.32-.948c3.024-1.023 4.83-2.565 4.83-4.123Zm-24.989 0c0 1.492 1.69 2.993 4.521 4.014l-.34.94c-3.293-1.187-5.181-2.993-5.181-4.954 0-1.961 1.888-3.767 5.181-4.955l.34.941c-2.831 1.021-4.521 2.522-4.521 4.014Zm12.286-3.681c-3.136 0-4.891-.799-4.917-1.125.026-.326 1.781-1.125 4.917-1.125 3.133 0 4.89.798 4.917 1.125-.027.326-1.784 1.125-4.917 1.125Zm0 3.555c-3.182 0-4.917-.926-4.917-1.402v-2.03c1.135.595 3.069.877 4.917.877 1.848 0 3.782-.282 4.917-.877v2.03c0 .476-1.735 1.402-4.917 1.402Zm0 3.737c-3.182 0-4.917-.927-4.917-1.403v-2.343c1.119.665 3.023 1.009 4.917 1.009 1.894 0 3.798-.344 4.917-1.009v2.343c0 .476-1.735 1.403-4.917 1.403Zm0 3.279c-3.182 0-4.917-.915-4.917-1.385v-1.904c1.119.666 3.023 1.01 4.917 1.01 1.894 0 3.798-.344 4.917-1.01v1.904c0 .47-1.735 1.385-4.917 1.385Zm0-13.821c-2.85 0-5.917.665-5.917 2.125v10.311c0 1.566 2.977 2.385 5.917 2.385s5.917-.819 5.917-2.385V14.594c0-1.46-3.067-2.125-5.917-2.125Z"
      />
    </g>
  </svg>
);

export const AWSResourceExplorerIcon: React.FC<IconSvgProps> = ({
  size = 32,
  width,
  height,
  className = "rounded-md",
  ...props
}) => (
  <svg
    aria-hidden="false"
    aria-label="AWS Resource Explorer logo"
    fill="none"
    focusable="false"
    height={size || height}
    role="presentation"
    viewBox="0 0 40 40"
    width={size || width}
    className={className}
    {...props}
    xmlns="http://www.w3.org/2000/svg"
  >
    <g fill="none" fillRule="evenodd">
      <rect width="40" height="40" fill="#E7157B" />
      <path
        fill="#FFF"
        d="m32.746 30.427-5.431-5.48a7.535 7.535 0 0 1-2.217 2.277l5.346 5.515c.214.213.493.3.833.247.37-.057.76-.273 1.097-.61.576-.577.889-1.431.372-1.95ZM26.396 30l-2.201-2.27a7.424 7.424 0 0 1-3.212.735c-.334 0-.66-.03-.983-.073v4.35L26.396 30ZM7 27.18l12 5.538V28.19c-3.163-.872-5.496-3.767-5.496-7.204 0-1.524.461-2.942 1.247-4.125L7 13.283V27.18Zm.693-14.68 7.687 3.547a7.459 7.459 0 0 1 5.603-2.542c1.751 0 3.359.61 4.635 1.62l5.688-2.624L19.5 7.05l-11.807 5.45Zm19.77 8.485a6.487 6.487 0 0 0-6.48-6.48 6.487 6.487 0 0 0-6.479 6.48 6.486 6.486 0 0 0 6.479 6.48 6.487 6.487 0 0 0 6.48-6.48Zm3.833 6.558.704-.351v-13.91l-5.585 2.578a7.424 7.424 0 0 1 1.395 8.166l3.486 3.517Zm2.159 2.178c.864.866.707 2.28-.374 3.362-.486.486-1.073.803-1.651.892a2.299 2.299 0 0 1-.336.026c-.522 0-.996-.194-1.363-.56l-2.59-2.672-7.444 3.19a.5.5 0 0 1-.407-.005l-13-6A.5.5 0 0 1 6 27.5v-15a.5.5 0 0 1 .29-.454l13-6a.497.497 0 0 1 .42 0l13 6a.5.5 0 0 1 .29.455v15a.503.503 0 0 1-.276.447l-.687.343 1.418 1.43ZM19 23h1v-2h-1v2Zm0 3h1v-2h-1v2Zm3.415-9.395.42.907 1.267-.585-.419-.909-1.268.587Zm-1.353.622.42.909L20 18.82V20h-1v-1.18l-1.967-.907.42-.909 2.047.945 1.562-.722Z"
      />
    </g>
  </svg>
);

export const AmazonRoute53Icon: React.FC<IconSvgProps> = ({
  size = 32,
  width,
  height,
  className = "rounded-md",
  ...props
}) => (
  <svg
    aria-hidden="false"
    aria-label="Amazon Route 53 logo"
    fill="none"
    focusable="false"
    height={size || height}
    role="presentation"
    viewBox="0 0 40 40"
    width={size || width}
    className={className}
    {...props}
    xmlns="http://www.w3.org/2000/svg"
  >
    <g fill="none" fillRule="evenodd">
      <path fill="#8C4FFF" d="M0 0h40v40H0z" />
      <path
        fill="#FFF"
        d="M24.024 20.314c.343.317.514.74.514 1.272 0 .58-.208 1.042-.624 1.388-.416.345-.977.518-1.68.518a4.112 4.112 0 0 1-1.647-.354v-.71c.643.214 1.193.32 1.648.32.448 0 .794-.101 1.036-.302.242-.2.363-.488.363-.86 0-.715-.452-1.072-1.355-1.072a8.13 8.13 0 0 0-.842.044v-.585l1.86-2.03h-2.622v-.726h3.607v.7l-1.826 1.932a.447.447 0 0 1 .089-.009h.088c.584 0 1.048.159 1.391.474m-5.147-.154c.359.336.54.8.54 1.39 0 .58-.21 1.049-.63 1.405-.42.358-.972.537-1.656.537a4.09 4.09 0 0 1-1.692-.354v-.71c.655.214 1.216.32 1.683.32.448 0 .793-.102 1.032-.306.239-.204.36-.498.36-.882 0-.42-.113-.725-.338-.913-.224-.189-.59-.284-1.099-.284-.366 0-.823.03-1.373.09v-.587l.169-2.65h3.233v.727h-2.489l-.116 1.8c.326-.06.618-.09.878-.09.638 0 1.138.17 1.498.507m6.653 6.462c-2.242.403-4.207 1.313-5.53 2.059-1.323-.746-3.288-1.656-5.53-2.06-.627-.112-3.755-.764-3.755-2.558 0-.836.301-1.392.877-2.385.696-1.2 1.562-2.693 1.562-4.848 0-1.528-.399-2.996-1.187-4.368l.25-.306c2.61 1.293 5.533 1.118 7.783-.304 2.25 1.421 5.173 1.597 7.783.304l.25.306c-.788 1.372-1.188 2.84-1.188 4.368 0 2.155.866 3.648 1.563 4.848.576.993.876 1.549.876 2.385 0 1.794-3.127 2.446-3.754 2.559m2.312-9.792c0-1.454.41-2.849 1.22-4.146a.502.502 0 0 0-.036-.58l-.726-.893a.497.497 0 0 0-.63-.123c-1.134.627-2.319.945-3.518.945-1.448 0-2.714-.39-3.868-1.19a.502.502 0 0 0-.568 0c-1.155.8-2.42 1.19-3.868 1.19-1.2 0-2.384-.318-3.52-.945a.495.495 0 0 0-.628.123l-.726.893a.5.5 0 0 0-.036.58c.809 1.297 1.219 2.692 1.219 4.146 0 1.887-.791 3.25-1.428 4.347-.626 1.08-1.011 1.798-1.011 2.886 0 2.524 3.502 3.348 4.575 3.54 2.246.404 4.207 1.356 5.456 2.084a.493.493 0 0 0 .502 0c1.25-.728 3.21-1.68 5.455-2.083 1.074-.193 4.575-1.017 4.575-3.541 0-1.088-.384-1.806-1.01-2.886-.637-1.096-1.429-2.46-1.429-4.347M26.01 29.297c-2.822.507-5.19 2.016-6.01 2.588-.82-.572-3.188-2.08-6.01-2.588-1.406-.252-5.992-1.376-5.992-5.234 0-1.606.631-2.696 1.244-3.75.587-1.013 1.195-2.06 1.195-3.483 0-2.217-1.265-3.791-1.913-4.452.676-.821 2.314-2.818 3.147-3.89 1.263 1.18 2.728 1.824 4.177 1.824 1.61 0 2.942-.65 4.152-2.036 1.21 1.387 2.543 2.036 4.152 2.036 1.449 0 2.914-.643 4.176-1.824.833 1.072 2.472 3.069 3.148 3.89-.649.66-1.913 2.235-1.913 4.452 0 1.423.608 2.47 1.195 3.483.612 1.054 1.244 2.144 1.244 3.75 0 3.858-4.587 4.982-5.992 5.234m5.611-9.485c-.57-.98-1.06-1.828-1.06-2.982 0-2.43 1.892-4.004 1.912-4.02a.503.503 0 0 0 .07-.705c-.03-.037-3.066-3.716-3.759-4.668a.497.497 0 0 0-.768-.047c-1.16 1.24-2.532 1.924-3.864 1.924-1.471 0-2.63-.656-3.756-2.128a.516.516 0 0 0-.793 0c-1.126 1.472-2.285 2.128-3.755 2.128-1.332 0-2.704-.683-3.864-1.924a.497.497 0 0 0-.768.047c-.693.952-3.728 4.63-3.76 4.668a.502.502 0 0 0 .072.705c.019.016 1.911 1.575 1.911 4.02 0 1.154-.49 2.001-1.061 2.982C7.732 20.926 7 22.188 7 24.062c0 3.127 2.546 5.451 6.813 6.217 3.19.574 5.857 2.597 5.883 2.617a.499.499 0 0 0 .608 0c.026-.02 2.694-2.043 5.883-2.617C30.453 29.513 33 27.19 33 24.063c0-1.875-.732-3.137-1.379-4.25"
      />
    </g>
  </svg>
);

export const AmazonS3Icon: React.FC<IconSvgProps> = ({
  size = 32,
  width,
  height,
  className = "rounded-md",
  ...props
}) => (
  <svg
    aria-hidden="false"
    aria-label="Amazon S3 logo"
    fill="none"
    focusable="false"
    height={size || height}
    role="presentation"
    viewBox="0 0 32 32"
    width={size || width}
    className={className}
    {...props}
    xmlns="http://www.w3.org/2000/svg"
  >
    <g clipPath="url(#a)">
      <rect width="32" height="32" fill="#7AA116" />
      <path
        fill="#fff"
        fillRule="evenodd"
        d="m24.426 17.113.157-1.167c1.674.959 1.708 1.355 1.708 1.366-.004.002-.284.226-1.865-.2Zm-.775-.23c-2.273-.718-5.328-2.058-7.072-2.88 0-.005.003-.01.003-.016a.964.964 0 0 0-.963-.962.963.963 0 0 0 0 1.925.947.947 0 0 0 .604-.23c1.015.475 4.637 2.14 7.32 2.97l-.944 6.99c0 .693-2.939 1.72-6.999 1.72s-6.999-1.027-7.003-1.773L6.627 10.05C8.367 11.324 12.059 12 15.6 12c3.541 0 7.235-.676 8.975-1.95l-.924 6.832ZM6.403 8.39c.023-.704 3.28-2.79 9.197-2.79 5.916 0 9.176 2.086 9.2 2.79v.091c-.152 1.303-3.89 2.718-9.2 2.718-5.31 0-9.033-1.415-9.185-2.717l-.012-.092Zm19.197.01c0-1.469-3.895-3.601-10-3.601s-10 2.132-10 3.6v.054L7.801 24.68c0 1.637 4.018 2.52 7.8 2.52 3.78 0 7.798-.883 7.794-2.466l.922-6.822c.657.171 1.188.262 1.597.262.474 0 .795-.115.989-.346a.78.78 0 0 0 .173-.665c-.11-.59-.838-1.228-2.364-2.067l-.017.02.905-6.662V8.4Z"
        clipRule="evenodd"
      />
    </g>
    <defs>
      <clipPath id="a">
        <rect width="32" height="32" fill="#fff" rx="4" />
      </clipPath>
    </defs>
  </svg>
);

export const JiraIcon: React.FC<IconSvgProps> = ({
  size = 32,
  width,
  height,
  className = "rounded-md",
  ...props
}) => (
  <svg
    aria-hidden="false"
    aria-label="Jira logo"
    fill="none"
    focusable="false"
    height={size || height}
    role="presentation"
    viewBox="0 0 48 48"
    width={size || width}
    className={className}
    {...props}
    xmlns="http://www.w3.org/2000/svg"
  >
    <path
      d="M0 12C0 5.37258 5.37258 0 12 0H36C42.6274 0 48 5.37258 48 12V36C48 42.6274 42.6274 48 36 48H12C5.37258 48 0 42.6274 0 36V12Z"
      fill="#1868DB"
    />
    <g clipPath="url(#jira-clip)">
      <path
        d="M17.9475 31.0469H15.2429C11.1638 31.0469 8.23755 28.5484 8.23755 24.8899H22.7804C23.5341 24.8899 24.0218 25.4252 24.0218 26.1837V40.8178C20.3861 40.8178 17.9475 37.8731 17.9475 33.7684V31.0469ZM25.1303 23.7745H22.4257C18.3466 23.7745 15.4203 21.3206 15.4203 17.6621H29.9631C30.7168 17.6621 31.2489 18.1528 31.2489 18.9113V33.5454C27.6132 33.5454 25.1303 30.6007 25.1303 26.496V23.7745ZM32.3573 16.5467H29.6527C25.5736 16.5467 22.6473 14.0482 22.6473 10.3896H37.1902C37.9439 10.3896 38.4316 10.925 38.4316 11.6389V26.273C34.7959 26.273 32.3573 23.3283 32.3573 19.2236V16.5467Z"
        fill="white"
      />
    </g>
    <defs>
      <clipPath id="jira-clip">
        <rect
          width="30.1941"
          height="30.4281"
          fill="white"
          transform="translate(8.23755 10.3901)"
        />
      </clipPath>
    </defs>
  </svg>
);

export const AWSSecurityHubIcon: React.FC<IconSvgProps> = ({
  size = 32,
  width,
  height,
  className = "rounded-md",
  ...props
}) => (
  <svg
    aria-hidden="false"
    aria-label="AWS Security Hub logo"
    fill="none"
    focusable="false"
    height={size || height}
    role="presentation"
    viewBox="0 0 40 40"
    width={size || width}
    className={className}
    {...props}
    xmlns="http://www.w3.org/2000/svg"
  >
    <g fill="none" fillRule="evenodd">
      <path fill="#DD344C" d="M0 0h40v40H0z" />
      <path
        fill="#FFF"
        d="M22.034 20.429c0 .086-.034 1.908-1.507 2.258v-5.498l1.507.653v2.587Zm-4.014-.008v-2.579l1.507-.653v5.5c-1.435-.335-1.506-2.052-1.507-2.268Zm4.713-3.367-2.507-1.085a.5.5 0 0 0-.398 0l-2.507 1.085a.501.501 0 0 0-.301.459v2.908c0 1.155.629 3.339 3.007 3.339s3.007-2.179 3.007-3.331v-2.916a.501.501 0 0 0-.301-.459Zm6.657 9.792c-.882 0-1.6-.718-1.6-1.601s.718-1.601 1.6-1.601c.883 0 1.601.718 1.601 1.601s-.718 1.601-1.601 1.601Zm-9.315-2.101a4.988 4.988 0 0 1-4.983-4.983 4.988 4.988 0 0 1 4.983-4.984 4.99 4.99 0 0 1 4.984 4.984 4.989 4.989 0 0 1-4.984 4.983Zm1.553 6.058c0 .882-.718 1.601-1.601 1.601s-1.6-.719-1.6-1.601a1.602 1.602 0 0 1 3.201 0ZM18.427 8.601c0-.882.717-1.601 1.6-1.601.883 0 1.601.719 1.601 1.601a1.602 1.602 0 0 1-3.201 0ZM10.6 26.24c-.882 0-1.6-.718-1.6-1.601 0-.882.718-1.601 1.6-1.601.883 0 1.601.719 1.601 1.601 0 .883-.718 1.601-1.601 1.601Zm.408-10.629a1.603 1.603 0 0 1-1.601-1.601c0-.883.718-1.601 1.601-1.601.882 0 1.601.718 1.601 1.601s-.719 1.601-1.601 1.601Zm18.446-3.457a1.602 1.602 0 0 1 0 3.201 1.602 1.602 0 0 1 0-3.201Zm-.064 10.49c-.718 0-1.37.294-1.841.767l-1.969-1.305c.308-.72.479-1.512.479-2.344a5.942 5.942 0 0 0-.806-2.988l2.253-1.315c.477.545 1.17.896 1.948.896a2.604 2.604 0 0 0 2.601-2.601c0-1.434-1.167-2.6-2.601-2.6a2.603 2.603 0 0 0-2.601 2.6c0 .296.061.575.152.841l-2.322 1.354a5.97 5.97 0 0 0-4.156-2.148v-2.65a2.604 2.604 0 0 0 2.101-2.55A2.604 2.604 0 0 0 20.027 6a2.604 2.604 0 0 0-2.6 2.601c0 1.263.905 2.316 2.1 2.55v2.654a5.978 5.978 0 0 0-4.26 2.41l-1.857-1.211c.127-.307.199-.642.199-.994a2.604 2.604 0 0 0-2.601-2.601 2.604 2.604 0 0 0-2.601 2.601 2.604 2.604 0 0 0 2.601 2.601 2.59 2.59 0 0 0 1.847-.774l1.886 1.229a5.933 5.933 0 0 0-.649 2.696c0 .739.14 1.444.386 2.098l-1.917 1.09a2.584 2.584 0 0 0-1.961-.912A2.604 2.604 0 0 0 8 24.639a2.603 2.603 0 0 0 2.6 2.601 2.604 2.604 0 0 0 2.601-2.601c0-.288-.059-.56-.145-.819l1.853-1.055a5.984 5.984 0 0 0 4.618 2.952v2.536a2.603 2.603 0 0 0-2.1 2.55 2.604 2.604 0 0 0 2.6 2.601 2.604 2.604 0 0 0 2.601-2.601 2.604 2.604 0 0 0-2.101-2.55v-2.531a5.979 5.979 0 0 0 4.577-2.73l1.888 1.25a2.604 2.604 0 0 0 2.398 3.604 2.604 2.604 0 0 0 2.601-2.601 2.604 2.604 0 0 0-2.601-2.601Z"
      />
    </g>
  </svg>
);

export const AmazonSNSIcon: React.FC<IconSvgProps> = ({
  size = 32,
  width,
  height,
  className = "rounded-md",
  ...props
}) => (
  <svg
    aria-hidden="false"
    aria-label="Amazon Simple Notification Service logo"
    fill="none"
    focusable="false"
    height={size || height}
    role="presentation"
    viewBox="0 0 40 40"
    width={size || width}
    className={className}
    {...props}
    xmlns="http://www.w3.org/2000/svg"
  >
    <g fill="none" fillRule="evenodd">
      <path fill="#E7157B" d="M0 0h40v40H0z" />
      <path
        fill="#FFF"
        d="M7.01 20.078a1.1 1.1 0 0 1 1.105-1.093 1.1 1.1 0 0 1 1.104 1.093 1.1 1.1 0 0 1-1.104 1.093 1.1 1.1 0 0 1-1.105-1.093ZM20.776 33C14.813 33 9.645 28.375 8.47 22.136a2.1 2.1 0 0 0 1.69-1.558h2.949v-1h-2.95a2.104 2.104 0 0 0-1.653-1.554C9.72 12.252 14.838 8 20.776 8c2.933 0 5.354.643 7.194 1.911l.575-.821C26.534 7.703 23.92 7 20.776 7c-6.51 0-12.104 4.726-13.308 11.096C6.62 18.368 6 19.149 6 20.078c0 .916.602 1.688 1.431 1.971C8.591 28.894 14.24 34 20.776 34c3.285 0 6.788-1.667 8.786-3.094l-.59-.811C26.947 31.541 23.627 33 20.777 33ZM14.79 18.242c1.111.274 2.523.321 3.343.321.833 0 2.271-.047 3.402-.32l-2.401 5.014a.507.507 0 0 0-.048.215v2.324l-1.957.915v-3.239a.514.514 0 0 0-.044-.206l-2.295-5.024Zm3.343-1.757c2.314 0 3.554.311 3.951.52-.417.234-1.745.558-3.95.558-2.184 0-3.483-.327-3.873-.558.37-.206 1.582-.52 3.872-.52Zm-1.78 11.438a.511.511 0 0 0 .486.03l2.968-1.388a.5.5 0 0 0 .288-.452v-2.529l2.909-6.074a.806.806 0 0 0 .189-.51c0-1.252-2.751-1.515-5.06-1.515-2.266 0-4.969.263-4.969 1.515 0 .19.067.355.18.502l2.775 6.077V27.5c0 .172.088.331.235.423ZM30.877 27a1.1 1.1 0 0 1 1.104 1.093 1.1 1.1 0 0 1-1.104 1.093 1.1 1.1 0 0 1-1.104-1.093A1.1 1.1 0 0 1 30.876 27Zm0-16.03a1.1 1.1 0 0 1 1.104 1.093 1.1 1.1 0 0 1-1.104 1.093 1.1 1.1 0 0 1-1.104-1.093 1.1 1.1 0 0 1 1.104-1.093Zm1.01 8.015a1.1 1.1 0 0 1 1.104 1.093 1.1 1.1 0 0 1-1.104 1.093 1.1 1.1 0 0 1-1.104-1.093 1.1 1.1 0 0 1 1.104-1.093Zm-4.607 1.593h2.561a2.108 2.108 0 0 0 2.046 1.593A2.106 2.106 0 0 0 34 20.078a2.106 2.106 0 0 0-2.114-2.093c-.992 0-1.818.681-2.046 1.593H27.28v-7.015h1.551a2.108 2.108 0 0 0 2.046 1.593 2.106 2.106 0 0 0 2.114-2.093 2.106 2.106 0 0 0-2.114-2.093c-.991 0-1.818.681-2.046 1.593h-2.056a.502.502 0 0 0-.505.5v7.515h-3.061v1h3.061v7.515c0 .277.226.5.505.5h2.056a2.108 2.108 0 0 0 2.046 1.593 2.106 2.106 0 0 0 2.114-2.093A2.106 2.106 0 0 0 30.876 26c-.991 0-1.818.681-2.046 1.593H27.28v-7.015Z"
      />
    </g>
  </svg>
);

export const AWSSystemsManagerIncidentManagerIcon: React.FC<IconSvgProps> = ({
  size = 32,
  width,
  height,
  className = "rounded-md",
  ...props
}) => (
  <svg
    aria-hidden="false"
    aria-label="AWS Systems Manager Incident Manager logo"
    fill="none"
    focusable="false"
    height={size || height}
    role="presentation"
    viewBox="0 0 40 40"
    width={size || width}
    className={className}
    {...props}
    xmlns="http://www.w3.org/2000/svg"
  >
    <g fill="none" fillRule="evenodd">
      <path fill="#E7157B" d="M0 0h40v40H0z" />
      <path
        fill="#FFF"
        d="M24 27h5v1h-5v1h-1v-1h-2v-1h2v-1h1v1Zm4-5.001h1v1h-1v1h-1v-1h-6v-1h6v-1h1v1Zm-17.643 1H15v1h-4.643c-.531 0-1.081 0-1.647-.353C7.698 23.019 6 21.55 6 18.764c0-3.376 2.33-4.615 3.689-5.05l-.026-.437c-.001-2.783 1.875-5.633 4.363-6.661 2.908-1.213 5.988-.611 8.243 1.606a8.21 8.21 0 0 1 1.718 2.498 3.409 3.409 0 0 1 3.245-.602c1.398.466 2.27 1.744 2.38 3.455 1.631.274 4.388.86 4.388 4.425h-1c0-2.64-1.691-3.132-3.734-3.47l-.238-.038a.499.499 0 0 1-.402-.608c-.002-1.404-.625-2.453-1.71-2.816a2.422 2.422 0 0 0-2.703.853.498.498 0 0 1-.869-.13c-.416-1.146-1.013-2.105-1.776-2.854-1.959-1.926-4.634-2.447-7.158-1.396-2.102.869-3.748 3.375-3.748 5.708l.05.808a.501.501 0 0 1-.378.516C9.089 14.88 7 15.837 7 18.764c0 2.186 1.217 3.4 2.238 4.033.309.192.626.202 1.119.202ZM33 26.159l-.882-.05a.515.515 0 0 0-.516.39 6.684 6.684 0 0 1-.873 2.11.5.5 0 0 0 .089.64l.66.587-1.642 1.64-.585-.655a.501.501 0 0 0-.641-.091 6.671 6.671 0 0 1-2.112.876.5.5 0 0 0-.389.517l.051.877h-2.32l.051-.878a.502.502 0 0 0-.389-.517 6.686 6.686 0 0 1-2.112-.876.502.502 0 0 0-.64.09l-.586.658-1.642-1.64.659-.588a.5.5 0 0 0 .09-.64 6.683 6.683 0 0 1-.875-2.11c-.053-.239-.245-.396-.515-.39l-.881.05v-2.32l.884.05c.271.006.462-.151.515-.39a6.72 6.72 0 0 1 .875-2.106.5.5 0 0 0-.089-.64l-.663-.59 1.642-1.642.59.662a.503.503 0 0 0 .64.09 6.702 6.702 0 0 1 2.108-.873.502.502 0 0 0 .389-.517l-.051-.885h2.32l-.051.886a.502.502 0 0 0 .389.517 6.713 6.713 0 0 1 2.107.873.5.5 0 0 0 .64-.09l.591-.663 1.642 1.641-.662.59a.501.501 0 0 0-.089.64 6.68 6.68 0 0 1 .875 2.108.479.479 0 0 0 .515.389l.883-.05v2.32Zm.472-3.348-1 .057a7.68 7.68 0 0 0-.682-1.645l.748-.668a.497.497 0 0 0 .021-.726l-2.39-2.39a.5.5 0 0 0-.727.021l-.67.751a7.617 7.617 0 0 0-1.641-.68l.057-1.004a.5.5 0 0 0-.499-.53h-3.378a.5.5 0 0 0-.499.53l.057 1.002a7.697 7.697 0 0 0-1.642.68l-.669-.749a.5.5 0 0 0-.359-.167.532.532 0 0 0-.368.146l-2.39 2.39a.5.5 0 0 0 .021.726l.749.67a7.71 7.71 0 0 0-.681 1.643l-1.002-.057a.529.529 0 0 0-.372.135.505.505 0 0 0-.156.364v3.378a.5.5 0 0 0 .528.5l.998-.058c.163.576.392 1.127.681 1.647l-.745.665a.497.497 0 0 0-.021.727l2.39 2.39a.527.527 0 0 0 .368.146.5.5 0 0 0 .359-.167l.664-.746a7.72 7.72 0 0 0 1.647.684l-.057.995a.502.502 0 0 0 .499.529h3.378a.5.5 0 0 0 .499-.53l-.057-.993a7.716 7.716 0 0 0 1.648-.684l.663.745a.5.5 0 0 0 .727.02l2.39-2.39a.5.5 0 0 0-.021-.726l-.747-.666a7.686 7.686 0 0 0 .682-1.646l.999.057a.5.5 0 0 0 .528-.499V23.31a.505.505 0 0 0-.156-.364.529.529 0 0 0-.372-.135Z"
      />
    </g>
  </svg>
);

export const AWSTrustedAdvisorIcon: React.FC<IconSvgProps> = ({
  size = 32,
  width,
  height,
  className = "rounded-md",
  ...props
}) => (
  <svg
    aria-hidden="false"
    aria-label="AWS Trusted Advisor logo"
    fill="none"
    focusable="false"
    height={size || height}
    role="presentation"
    viewBox="0 0 64 64"
    width={size || width}
    className={className}
    {...props}
    xmlns="http://www.w3.org/2000/svg"
  >
    <g fill="none" fillRule="evenodd">
      <path fill="#E7157B" d="M0 0h64v64H0z" />
      <path
        fill="#FFF"
        d="m26 18.662 5-2.115v17.396c-4.854-.555-5-5.125-5-5.175V18.662Zm12 10.106c0 .05-.146 4.62-5 5.175V16.547l5 2.115v10.106ZM32 36c6.563 0 8-5.219 8-7.23v-10.77a.998.998 0 0 0-.61-.92l-7-2.962a1.005 1.005 0 0 0-.78 0l-7 2.962A.998.998 0 0 0 24 18v10.77c0 2.011 1.438 7.23 8 7.23ZM22 15.773l10-3.707 10 3.707v12.188C42 31.711 40.701 38 32 38c-9.518 0-10-8.362-10-10.038V15.773ZM32 40c11.135 0 12-9.214 12-12.038V15.078a1 1 0 0 0-.652-.938l-11-4.078a1.004 1.004 0 0 0-.696 0l-11 4.078a1 1 0 0 0-.652.938v12.883C20 29.193 20.337 40 32 40Zm17 6c-1.103 0-2-.897-2-2s.897-2 2-2 2 .897 2 2-.897 2-2 2Zm-15 4c0 1.103-.897 2-2 2s-2-.897-2-2 .897-2 2-2 2 .897 2 2Zm-19-4c-1.103 0-2-.897-2-2s.897-2 2-2 2 .897 2 2-.897 2-2 2Zm34-6c-.997 0-1.899.38-2.601.986l-1.672-1.674c2.5-2.055 4.626-4.714 6.171-7.872l-1.796-.88C45.646 37.616 39.093 42 32 42c-7.359 0-14.804-4.704-18.102-11.44l-1.796.88c1.488 3.04 3.69 5.664 6.32 7.725l-1.402 1.402A3.966 3.966 0 0 0 15 40c-2.206 0-4 1.795-4 4 0 2.206 1.794 4 4 4s4-1.794 4-4c0-.739-.216-1.424-.566-2.019l1.633-1.633c3.269 2.13 7.055 3.422 10.933 3.614v2.18c-1.721.448-3 2-3 3.858 0 2.206 1.794 4 4 4s4-1.794 4-4c0-1.858-1.279-3.41-3-3.858v-2.18c3.625-.189 7.09-1.392 10.112-3.435l2.135 2.135c-.15.42-.247.867-.247 1.338 0 2.206 1.794 4 4 4s4-1.794 4-4c0-2.205-1.794-4-4-4Z"
      />
    </g>
  </svg>
);

export const AmazonVPCIcon: React.FC<IconSvgProps> = ({
  size = 32,
  width,
  height,
  className = "rounded-md",
  ...props
}) => (
  <svg
    aria-hidden="false"
    aria-label="Amazon VPC logo"
    fill="none"
    focusable="false"
    height={size || height}
    role="presentation"
    viewBox="0 0 40 40"
    width={size || width}
    className={className}
    {...props}
    xmlns="http://www.w3.org/2000/svg"
  >
    <g fill="none" fillRule="evenodd">
      <path fill="#8C4FFF" d="M0 0h40v40H0z" />
      <path
        fill="#FFF"
        d="m30.97 21.03-2.943-1.264v10.49c2.545-.353 2.932-2.969 2.948-3.088l-.004-6.139Zm-3.943 9.24V19.76l-3.035 1.272v6.201c.013.054.445 2.767 3.035 3.036Zm.306-11.723a.5.5 0 0 1 .39.001l3.945 1.692a.5.5 0 0 1 .303.46v6.533c-.183 1.447-1.357 4.063-4.527 4.063-3.075 0-4.254-2.612-4.448-3.994l-.004-6.603c0-.2.12-.383.306-.46l4.035-1.692Zm5.65.637-5.461-2.406-5.53 2.327v7.128c-.001.042-.054 2.868 1.657 4.623.917.941 2.194 1.42 3.795 1.42 1.602 0 2.887-.48 3.819-1.423 1.735-1.758 1.72-4.585 1.72-4.613v-7.056ZM31.98 31.55c-1.127 1.144-2.654 1.725-4.536 1.725-1.884 0-3.404-.58-4.517-1.727-2.005-2.063-1.94-5.197-1.935-5.329v-7.446a.5.5 0 0 1 .305-.46l6.035-2.54a.5.5 0 0 1 .396.003l5.956 2.625c.182.08.299.26.299.457v7.375c.002.125.027 3.255-2.003 5.317Zm-20.988-7.314h8v1h-8c-2.811 0-4.811-2.016-4.98-5.016A3.745 3.745 0 0 1 6 19.841c0-2.509 1.318-4.223 3.817-4.979a8.352 8.352 0 0 1-.032-.647c0-2.916 1.577-5.445 4.017-6.445 3.298-1.348 7.042-.894 9.106 1.104a8.232 8.232 0 0 1 1.76 2.485c.609-.45 1.4-.66 2.349-.614 1.78.09 3.149 1.713 3.433 4.007 1.498.124 2.485.883 3.01 2.308l-.937.346c-.428-1.157-1.208-1.673-2.531-1.673a.5.5 0 0 1-.5-.47c-.138-2.338-1.406-3.463-2.526-3.519-.945-.053-1.645.22-2.08.791a.504.504 0 0 1-.472.193.503.503 0 0 1-.395-.323 7.378 7.378 0 0 0-1.807-2.814c-1.788-1.73-5.09-2.099-8.031-.895-2.063.845-3.396 3.011-3.396 5.52 0 .272.035.695.066.958a.498.498 0 0 1-.376.544C8.169 16.29 7 17.678 7 19.841c0 .101-.001.201.009.302.14 2.495 1.703 4.093 3.983 4.093Z"
      />
    </g>
  </svg>
);

export const getAWSIcon = (serviceAlias: string) => {
  switch (serviceAlias) {
    case "Amazon EC2":
      return <AmazonEC2Icon />;
    case "Amazon EMR":
      return <AmazonEMRIcon />;
    case "Amazon GuardDuty":
      return <AmazonGuardDutyIcon />;
    case "Amazon Inspector":
      return <AmazonInspectorIcon />;
    case "Amazon Macie":
      return <AmazonMacieIcon />;
    case "Amazon RDS":
      return <AmazonRDSIcon />;
    case "Amazon Route 53":
      return <AmazonRoute53Icon />;
    case "Amazon S3":
      return <AmazonS3Icon />;
    case "Amazon SNS":
      return <AmazonSNSIcon />;
    case "Amazon VPC":
      return <AmazonVPCIcon />;
    case "AWS Account":
      return <AWSAccountIcon />;
    case "AWS Athena":
      return <AWSAthenaIcon />;
    case "AWS Certificate Manager":
      return <AWSCertificateManagerIcon />;
    case "AWS CloudFormation":
      return <AWSCloudFormationIcon />;
    case "AWS CloudTrail":
      return <AWSCloudTrailIcon />;
    case "AWS CloudWatch":
      return <AWSCloudWatchIcon />;
    case "AWS Config":
      return <AWSConfigIcon />;
    case "AWS Database Migration":
      return <AWSDatabaseMigrationServiceIcon />;
    case "AWS Glue":
      return <AWSGlueIcon />;
    case "AWS IAM":
      return <AWSIAMIcon />;
    case "AWS Lambda":
      return <AWSLambdaIcon />;
    case "AWS Network Firewall":
      return <AWSNetworkFirewallIcon />;
    case "AWS Organizations":
      return <AWSOrganizationsIcon />;
    case "AWS Resource Explorer":
      return <AWSResourceExplorerIcon />;
    case "AWS Security Hub":
      return <AWSSecurityHubIcon />;
    case "AWS Systems Manager":
      return <AWSSystemsManagerIncidentManagerIcon />;
    case "AWS Trusted Advisor":
      return <AWSTrustedAdvisorIcon />;
    case "IAM Access Analyzer":
      return <IAMAccessAnalyzerIcon />;
    default:
      return null;
  }
};
