import csv
import json
import sys

# Convert a CSV file following the CIS 1.0 GitHub benchmark into a Prowler v3.0 Compliance JSON file
# CSV fields:
# Id, Title,Checks,Attributes_Section,Attributes_Level,Attributes_AssessmentStatus,Attributes_Description,Attributes_RationalStatement,Attributes_ImpactStatement,Attributes_RemediationProcedure,Attributes_AuditProcedure,Attributes_AdditionalInformation,Attributes_References

# get the CSV filename to convert from
file_name = sys.argv[1]

# read the CSV file rows and use the column fields to form the Prowler compliance JSON file 'cis_1.0_github.json'
output = {"Framework": "CIS-GitHub", "Version": "1.0", "Requirements": []}
with open(file_name, newline="", encoding="utf-8") as f:
    reader = csv.reader(f, delimiter=";")
    for row in reader:
        attribute = {
            "Section": row[0],
            "Subsection": row[1],
            "Profile": row[3],
            "AssessmentStatus": row[5],
            "Description": row[6],
            "RationaleStatement": row[7],
            "ImpactStatement": row[8],
            "RemediationProcedure": row[9],
            "AuditProcedure": row[10],
            "AdditionalInformation": row[11],
            "References": row[25],
            "DefaultValue": row[26],
        }
        output["Requirements"].append(
            {
                "Id": row[2],
                "Description": row[6],
                "Checks": [],
                "Attributes": [attribute],
            }
        )


# Write the output Prowler compliance JSON file 'cis_1.0_github.json' locally
with open("cis_1.0_github.json", "w", encoding="utf-8") as outfile:
    json.dump(output, outfile, indent=4, ensure_ascii=False)
