import { oneLine } from 'common-tags';
export function translateApiError(originalMessage) {
    const errMsg = originalMessage.includes('hibp-api-key')
        ? oneLine `
        Access denied due to invalid or missing API key. Please obtain an API
        key from https://haveibeenpwned.com/API/Key and then run "pwned apiKey"
        to configure pwned.
      `
        : originalMessage;
    return errMsg;
}
//# sourceMappingURL=translate-api-error.js.map