/*
 * Decompiled with CFR 0.152.
 */
package org.jpype.html;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.jpype.html.Html;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class HtmlWriter
implements Closeable {
    OutputStream os;
    BufferedWriter writer;

    public HtmlWriter(OutputStream outputStream) {
        this.os = outputStream;
        this.writer = new BufferedWriter(new OutputStreamWriter(outputStream));
    }

    public static String asString(Node node) throws IOException {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            HtmlWriter htmlWriter = new HtmlWriter(byteArrayOutputStream);
            htmlWriter.write(node);
            htmlWriter.close();
            String string = byteArrayOutputStream.toString();
            return string;
        }
    }

    public void write(Node node) throws IOException {
        if (node == null) {
            this.writer.write("NULL");
            return;
        }
        switch (node.getNodeType()) {
            case 7: {
                this.writeDirective((ProcessingInstruction)node);
                break;
            }
            case 1: {
                this.writeElement((Element)node);
                break;
            }
            case 11: {
                this.writeChildren(node);
                break;
            }
            case 3: {
                this.writeText((Text)node);
                break;
            }
            case 8: {
                this.writeComment((Comment)node);
                break;
            }
            case 4: {
                this.writeCData((CDATASection)node);
                break;
            }
            default: {
                throw new RuntimeException("unhandled " + String.valueOf(node.getClass()));
            }
        }
    }

    public void writeChildren(Node node) throws IOException {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            this.write(nodeList.item(i));
        }
    }

    public void writeDirective(ProcessingInstruction processingInstruction) throws IOException {
        this.writer.write("<!");
        this.writer.write(processingInstruction.getTarget());
        this.writer.write(" ");
        this.writer.write(processingInstruction.getData());
        this.writer.write(">");
    }

    public void writeElement(Element element) throws IOException {
        String string = element.getTagName();
        this.writer.write("<");
        this.writer.write(string);
        NamedNodeMap namedNodeMap = element.getAttributes();
        if (namedNodeMap.getLength() > 0) {
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                this.writer.write(" ");
                Attr attr = (Attr)namedNodeMap.item(i);
                this.writer.write(attr.getName());
                this.writer.write("=\"");
                this.writer.write(attr.getValue());
                this.writer.write(34);
            }
        }
        if (Html.VOID_ELEMENTS.contains(string)) {
            this.writer.write(">");
            return;
        }
        NodeList nodeList = element.getChildNodes();
        if (nodeList.getLength() == 0) {
            this.writer.write("/>");
        } else {
            this.writer.write(">");
            this.writeChildren(element);
            this.writer.write("</");
            this.writer.write(string);
            this.writer.write(">");
        }
    }

    private void writeComment(Comment comment) throws IOException {
        this.writer.write("<!--");
        this.writer.write(comment.getData());
        this.writer.write("-->");
    }

    private void writeCData(CDATASection cDATASection) throws IOException {
        this.writer.write("<![CDATA[");
        this.writer.write(cDATASection.getData());
        this.writer.write("]]>");
    }

    private void writeText(Text text) throws IOException {
        this.writer.write(text.getData());
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }
}

