import { AvailableFunction } from ".";
type Token = {
    type: string;
    value?: string;
};
export declare function tokenize(input: string): Token[];
type BaseNode = {
    type: string;
    attribute?: boolean;
    binding?: boolean;
    resolve?: boolean;
    filter?: QNode;
    value?: string;
    child?: QNode;
};
export type Selector = BaseNode & ({
    type: "child" | "descendant";
    attribute: boolean;
    binding: boolean;
    value: string;
    resolve: boolean;
} | {
    type: "parent";
});
export type Condition = BaseNode & {
    type: "and" | "or" | "equals";
    left: QNode;
    right: QNode;
};
export type Literal = BaseNode & {
    type: "literal";
    value: string;
};
export type FunctionCall = BaseNode & {
    type: "function";
    function: AvailableFunction;
    parameters: QNode[];
};
export type QNode = Selector | Condition | Literal | FunctionCall;
export declare function parse(input: string): QNode;
export {};
//# sourceMappingURL=parseQuery.d.ts.map