# frozen_string_literal: true

Sequel.migration do
  up do
    alter_table(:workspaces) do
      add_index :name, unique: true, name: :name_unique_index
    end

    from(:workspaces).insert(name: 'default')
  end

  down do
    alter_table(:workspaces) do
      drop_index :name, name: :name_unique_index
    end

    from(:workspaces).select(name: 'default').delete
  end
end
